/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.math.BlockRayTraceResult;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ItemUsageContext
extends HolderBase<ItemUseContext> {
    public ItemUsageContext(ItemUseContext data) {
        super(data);
    }

    @MappedMethod
    public static ItemUsageContext cast(HolderBase<?> data) {
        return new ItemUsageContext((ItemUseContext)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof ItemUseContext;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((ItemUseContext)this.data).equals(((HolderBase)data).data);
    }

    @MappedMethod
    public boolean shouldCancelInteraction() {
        return ((ItemUseContext)this.data).func_225518_g_();
    }

    @MappedMethod
    public float getPlayerYaw() {
        return ((ItemUseContext)this.data).func_195990_h();
    }

    @Nonnull
    @MappedMethod
    public Hand getHand() {
        return Hand.convert(((ItemUseContext)this.data).func_221531_n());
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getPlayer() {
        net.minecraft.entity.player.PlayerEntity tempData = ((ItemUseContext)this.data).func_195999_j();
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public ItemUsageContext(PlayerEntity arg0, Hand arg1, BlockHitResult arg2) {
        super(new ItemUseContext((net.minecraft.entity.player.PlayerEntity)arg0.data, arg1.data, (BlockRayTraceResult)arg2.data));
    }

    @Deprecated
    public ItemUsageContext(World arg0, @Nullable PlayerEntity arg1, Hand arg2, ItemStack arg3, BlockHitResult arg4) {
        super(new ItemUseContext((net.minecraft.world.World)arg0.data, arg1 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg1.data, arg2.data, (net.minecraft.item.ItemStack)arg3.data, (BlockRayTraceResult)arg4.data));
    }

    @Nonnull
    @MappedMethod
    public ItemStack getStack() {
        return new ItemStack(((ItemUseContext)this.data).func_195996_i());
    }

    @Nonnull
    @MappedMethod
    public BlockPos getBlockPos() {
        return new BlockPos(((ItemUseContext)this.data).func_195995_a());
    }

    @MappedMethod
    public boolean hitsInsideBlock() {
        return ((ItemUseContext)this.data).func_221533_k();
    }

    @Nonnull
    @MappedMethod
    public Direction getPlayerFacing() {
        return Direction.convert(((ItemUseContext)this.data).func_195992_f());
    }

    @Nonnull
    @MappedMethod
    public Vector3d getHitPos() {
        return new Vector3d(((ItemUseContext)this.data).func_221532_j());
    }

    @Nonnull
    @MappedMethod
    public World getWorld() {
        return new World(((ItemUseContext)this.data).func_195991_k());
    }

    @Nonnull
    @MappedMethod
    public Direction getSide() {
        return Direction.convert(((ItemUseContext)this.data).func_196000_l());
    }
}

