/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.GameConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.util.math.RayTraceResult;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BufferBuilderStorage;
import org.mtr.mapping.holder.ClientPlayNetworkHandler;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.EntityRenderDispatcher;
import org.mtr.mapping.holder.GameOptions;
import org.mtr.mapping.holder.GameRenderer;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.ResourceManager;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.SoundManager;
import org.mtr.mapping.holder.TextureManager;
import org.mtr.mapping.holder.Window;
import org.mtr.mapping.holder.WorldRenderer;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class MinecraftClient
extends HolderBase<Minecraft> {
    public MinecraftClient(Minecraft data) {
        super(data);
    }

    @MappedMethod
    public static MinecraftClient cast(HolderBase<?> data) {
        return new MinecraftClient((Minecraft)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof Minecraft;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((Minecraft)this.data).equals(((HolderBase)data).data);
    }

    @Nonnull
    @MappedMethod
    public BufferBuilderStorage getBufferBuilders() {
        return new BufferBuilderStorage(((Minecraft)this.data).func_228019_au_());
    }

    @Nonnull
    @MappedMethod
    public TextureManager getTextureManager() {
        return new TextureManager(((Minecraft)this.data).func_110434_K());
    }

    @MappedMethod
    public final boolean isDemo() {
        return ((Minecraft)this.data).func_71355_q();
    }

    @MappedMethod
    public void setCameraEntity(Entity arg0) {
        ((Minecraft)this.data).func_175607_a((net.minecraft.entity.Entity)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public ResourceManager getResourceManager() {
        return new ResourceManager(((Minecraft)this.data).func_195551_G());
    }

    @MappedMethod
    public void runTasks(BooleanSupplier arg0) {
        ((Minecraft)this.data).func_213161_c(arg0);
    }

    @MappedMethod
    public void tick() {
        ((Minecraft)this.data).func_71407_l();
    }

    @Nonnull
    @MappedMethod
    public DataFixer getDataFixer() {
        return ((Minecraft)this.data).func_184126_aj();
    }

    @MappedMethod
    public void openScreen(@Nullable Screen arg0) {
        ((Minecraft)this.data).func_147108_a(arg0 == null ? null : (net.minecraft.client.gui.screen.Screen)arg0.data);
    }

    @MappedMethod
    public void joinWorld(ClientWorld arg0) {
        ((Minecraft)this.data).func_71403_a((net.minecraft.client.world.ClientWorld)arg0.data);
    }

    @MappedMethod
    public boolean is64Bit() {
        return ((Minecraft)this.data).func_147111_S();
    }

    @MappedMethod
    public boolean isRunning() {
        return ((Minecraft)this.data).func_228025_l_();
    }

    @Nullable
    @MappedMethod
    public ClientPlayNetworkHandler getNetworkHandler() {
        ClientPlayNetHandler tempData = ((Minecraft)this.data).func_147114_u();
        return tempData == null ? null : new ClientPlayNetworkHandler(tempData);
    }

    @Nonnull
    @MappedMethod
    public Window getWindow() {
        return new Window(((Minecraft)this.data).func_228018_at_());
    }

    @Nonnull
    @MappedMethod
    public SoundManager getSoundManager() {
        return new SoundManager(((Minecraft)this.data).func_147118_V());
    }

    @MappedMethod
    public float getTickDelta() {
        return ((Minecraft)this.data).func_184121_ak();
    }

    @Nullable
    @MappedMethod
    public Entity getCameraEntity() {
        net.minecraft.entity.Entity tempData = ((Minecraft)this.data).func_175606_aa();
        return tempData == null ? null : new Entity(tempData);
    }

    @Nonnull
    @MappedMethod
    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return new EntityRenderDispatcher(((Minecraft)this.data).func_175598_ae());
    }

    @Nonnull
    @MappedMethod
    public static MinecraftClient getInstance() {
        return new MinecraftClient(Minecraft.func_71410_x());
    }

    @Nonnull
    @MappedMethod
    public CompletableFuture<Void> submit(Runnable arg0) {
        return ((Minecraft)this.data).func_222817_e(arg0);
    }

    @Nonnull
    @MappedMethod
    public <V> CompletableFuture<V> submit(Supplier<V> arg0) {
        return ((Minecraft)this.data).func_213169_a(arg0);
    }

    @MappedMethod
    public void run() {
        ((Minecraft)this.data).func_99999_d();
    }

    @MappedMethod
    public float getLastFrameDuration() {
        return ((Minecraft)this.data).func_193989_ak();
    }

    @MappedMethod
    public void close() {
        ((Minecraft)this.data).close();
    }

    @Nonnull
    @MappedMethod
    public Proxy getNetworkProxy() {
        return ((Minecraft)this.data).func_110437_J();
    }

    @Nonnull
    @MappedMethod
    public MinecraftSessionService getSessionService() {
        return ((Minecraft)this.data).func_152347_ac();
    }

    @Nonnull
    @MappedMethod
    public String getVersionType() {
        return ((Minecraft)this.data).func_184123_d();
    }

    @MappedMethod
    public boolean hasOutline(Entity arg0) {
        return ((Minecraft)this.data).func_238206_b_((net.minecraft.entity.Entity)arg0.data);
    }

    @Deprecated
    public MinecraftClient(GameConfiguration arg0) {
        super(new Minecraft(arg0));
    }

    @MappedMethod
    public void execute(Runnable arg0) {
        ((Minecraft)this.data).execute(arg0);
    }

    @MappedMethod
    public void stop() {
        ((Minecraft)this.data).func_71400_g();
    }

    @MappedMethod
    public boolean isPaused() {
        return ((Minecraft)this.data).func_147113_T();
    }

    @MappedMethod
    public static boolean getIsSystemMacMapped() {
        return Minecraft.field_142025_a;
    }

    @Nullable
    @MappedMethod
    public ClientPlayerEntity getPlayerMapped() {
        return ((Minecraft)this.data).field_71439_g == null ? null : new ClientPlayerEntity(((Minecraft)this.data).field_71439_g);
    }

    @MappedMethod
    public void setPlayerMapped(@Nullable ClientPlayerEntity newData) {
        ((Minecraft)this.data).field_71439_g = newData == null ? null : (net.minecraft.client.entity.player.ClientPlayerEntity)newData.data;
    }

    @Nonnull
    @MappedMethod
    public File getRunDirectoryMapped() {
        return ((Minecraft)this.data).field_71412_D;
    }

    @Nonnull
    @MappedMethod
    public WorldRenderer getWorldRendererMapped() {
        return new WorldRenderer(((Minecraft)this.data).field_71438_f);
    }

    @Nullable
    @MappedMethod
    public Screen getCurrentScreenMapped() {
        return ((Minecraft)this.data).field_71462_r == null ? null : new Screen(((Minecraft)this.data).field_71462_r);
    }

    @MappedMethod
    public void setCurrentScreenMapped(@Nullable Screen newData) {
        ((Minecraft)this.data).field_71462_r = newData == null ? null : (net.minecraft.client.gui.screen.Screen)newData.data;
    }

    @Nullable
    @MappedMethod
    public HitResult getCrosshairTargetMapped() {
        return ((Minecraft)this.data).field_71476_x == null ? null : new HitResult(((Minecraft)this.data).field_71476_x);
    }

    @MappedMethod
    public void setCrosshairTargetMapped(@Nullable HitResult newData) {
        ((Minecraft)this.data).field_71476_x = newData == null ? null : (RayTraceResult)newData.data;
    }

    @Nullable
    @MappedMethod
    public ClientWorld getWorldMapped() {
        return ((Minecraft)this.data).field_71441_e == null ? null : new ClientWorld(((Minecraft)this.data).field_71441_e);
    }

    @MappedMethod
    public void setWorldMapped(@Nullable ClientWorld newData) {
        ((Minecraft)this.data).field_71441_e = newData == null ? null : (net.minecraft.client.world.ClientWorld)newData.data;
    }

    @Nullable
    @MappedMethod
    public Entity getTargetedEntityMapped() {
        return ((Minecraft)this.data).field_147125_j == null ? null : new Entity(((Minecraft)this.data).field_147125_j);
    }

    @MappedMethod
    public void setTargetedEntityMapped(@Nullable Entity newData) {
        ((Minecraft)this.data).field_147125_j = newData == null ? null : (net.minecraft.entity.Entity)newData.data;
    }

    @Nullable
    @MappedMethod
    public Entity getCameraEntityMapped() {
        return ((Minecraft)this.data).field_175622_Z == null ? null : new Entity(((Minecraft)this.data).field_175622_Z);
    }

    @MappedMethod
    public void setCameraEntityMapped(@Nullable Entity newData) {
        ((Minecraft)this.data).field_175622_Z = newData == null ? null : (net.minecraft.entity.Entity)newData.data;
    }

    @Nonnull
    @MappedMethod
    public GameRenderer getGameRendererMapped() {
        return new GameRenderer(((Minecraft)this.data).field_71460_t);
    }

    @Nonnull
    @MappedMethod
    public GameOptions getOptionsMapped() {
        return new GameOptions(((Minecraft)this.data).field_71474_y);
    }

    @Nonnull
    @MappedMethod
    public String getFpsDebugStringMapped() {
        return ((Minecraft)this.data).field_71426_K;
    }

    @MappedMethod
    public void setFpsDebugStringMapped(String newData) {
        ((Minecraft)this.data).field_71426_K = newData;
    }
}

