/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.texture.NativeImage;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum NativeImageFormat {
    RGBA(NativeImage.PixelFormat.RGBA),
    RGB(NativeImage.PixelFormat.RGB),
    LUMINANCE_ALPHA(NativeImage.PixelFormat.LUMINANCE_ALPHA),
    LUMINANCE(NativeImage.PixelFormat.LUMINANCE);

    public final NativeImage.PixelFormat data;

    private NativeImageFormat(NativeImage.PixelFormat data) {
        this.data = data;
    }

    public static NativeImageFormat convert(@Nullable NativeImage.PixelFormat data) {
        return data == null ? null : NativeImageFormat.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable NativeImageFormat data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getAbgrMapped() {
        return NativeImageFormat.convert(NativeImage.PixelFormat.RGBA);
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getLuminanceAlphaMapped() {
        return NativeImageFormat.convert(NativeImage.PixelFormat.LUMINANCE_ALPHA);
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getBgrMapped() {
        return NativeImageFormat.convert(NativeImage.PixelFormat.RGB);
    }

    @Nonnull
    @MappedMethod
    public static NativeImageFormat getLuminanceMapped() {
        return NativeImageFormat.convert(NativeImage.PixelFormat.LUMINANCE);
    }
}

