/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.GameMode;
import org.mtr.mapping.holder.Team;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class PlayerListEntry
extends HolderBase<NetworkPlayerInfo> {
    public PlayerListEntry(NetworkPlayerInfo data) {
        super(data);
    }

    @MappedMethod
    public static PlayerListEntry cast(HolderBase<?> data) {
        return new PlayerListEntry((NetworkPlayerInfo)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof NetworkPlayerInfo;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((NetworkPlayerInfo)this.data).equals(((HolderBase)data).data);
    }

    @MappedMethod
    public int getLatency() {
        return ((NetworkPlayerInfo)this.data).func_178853_c();
    }

    @Nullable
    @MappedMethod
    public GameMode getGameMode() {
        GameType tempData = ((NetworkPlayerInfo)this.data).func_178848_b();
        return tempData == null ? null : GameMode.convert(tempData);
    }

    @Deprecated
    public PlayerListEntry(SPlayerListItemPacket.AddPlayerData arg0) {
        super(new NetworkPlayerInfo(arg0));
    }

    @Nullable
    @MappedMethod
    public Team getScoreboardTeam() {
        ScorePlayerTeam tempData = ((NetworkPlayerInfo)this.data).func_178850_i();
        return tempData == null ? null : new Team(tempData);
    }

    @Nonnull
    @MappedMethod
    public GameProfile getProfile() {
        return ((NetworkPlayerInfo)this.data).func_178845_a();
    }

    @Nullable
    @MappedMethod
    public Text getDisplayName() {
        ITextComponent tempData = ((NetworkPlayerInfo)this.data).func_178854_k();
        return tempData == null ? null : new Text(tempData);
    }

    @MappedMethod
    public void setDisplayName(@Nullable Text arg0) {
        ((NetworkPlayerInfo)this.data).func_178859_a(arg0 == null ? null : (ITextComponent)arg0.data);
    }
}

