/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Chunk;
import org.mtr.mapping.holder.ChunkGenerator;
import org.mtr.mapping.holder.ChunkPos;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldChunk;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ServerChunkManager
extends HolderBase<ServerChunkProvider> {
    public ServerChunkManager(ServerChunkProvider data) {
        super(data);
    }

    @MappedMethod
    public static ServerChunkManager cast(HolderBase<?> data) {
        return new ServerChunkManager((ServerChunkProvider)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof ServerChunkProvider;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((ServerChunkProvider)this.data).equals(((HolderBase)data).data);
    }

    @Nonnull
    @MappedMethod
    public String getChunkLoadingDebugInfo(ChunkPos arg0) {
        return ((ServerChunkProvider)this.data).func_217208_a((net.minecraft.util.math.ChunkPos)arg0.data);
    }

    @Nullable
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2, boolean arg3) {
        IChunk tempData = ((ServerChunkProvider)this.data).func_212849_a_(arg0, arg1, (net.minecraft.world.chunk.ChunkStatus)arg2.data, arg3);
        return tempData == null ? null : new Chunk(tempData);
    }

    @Nonnull
    @MappedMethod
    public World getWorld() {
        return new World(((ServerChunkProvider)this.data).func_212864_k_());
    }

    @MappedMethod
    public void updatePosition(ServerPlayerEntity arg0) {
        ((ServerChunkProvider)this.data).func_217221_a((net.minecraft.entity.player.ServerPlayerEntity)arg0.data);
    }

    @MappedMethod
    public void close() throws IOException {
        ((ServerChunkProvider)this.data).close();
    }

    @MappedMethod
    public boolean executeQueuedTasks() {
        return ((ServerChunkProvider)this.data).func_217234_d();
    }

    @MappedMethod
    public void markForUpdate(BlockPos arg0) {
        ((ServerChunkProvider)this.data).func_217217_a((net.minecraft.util.math.BlockPos)arg0.data);
    }

    @MappedMethod
    public void save(boolean arg0) {
        ((ServerChunkProvider)this.data).func_217210_a(arg0);
    }

    @MappedMethod
    public void setChunkForced(ChunkPos arg0, boolean arg1) {
        ((ServerChunkProvider)this.data).func_217206_a((net.minecraft.util.math.ChunkPos)arg0.data, arg1);
    }

    @Nullable
    @MappedMethod
    public WorldChunk getWorldChunk(int arg0, int arg1) {
        net.minecraft.world.chunk.Chunk tempData = ((ServerChunkProvider)this.data).func_225313_a(arg0, arg1);
        return tempData == null ? null : new WorldChunk(tempData);
    }

    @Nullable
    @MappedMethod
    public WorldChunk getWorldChunk(int arg0, int arg1, boolean arg2) {
        net.minecraft.world.chunk.Chunk tempData = ((ServerChunkProvider)this.data).func_217205_a(arg0, arg1, arg2);
        return tempData == null ? null : new WorldChunk(tempData);
    }

    @MappedMethod
    public boolean isChunkLoaded(int arg0, int arg1) {
        return ((ServerChunkProvider)this.data).func_73149_a(arg0, arg1);
    }

    @MappedMethod
    public void setMobSpawnOptions(boolean arg0, boolean arg1) {
        ((ServerChunkProvider)this.data).func_217203_a(arg0, arg1);
    }

    @Nonnull
    @MappedMethod
    public String getDebugString() {
        return ((ServerChunkProvider)this.data).func_73148_d();
    }

    @Nonnull
    @MappedMethod
    public ChunkGenerator getChunkGenerator() {
        return new ChunkGenerator(((ServerChunkProvider)this.data).func_201711_g());
    }

    @Deprecated
    public ServerChunkManager(ServerWorld arg0, SaveFormat.LevelSave arg1, DataFixer arg2, TemplateManager arg3, Executor arg4, ChunkGenerator arg5, int arg6, boolean arg7, IChunkStatusListener arg8, Supplier<DimensionSavedDataManager> arg9) {
        super(new ServerChunkProvider((net.minecraft.world.server.ServerWorld)arg0.data, arg1, arg2, arg3, arg4, (net.minecraft.world.gen.ChunkGenerator)arg5.data, arg6, arg7, arg8, arg9));
    }
}

