/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.chunk.IChunk;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Chunk;
import org.mtr.mapping.holder.ChunkManager;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.Difficulty;
import org.mtr.mapping.holder.DimensionType;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.FluidState;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.ParticleEffect;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ServerWorldAccess
extends HolderBase<IServerWorld> {
    public ServerWorldAccess(IServerWorld data) {
        super(data);
    }

    @MappedMethod
    public static ServerWorldAccess cast(HolderBase<?> data) {
        return new ServerWorldAccess((IServerWorld)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof IServerWorld;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((IServerWorld)this.data).equals(((HolderBase)data).data);
    }

    @Nullable
    @MappedMethod
    public BlockHitResult raycastBlock(Vector3d arg0, Vector3d arg1, BlockPos arg2, VoxelShape arg3, BlockState arg4) {
        BlockRayTraceResult tempData = ((IServerWorld)this.data).func_217296_a((net.minecraft.util.math.vector.Vector3d)arg0.data, (net.minecraft.util.math.vector.Vector3d)arg1.data, (net.minecraft.util.math.BlockPos)arg2.data, (net.minecraft.util.math.shapes.VoxelShape)arg3.data, (net.minecraft.block.BlockState)arg4.data);
        return tempData == null ? null : new BlockHitResult(tempData);
    }

    @MappedMethod
    public long getLunarTime() {
        return ((IServerWorld)this.data).func_241851_ab();
    }

    @Nonnull
    @MappedMethod
    public DimensionType getDimension() {
        return new DimensionType(((IServerWorld)this.data).func_230315_m_());
    }

    @MappedMethod
    public float getSkyAngle(float arg0) {
        return ((IServerWorld)this.data).func_242415_f(arg0);
    }

    @MappedMethod
    public int getAmbientDarkness() {
        return ((IServerWorld)this.data).func_175657_ab();
    }

    @Nonnull
    @MappedMethod
    public BlockPos getTopPosition(HeightMapType arg0, BlockPos arg1) {
        return new BlockPos(((IServerWorld)this.data).func_205770_a(arg0.data, (net.minecraft.util.math.BlockPos)arg1.data));
    }

    @MappedMethod
    public boolean isRegionLoaded(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return ((IServerWorld)this.data).func_217344_a(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    @MappedMethod
    public boolean isRegionLoaded(BlockPos arg0, BlockPos arg1) {
        return ((IServerWorld)this.data).func_175707_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data);
    }

    @MappedMethod
    public double getDismountHeight(BlockPos arg0) {
        return ((IServerWorld)this.data).func_242403_h((net.minecraft.util.math.BlockPos)arg0.data);
    }

    @MappedMethod
    public boolean isPlayerInRange(double arg0, double arg1, double arg2, double arg3) {
        return ((IServerWorld)this.data).func_217358_a(arg0, arg1, arg2, arg3);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(double arg0, double arg1, double arg2, double arg3, boolean arg4) {
        net.minecraft.entity.player.PlayerEntity tempData = ((IServerWorld)this.data).func_217366_a(arg0, arg1, arg2, arg3, arg4);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @Nonnull
    @MappedMethod
    public ChunkManager getChunkManager() {
        return new ChunkManager(((IServerWorld)this.data).func_72863_F());
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(Entity arg0, double arg1) {
        net.minecraft.entity.player.PlayerEntity tempData = ((IServerWorld)this.data).func_217362_a((net.minecraft.entity.Entity)arg0.data, arg1);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @Nonnull
    @MappedMethod
    public BlockState getBlockState(BlockPos arg0) {
        return new BlockState(((IServerWorld)this.data).func_180495_p((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Difficulty getDifficulty() {
        return Difficulty.convert(((IServerWorld)this.data).func_175659_aa());
    }

    @MappedMethod
    public boolean canPlace(BlockState arg0, BlockPos arg1, ShapeContext arg2) {
        return ((IServerWorld)this.data).func_226663_a_((net.minecraft.block.BlockState)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data, (ISelectionContext)arg2.data);
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(BlockPos arg0) {
        return new Chunk(((IServerWorld)this.data).func_217349_x((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2) {
        return new Chunk(((IServerWorld)this.data).func_217348_a(arg0, arg1, (net.minecraft.world.chunk.ChunkStatus)arg2.data));
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1) {
        return new Chunk(((IServerWorld)this.data).func_212866_a_(arg0, arg1));
    }

    @Nullable
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2, boolean arg3) {
        IChunk tempData = ((IServerWorld)this.data).func_217353_a(arg0, arg1, (net.minecraft.world.chunk.ChunkStatus)arg2.data, arg3);
        return tempData == null ? null : new Chunk(tempData);
    }

    @MappedMethod
    public int getLightLevel(LightType arg0, BlockPos arg1) {
        return ((IServerWorld)this.data).func_226658_a_(arg0.data, (net.minecraft.util.math.BlockPos)arg1.data);
    }

    @MappedMethod
    public void addParticle(ParticleEffect arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
        ((IServerWorld)this.data).func_195594_a((IParticleData)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getPlayerByUuid(UUID arg0) {
        net.minecraft.entity.player.PlayerEntity tempData = ((IServerWorld)this.data).func_217371_b(arg0);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public boolean removeBlock(BlockPos arg0, boolean arg1) {
        return ((IServerWorld)this.data).func_217377_a((net.minecraft.util.math.BlockPos)arg0.data, arg1);
    }

    @MappedMethod
    public void syncWorldEvent(@Nullable PlayerEntity arg0, int arg1, BlockPos arg2, int arg3) {
        ((IServerWorld)this.data).func_217378_a(arg0 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg0.data, arg1, (net.minecraft.util.math.BlockPos)arg2.data, arg3);
    }

    @MappedMethod
    public void syncWorldEvent(int arg0, BlockPos arg1, int arg2) {
        ((IServerWorld)this.data).func_217379_c(arg0, (net.minecraft.util.math.BlockPos)arg1.data, arg2);
    }

    @Nullable
    @MappedMethod
    public BlockEntity getBlockEntity(BlockPos arg0) {
        TileEntity tempData = ((IServerWorld)this.data).func_175625_s((net.minecraft.util.math.BlockPos)arg0.data);
        return tempData == null ? null : new BlockEntity(tempData);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2, int arg3) {
        return ((IServerWorld)this.data).func_241211_a_((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.BlockState)arg1.data, arg2, arg3);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2) {
        return ((IServerWorld)this.data).func_180501_a((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.BlockState)arg1.data, arg2);
    }

    @MappedMethod
    public void spawnEntityAndPassengers(Entity arg0) {
        ((IServerWorld)this.data).func_242417_l((net.minecraft.entity.Entity)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public Random getRandom() {
        return new Random(((IServerWorld)this.data).func_201674_k());
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1) {
        return ((IServerWorld)this.data).func_175655_b((net.minecraft.util.math.BlockPos)arg0.data, arg1);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2, int arg3) {
        return ((IServerWorld)this.data).func_241212_a_((net.minecraft.util.math.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.entity.Entity)arg2.data, arg3);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2) {
        return ((IServerWorld)this.data).func_225521_a_((net.minecraft.util.math.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.entity.Entity)arg2.data);
    }

    @MappedMethod
    public boolean isClient() {
        return ((IServerWorld)this.data).func_201670_d();
    }

    @Nonnull
    @MappedMethod
    public FluidState getFluidState(BlockPos arg0) {
        return new FluidState(((IServerWorld)this.data).func_204610_c((net.minecraft.util.math.BlockPos)arg0.data));
    }

    @MappedMethod
    public int getMoonPhase() {
        return ((IServerWorld)this.data).func_242414_af();
    }

    @MappedMethod
    public void updateNeighbors(BlockPos arg0, Block arg1) {
        ((IServerWorld)this.data).func_230547_a_((net.minecraft.util.math.BlockPos)arg0.data, (net.minecraft.block.Block)arg1.data);
    }

    @MappedMethod
    public boolean doesNotIntersectEntities(@Nullable Entity arg0, VoxelShape arg1) {
        return ((IServerWorld)this.data).func_195585_a(arg0 == null ? null : (net.minecraft.entity.Entity)arg0.data, (net.minecraft.util.math.shapes.VoxelShape)arg1.data);
    }

    @MappedMethod
    public int getTopY(HeightMapType arg0, int arg1, int arg2) {
        return ((IServerWorld)this.data).func_201676_a(arg0.data, arg1, arg2);
    }

    @MappedMethod
    public int getHeight() {
        return ((IServerWorld)this.data).func_234938_ad_();
    }

    @MappedMethod
    public int getSeaLevel() {
        return ((IServerWorld)this.data).func_181545_F();
    }

    @MappedMethod
    public void playSound(@Nullable PlayerEntity arg0, BlockPos arg1, SoundEvent arg2, SoundCategory arg3, float arg4, float arg5) {
        ((IServerWorld)this.data).func_184133_a(arg0 == null ? null : (net.minecraft.entity.player.PlayerEntity)arg0.data, (net.minecraft.util.math.BlockPos)arg1.data, (net.minecraft.util.SoundEvent)arg2.data, arg3.data, arg4, arg5);
    }

    @Nonnull
    @MappedMethod
    public ServerWorld toServerWorld() {
        return new ServerWorld(((IServerWorld)this.data).func_201672_e());
    }

    @Nullable
    @MappedMethod
    public BlockView getChunkAsView(int arg0, int arg1) {
        IBlockReader tempData = ((IServerWorld)this.data).func_225522_c_(arg0, arg1);
        return tempData == null ? null : new BlockView(tempData);
    }

    @MappedMethod
    public int getMaxLightLevel() {
        return ((IServerWorld)this.data).func_201572_C();
    }

    @MappedMethod
    public float getMoonSize() {
        return ((IServerWorld)this.data).func_242413_ae();
    }

    @MappedMethod
    public float getBrightness(Direction arg0, boolean arg1) {
        return ((IServerWorld)this.data).func_230487_a_(arg0.data, arg1);
    }
}

