/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.text.ITextComponent;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.tool.DummyInterface;
import org.mtr.mapping.tool.HolderBase;

public interface BlockHelper
extends DummyInterface {
    @MappedMethod
    default public void addBlockProperties(List<HolderBase<?>> properties) {
    }

    @Deprecated
    default public void createBlockStateDefinitionHelper(StateContainer.Builder<Block, net.minecraft.block.BlockState> builder) {
        ArrayList properties = new ArrayList();
        this.addBlockProperties(properties);
        if (!properties.isEmpty()) {
            Property[] newProperties = new Property[properties.size()];
            for (int i = 0; i < properties.size(); ++i) {
                Object data = ((HolderBase)properties.get((int)i)).data;
                if (!(data instanceof Property)) continue;
                newProperties[i] = (Property)data;
            }
            builder.func_206894_a(newProperties);
        }
    }

    @MappedMethod
    default public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
    }

    @Deprecated
    default public void appendTooltipHelper(ItemStack stack, @Nullable BlockView world, List<ITextComponent> tooltipList, TooltipContext options) {
        ArrayList<MutableText> newTooltipList = new ArrayList<MutableText>();
        this.addTooltips(stack, world, newTooltipList, options);
        newTooltipList.forEach(mutableText -> tooltipList.add((ITextComponent)mutableText.data));
    }

    @MappedMethod
    public static BlockSettings setLuminance(BlockSettings blockSettings, ToIntFunction<BlockState> luminanceFunction) {
        return new BlockSettings(((AbstractBlock.Properties)blockSettings.data).func_235838_a_(blockState -> luminanceFunction.applyAsInt(new BlockState((net.minecraft.block.BlockState)blockState))));
    }

    @MappedMethod
    public static BlockSettings createBlockSettings(boolean blockPiston, boolean forceSolid) {
        return new BlockSettings(AbstractBlock.Properties.func_200945_a((Material)(blockPiston ? Material.field_151574_g : Material.field_151573_f)));
    }

    @MappedMethod
    public static BlockSettings createBlockSettings(boolean blockPiston, boolean forceSolid, ToIntFunction<BlockState> luminanceFunction) {
        return BlockHelper.setLuminance(BlockHelper.createBlockSettings(blockPiston, forceSolid), luminanceFunction);
    }

    @MappedMethod
    public static VoxelShape shapeUnion(VoxelShape voxelShape, VoxelShape ... voxelShapes) {
        VoxelShape result = voxelShape;
        for (VoxelShape additionalShape : voxelShapes) {
            result = VoxelShapes.union(result, additionalShape);
        }
        return result;
    }
}

