/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mapping.tool.DummyClass;

public final class GraphicsHolder
extends DummyClass {
    IVertexBuilder vertexConsumer;
    private int matrixPushes;
    final MatrixStack matrixStack;
    private final IRenderTypeBuffer vertexConsumerProvider;

    @MappedMethod
    public static int getDefaultLight() {
        return 0xF000F0;
    }

    @Deprecated
    public static void createInstanceSafe(@Nullable MatrixStack matrixStack, @Nullable IRenderTypeBuffer vertexConsumerProvider, Consumer<GraphicsHolder> consumer) {
        GraphicsHolder graphicsHolder = new GraphicsHolder(matrixStack, vertexConsumerProvider);
        try {
            consumer.accept(graphicsHolder);
        }
        catch (Exception e) {
            GraphicsHolder.logException(e);
        }
        while (graphicsHolder.matrixPushes > 0) {
            graphicsHolder.pop();
        }
    }

    private GraphicsHolder(@Nullable MatrixStack matrixStack, @Nullable IRenderTypeBuffer vertexConsumerProvider) {
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.push();
    }

    @MappedMethod
    public void push() {
        if (this.matrixStack != null) {
            this.matrixStack.func_227860_a_();
            ++this.matrixPushes;
        }
    }

    @MappedMethod
    public void pop() {
        if (this.matrixStack != null && this.matrixPushes > 0) {
            this.matrixStack.func_227865_b_();
            --this.matrixPushes;
        }
    }

    @MappedMethod
    public void translate(double x, double y, double z) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227861_a_(x, y, z);
        }
    }

    @MappedMethod
    public void scale(float x, float y, float z) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227862_a_(x, y, z);
        }
    }

    @MappedMethod
    public void rotateXRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(angle));
        }
    }

    @MappedMethod
    public void rotateYRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(angle));
        }
    }

    @MappedMethod
    public void rotateZRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(angle));
        }
    }

    @MappedMethod
    public void rotateXDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(angle));
        }
    }

    @MappedMethod
    public void rotateYDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        }
    }

    @MappedMethod
    public void rotateZDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
        }
    }

    @MappedMethod
    public void drawText(MutableText mutableText, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            GraphicsHolder.getInstance().field_71466_p.func_243247_a((ITextComponent)mutableText.data, (float)x, (float)y, color, shadow, this.matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, light);
            immediate.func_228461_a_();
        }
    }

    @MappedMethod
    public void drawText(OrderedText orderedText, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            GraphicsHolder.getInstance().field_71466_p.func_238416_a_((IReorderingProcessor)orderedText.data, (float)x, (float)y, color, shadow, this.matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, light);
            immediate.func_228461_a_();
        }
    }

    @MappedMethod
    public void drawText(String text, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            GraphicsHolder.getInstance().field_71466_p.func_228079_a_(text, (float)x, (float)y, color, shadow, this.matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, light);
            immediate.func_228461_a_();
        }
    }

    @MappedMethod
    public void drawCenteredText(String text, int centerX, int y, int color) {
        if (this.matrixStack != null) {
            AbstractGui.func_238471_a_((MatrixStack)this.matrixStack, (FontRenderer)GraphicsHolder.getInstance().field_71466_p, (String)text, (int)centerX, (int)y, (int)color);
        }
    }

    @MappedMethod
    public void drawCenteredText(MutableText text, int centerX, int y, int color) {
        if (this.matrixStack != null) {
            AbstractGui.func_238472_a_((MatrixStack)this.matrixStack, (FontRenderer)GraphicsHolder.getInstance().field_71466_p, (ITextComponent)((ITextComponent)text.data), (int)centerX, (int)y, (int)color);
        }
    }

    @MappedMethod
    public static int getTextWidth(MutableText mutableText) {
        return GraphicsHolder.getInstance().field_71466_p.func_238414_a_((ITextProperties)mutableText.data);
    }

    @MappedMethod
    public static int getTextWidth(OrderedText orderedText) {
        return GraphicsHolder.getInstance().field_71466_p.func_243245_a((IReorderingProcessor)orderedText.data);
    }

    @MappedMethod
    public static int getTextWidth(String text) {
        return GraphicsHolder.getInstance().field_71466_p.func_78256_a(text);
    }

    @MappedMethod
    public static List<OrderedText> wrapLines(MutableText mutableText, int width) {
        return GraphicsHolder.getInstance().field_71466_p.func_238425_b_((ITextProperties)mutableText.data, width).stream().map(OrderedText::new).collect(Collectors.toList());
    }

    private static Minecraft getInstance() {
        return Minecraft.func_71410_x();
    }

    @MappedMethod
    public void createVertexConsumer(RenderLayer renderLayer) {
        if (this.vertexConsumerProvider != null) {
            this.vertexConsumer = this.vertexConsumerProvider.getBuffer((RenderType)renderLayer.data);
        }
    }

    @MappedMethod
    public void drawLineInWorld(float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        if (this.matrixStack != null && this.vertexConsumer != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                MatrixStack.Entry entry = this.matrixStack.func_227866_c_();
                Matrix4f matrix4f = entry.func_227870_a_();
                Matrix3f matrix3f = entry.func_227872_b_();
                this.vertexConsumer.func_227888_a_(matrix4f, x1, y1, z1).func_225586_a_(r, g, b, a).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
                this.vertexConsumer.func_227888_a_(matrix4f, x2, y2, z2).func_225586_a_(r, g, b, a).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
            });
        }
    }

    @MappedMethod
    public void drawTextureInWorld(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        if (this.matrixStack != null && this.vertexConsumer != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                Vector3i vector3i = facing.getVector();
                int x = vector3i.getX();
                int y = vector3i.getY();
                int z = vector3i.getZ();
                MatrixStack.Entry entry = this.matrixStack.func_227866_c_();
                Matrix4f matrix4f = entry.func_227870_a_();
                Matrix3f matrix3f = entry.func_227872_b_();
                this.vertexConsumer.func_227888_a_(matrix4f, x1, y1, z1).func_225586_a_(r, g, b, a).func_225583_a_(u1, v2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)x, (float)y, (float)z).func_181675_d();
                this.vertexConsumer.func_227888_a_(matrix4f, x2, y2, z2).func_225586_a_(r, g, b, a).func_225583_a_(u2, v2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)x, (float)y, (float)z).func_181675_d();
                this.vertexConsumer.func_227888_a_(matrix4f, x3, y3, z3).func_225586_a_(r, g, b, a).func_225583_a_(u2, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)x, (float)y, (float)z).func_181675_d();
                this.vertexConsumer.func_227888_a_(matrix4f, x4, y4, z4).func_225586_a_(r, g, b, a).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, (float)x, (float)y, (float)z).func_181675_d();
            });
        }
    }

    @MappedMethod
    public void renderEntity(org.mtr.mapping.holder.Entity entity, double x, double y, double z, float yaw, float tickDelta, int light) {
        if (this.matrixStack != null && this.vertexConsumerProvider != null) {
            GraphicsHolder.getInstance().func_175598_ae().func_229084_a_((Entity)entity.data, x, y, z, yaw, tickDelta, this.matrixStack, this.vertexConsumerProvider, light);
        }
    }
}

