/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mapping.tool.DummyClass;

public final class GuiDrawing
extends DummyClass {
    private BufferBuilder bufferBuilder;
    private Matrix4f matrix;
    private final GraphicsHolder graphicsHolder;

    @MappedMethod
    public GuiDrawing(GraphicsHolder graphicsHolder) {
        this.graphicsHolder = graphicsHolder;
    }

    @MappedMethod
    public void beginDrawingRectangle() {
        this.matrix = this.graphicsHolder.matrixStack == null ? null : this.graphicsHolder.matrixStack.func_227866_c_().func_227870_a_();
        this.bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        this.bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
    }

    @MappedMethod
    public void drawRectangle(double x1, double y1, double x2, double y2, int color) {
        if (this.matrix != null && this.bufferBuilder != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x1, (float)y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x1, (float)y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x2, (float)y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x2, (float)y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            });
        }
    }

    @MappedMethod
    public void drawRectangle(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int color) {
        if (this.matrix != null && this.bufferBuilder != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x1, (float)y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x2, (float)y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x3, (float)y3, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
                this.bufferBuilder.func_227888_a_(this.matrix, (float)x4, (float)y4, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            });
        }
    }

    @MappedMethod
    public void finishDrawingRectangle() {
        if (this.bufferBuilder != null) {
            this.bufferBuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.bufferBuilder);
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
        }
    }

    @MappedMethod
    public void beginDrawingTexture(Identifier identifier) {
        this.matrix = this.graphicsHolder.matrixStack == null ? null : this.graphicsHolder.matrixStack.func_227866_c_().func_227870_a_();
        this.bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        MinecraftClient.getInstance().getTextureManager().bindTexture(identifier);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
    }

    @MappedMethod
    public void drawTexture(double x1, double y1, double x2, double y2, float u1, float v1, float u2, float v2) {
        if (this.matrix != null && this.bufferBuilder != null) {
            this.bufferBuilder.func_227888_a_(this.matrix, (float)x1, (float)y1, 0.0f).func_225583_a_(u1, v1).func_181675_d();
            this.bufferBuilder.func_227888_a_(this.matrix, (float)x1, (float)y2, 0.0f).func_225583_a_(u1, v2).func_181675_d();
            this.bufferBuilder.func_227888_a_(this.matrix, (float)x2, (float)y2, 0.0f).func_225583_a_(u2, v2).func_181675_d();
            this.bufferBuilder.func_227888_a_(this.matrix, (float)x2, (float)y1, 0.0f).func_225583_a_(u2, v1).func_181675_d();
        }
    }

    @MappedMethod
    public void finishDrawingTexture() {
        if (this.bufferBuilder != null) {
            this.bufferBuilder.func_178977_d();
            RenderSystem.enableAlphaTest();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.bufferBuilder);
        }
    }
}

