/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.particles.BasicParticleType;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Particle;
import org.mtr.mapping.holder.SpriteBillboardParticle;
import org.mtr.mapping.holder.SpriteProvider;
import org.mtr.mapping.tool.DummyClass;

public abstract class ParticleFactoryExtension
implements IParticleFactory<BasicParticleType> {
    private final CreateParticle createParticle;
    private final CreateSpriteBillboardParticle createSpriteBillboardParticle;
    private final SpriteProvider spriteProvider;

    @MappedMethod
    public ParticleFactoryExtension(CreateParticle createParticle, SpriteProvider spriteProvider) {
        this.createParticle = createParticle;
        this.createSpriteBillboardParticle = null;
        this.spriteProvider = spriteProvider;
    }

    @MappedMethod
    public ParticleFactoryExtension(CreateSpriteBillboardParticle createSpriteBillboardParticle, SpriteProvider spriteProvider) {
        this.createParticle = null;
        this.createSpriteBillboardParticle = createSpriteBillboardParticle;
        this.spriteProvider = spriteProvider;
    }

    @Deprecated
    public final net.minecraft.client.particle.Particle createParticle(BasicParticleType defaultParticleType, net.minecraft.client.world.ClientWorld clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        if (this.createParticle != null) {
            return (net.minecraft.client.particle.Particle)this.createParticle.create((ClientWorld)new ClientWorld((net.minecraft.client.world.ClientWorld)clientWorld), (double)x, (double)y, (double)z, (double)velocityX, (double)velocityY, (double)velocityZ).data;
        }
        if (this.createSpriteBillboardParticle != null) {
            SpriteBillboardParticle spriteBillboardParticle = this.createSpriteBillboardParticle.create(new ClientWorld(clientWorld), x, y, z, velocityX, velocityY, velocityZ);
            ((SpriteTexturedParticle)spriteBillboardParticle.data).func_217568_a((IAnimatedSprite)this.spriteProvider.data);
            return (net.minecraft.client.particle.Particle)spriteBillboardParticle.data;
        }
        NullPointerException nullPointerException = new NullPointerException("Both createParticle and createSpriteBillboardParticle are null!");
        DummyClass.logException(nullPointerException);
        throw nullPointerException;
    }

    @FunctionalInterface
    public static interface CreateSpriteBillboardParticle {
        @MappedMethod
        public SpriteBillboardParticle create(ClientWorld var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }

    @FunctionalInterface
    public static interface CreateParticle {
        @MappedMethod
        public Particle create(ClientWorld var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

