/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.MinecraftVersion;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.tool.DummyClass;

public final class ResourceManagerHelper
extends DummyClass {
    @MappedMethod
    public static void readResource(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            ResourceManagerHelper.readResource(Minecraft.func_71410_x().func_195551_G().func_199002_a((ResourceLocation)identifier.data), consumer);
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static String readResource(Identifier identifier) {
        String[] string = new String[]{""};
        ResourceManagerHelper.readResource(identifier, (InputStream inputStream2) -> {
            try {
                string[0] = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        });
        return string[0];
    }

    @MappedMethod
    public static void readAllResources(Identifier identifier, Consumer<InputStream> consumer) {
        try {
            Minecraft.func_71410_x().func_195551_G().func_199004_b((ResourceLocation)identifier.data).forEach(resource -> ResourceManagerHelper.readResource(resource, consumer));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static void readDirectory(String path, BiConsumer<Identifier, InputStream> consumer) {
        try {
            Minecraft.func_71410_x().func_195551_G().func_199003_a(path, identifier -> true).forEach(identifier -> ResourceManagerHelper.readAllResources(new Identifier((ResourceLocation)identifier), inputStream2 -> consumer.accept(new Identifier((ResourceLocation)identifier), (InputStream)inputStream2)));
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    private static void readResource(IResource resource, Consumer<InputStream> consumer) {
        try (IResource newResource = resource;){
            try (InputStream inputStream2 = newResource.func_199027_b();){
                consumer.accept(inputStream2);
            }
            catch (Exception e) {
                ResourceManagerHelper.logException(e);
            }
        }
        catch (Exception e) {
            ResourceManagerHelper.logException(e);
        }
    }

    @MappedMethod
    public static int getResourcePackVersion() {
        return MinecraftVersion.func_214957_a().getPackVersion();
    }

    @MappedMethod
    public static int getDataPackVersion() {
        return 0;
    }
}

