/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFieldWidgetAbstractMapping;
import org.mtr.mapping.holder.TextRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;

public class TextFieldWidgetExtension
extends TextFieldWidgetAbstractMapping {
    private final int maxLength;
    private final TextCase textCase;
    private final String filter;
    private final String suggestion;

    @MappedMethod
    public TextFieldWidgetExtension(int x, int y, int width, int height, int maxLength, TextCase textCase, @RegEx @Nullable String filter, @Nullable String suggestion) {
        this(x, y, width, height, "", maxLength, textCase, filter, suggestion);
    }

    @MappedMethod
    public TextFieldWidgetExtension(int x, int y, int width, int height, String message, int maxLength, TextCase textCase, @RegEx @Nullable String filter, @Nullable String suggestion) {
        this(x, y, width, height, TextHelper.literal(message), maxLength, textCase, filter, suggestion);
    }

    @MappedMethod
    public TextFieldWidgetExtension(int x, int y, int width, int height, MutableText text, int maxLength, TextCase textCase, @RegEx @Nullable String filter, @Nullable String suggestion) {
        super(new TextRenderer(Minecraft.func_71410_x().field_71466_p), x, y, width, height, new Text((ITextComponent)text.data));
        this.maxLength = maxLength;
        this.textCase = textCase;
        this.filter = filter;
        this.suggestion = suggestion;
        this.setChangedListener2(value -> {});
        this.setMaxLength2(0);
    }

    @MappedMethod
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        if (graphicsHolder.matrixStack != null) {
            super.func_230431_b_(graphicsHolder.matrixStack, mouseX, mouseY, delta);
        }
    }

    @Deprecated
    public final void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        GraphicsHolder.createInstanceSafe(matrices, null, graphicsHolder -> this.render((GraphicsHolder)graphicsHolder, mouseX, mouseY, delta));
    }

    @Deprecated
    public final boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        return this.mouseScrolled2(mouseX, mouseY, amount);
    }

    @MappedMethod
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    @Override
    @MappedMethod
    public final void setChangedListener2(Consumer<String> changedListener) {
        super.setChangedListener2(text -> {
            String newText;
            if (this.filter == null || this.filter.isEmpty()) {
                newText = this.trySetLength(this.textCase.convert.apply((String)text));
            } else {
                newText = this.trySetLength(this.textCase.convert.apply((String)text).replaceAll(this.filter, ""));
                if (!newText.equals(text)) {
                    this.setText2(newText);
                }
            }
            this.setSuggestion2(newText.isEmpty() && this.suggestion != null ? this.suggestion : "");
            changedListener.accept(newText);
        });
    }

    @Override
    @MappedMethod
    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        if (this.isVisible2() && TextFieldWidgetExtension.isBetween(mouseX, this.getX2(), this.getX2() + this.field_230688_j_) && TextFieldWidgetExtension.isBetween(mouseY, this.getY2(), this.getY2() + this.field_230689_k_)) {
            if (button == 1) {
                this.setText2("");
            }
            return super.mouseClicked2(mouseX, mouseY, 0);
        }
        this.setTextFieldFocused2(false);
        return false;
    }

    @Deprecated
    public final void func_146178_a() {
        this.tick2();
    }

    @MappedMethod
    public void tick2() {
        super.func_146178_a();
    }

    @Override
    @Deprecated
    public final void setMaxLength2(int maxLength) {
        super.setMaxLength2(Integer.MAX_VALUE);
    }

    private String trySetLength(String text) {
        return text.isEmpty() ? "" : text.substring(0, Math.min(this.maxLength, text.length()));
    }

    private static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    @MappedMethod
    public final int getX2() {
        return this.field_230690_l_;
    }

    @MappedMethod
    public final int getY2() {
        return this.field_230691_m_;
    }

    @Override
    @MappedMethod
    public final void setX2(int x) {
        this.field_230690_l_ = x;
    }

    @MappedMethod
    public final void setY2(int y) {
        this.field_230691_m_ = y;
    }

    @MappedMethod
    public final boolean func_230449_g_() {
        return super.func_230449_g_();
    }
}

