/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.tool.DummyClass;

public final class CommandBuilder<T extends ArgumentBuilder<CommandSource, T>>
extends DummyClass {
    T argumentBuilder;

    CommandBuilder(T argumentBuilder) {
        this.argumentBuilder = argumentBuilder;
    }

    @MappedMethod
    public void permissionLevel(int permissionLevel) {
        this.argumentBuilder = this.argumentBuilder.requires(serverCommandSource -> serverCommandSource.func_197034_c(permissionLevel));
    }

    @MappedMethod
    public <U> void then(String argumentName, ArgumentType<U> argumentType, Consumer<CommandBuilder<?>> consumer) {
        CommandBuilder<RequiredArgumentBuilder> commandBuilder = new CommandBuilder<RequiredArgumentBuilder>(Commands.func_197056_a((String)argumentName, argumentType));
        consumer.accept(commandBuilder);
        this.argumentBuilder = this.argumentBuilder.then(commandBuilder.argumentBuilder);
    }

    @MappedMethod
    public void then(String commandName, Consumer<CommandBuilder<?>> consumer) {
        CommandBuilder<LiteralArgumentBuilder> commandBuilder = new CommandBuilder<LiteralArgumentBuilder>(Commands.func_197057_a((String)commandName));
        consumer.accept(commandBuilder);
        this.argumentBuilder = this.argumentBuilder.then(commandBuilder.argumentBuilder);
    }

    @MappedMethod
    public void executes(ToIntFunction<ContextHandler> execute2) {
        this.argumentBuilder = this.argumentBuilder.executes(context -> execute2.applyAsInt(new ContextHandler(context)));
    }

    public static class ContextHandler {
        private final CommandContext<CommandSource> context;

        private ContextHandler(CommandContext<CommandSource> context) {
            this.context = context;
        }

        @MappedMethod
        public boolean getBoolean(String argumentName) {
            return BoolArgumentType.getBool(this.context, (String)argumentName);
        }

        @MappedMethod
        public double getDouble(String argumentName) {
            return DoubleArgumentType.getDouble(this.context, (String)argumentName);
        }

        @MappedMethod
        public float getFloat(String argumentName) {
            return FloatArgumentType.getFloat(this.context, (String)argumentName);
        }

        @MappedMethod
        public int getInteger(String argumentName) {
            return IntegerArgumentType.getInteger(this.context, (String)argumentName);
        }

        @MappedMethod
        public long getLong(String argumentName) {
            return LongArgumentType.getLong(this.context, (String)argumentName);
        }

        @MappedMethod
        public String getString(String argumentName) {
            return StringArgumentType.getString(this.context, (String)argumentName);
        }

        @MappedMethod
        public void sendSuccess(String message, boolean broadcastToOps, Object ... translatableArguments) {
            ((CommandSource)this.context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(message), broadcastToOps);
        }

        @MappedMethod
        public void sendFailure(String message, Object ... translatableArguments) {
            ((CommandSource)this.context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent(message));
        }

        @MappedMethod
        public MinecraftServer getServer() {
            return new MinecraftServer(((CommandSource)this.context.getSource()).func_197028_i());
        }

        @MappedMethod
        public org.mtr.mapping.holder.World getWorld() {
            return new org.mtr.mapping.holder.World((World)((CommandSource)this.context.getSource()).func_197023_e());
        }

        @MappedMethod
        @Nullable
        public org.mtr.mapping.holder.ServerPlayerEntity getServerPlayer() {
            ServerPlayerEntity serverPlayerEntity = null;
            try {
                serverPlayerEntity = ((CommandSource)this.context.getSource()).func_197035_h();
            }
            catch (Exception e) {
                DummyClass.logException(e);
            }
            return serverPlayerEntity == null ? null : new org.mtr.mapping.holder.ServerPlayerEntity(serverPlayerEntity);
        }
    }
}

