/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.registry;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.WorldChunk;

public final class MainEventBus {
    Consumer<MinecraftServer> serverStartingConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStartedConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStoppingConsumer = minecraftServer -> {};
    Consumer<MinecraftServer> serverStoppedConsumer = minecraftServer -> {};
    Runnable startServerTickRunnable = () -> {};
    Runnable endServerTickRunnable = () -> {};
    Consumer<org.mtr.mapping.holder.ServerWorld> startWorldTickRunnable = world -> {};
    Consumer<org.mtr.mapping.holder.ServerWorld> endWorldTickRunnable = world -> {};
    BiConsumer<MinecraftServer, org.mtr.mapping.holder.ServerPlayerEntity> playerJoinRunnable = (minecraftServer, serverPlayerEntity) -> {};
    BiConsumer<MinecraftServer, org.mtr.mapping.holder.ServerPlayerEntity> playerDisconnectRunnable = (minecraftServer, serverPlayerEntity) -> {};
    BiConsumer<org.mtr.mapping.holder.ServerWorld, WorldChunk> chunkLoadConsumer = (world, chunk) -> {};
    BiConsumer<org.mtr.mapping.holder.ServerWorld, WorldChunk> chunkUnloadConsumer = (world, chunk) -> {};
    final List<Consumer<CommandDispatcher<CommandSource>>> commands = new ArrayList<Consumer<CommandDispatcher<CommandSource>>>();

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        this.serverStartingConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartedEvent event) {
        this.serverStartedConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppingEvent event) {
        this.serverStoppingConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent event) {
        this.serverStoppedConsumer.accept(new MinecraftServer(event.getServer()));
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        switch (event.phase) {
            case START: {
                this.startServerTickRunnable.run();
                break;
            }
            case END: {
                this.endServerTickRunnable.run();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.world instanceof ServerWorld) {
            switch (event.phase) {
                case START: {
                    this.startWorldTickRunnable.accept(new org.mtr.mapping.holder.ServerWorld((ServerWorld)event.world));
                    break;
                }
                case END: {
                    this.endWorldTickRunnable.accept(new org.mtr.mapping.holder.ServerWorld((ServerWorld)event.world));
                }
            }
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity playerEntity = event.getPlayer();
        if (playerEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
            this.playerJoinRunnable.accept(new MinecraftServer(serverPlayerEntity.field_71133_b), new org.mtr.mapping.holder.ServerPlayerEntity(serverPlayerEntity));
        }
    }

    @SubscribeEvent
    public void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity playerEntity = event.getPlayer();
        if (playerEntity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)playerEntity;
            this.playerDisconnectRunnable.accept(new MinecraftServer(serverPlayerEntity.field_71133_b), new org.mtr.mapping.holder.ServerPlayerEntity(serverPlayerEntity));
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && event.getChunk() instanceof Chunk) {
            this.chunkLoadConsumer.accept(new org.mtr.mapping.holder.ServerWorld((ServerWorld)event.getWorld()), new WorldChunk((Chunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && event.getChunk() instanceof Chunk) {
            this.chunkUnloadConsumer.accept(new org.mtr.mapping.holder.ServerWorld((ServerWorld)event.getWorld()), new WorldChunk((Chunk)event.getChunk()));
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        this.commands.forEach(consumer -> consumer.accept(event.getDispatcher()));
    }
}

