/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.Axis;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockCeiling;
import org.mtr.mod.block.IBlock;

public class BlockCeilingAuto
extends BlockCeiling {
    public static final BooleanProperty LIGHT = BooleanProperty.of("light");

    public BlockCeilingAuto(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext itemPlacementContext) {
        boolean facing = itemPlacementContext.getPlayerFacing().getAxis() == Axis.X;
        return super.getPlacementState2(itemPlacementContext).with(new Property((net.minecraft.state.Property)BlockCeilingAuto.FACING.data), facing).with(new Property((net.minecraft.state.Property)BlockCeilingAuto.LIGHT.data), BlockCeilingAuto.hasLight(facing, itemPlacementContext.getBlockPos()));
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos).with(new Property((net.minecraft.state.Property)BlockCeilingAuto.LIGHT.data), BlockCeilingAuto.hasLight(IBlock.getStatePropertySafe(state, FACING), pos));
    }

    @Override
    public void randomDisplayTick2(BlockState state, World world, BlockPos pos, Random random) {
        boolean light = BlockCeilingAuto.hasLight(IBlock.getStatePropertySafe(state, FACING), pos);
        if (IBlock.getStatePropertySafe(state, LIGHT) != light) {
            world.setBlockState(pos, state.with(new Property((net.minecraft.state.Property)BlockCeilingAuto.LIGHT.data), light));
        }
    }

    @Override
    public boolean hasRandomTicks2(BlockState state) {
        return true;
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add(LIGHT);
    }

    private static boolean hasLight(boolean facing, BlockPos pos) {
        if (facing) {
            return pos.getZ() % 3 == 0;
        }
        return pos.getX() % 3 == 0;
    }
}

