/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanBiFunction;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockEscalatorBase;
import org.mtr.mod.block.BlockEscalatorSide;
import org.mtr.mod.block.IBlock;

public class BlockEscalatorStep
extends BlockEscalatorBase {
    public static final BooleanProperty DIRECTION = BooleanProperty.of("direction");
    public static final BooleanProperty STATUS = BooleanProperty.of("status");

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && !(world.getBlockState((BlockPos)pos.up()).getBlock().data instanceof BlockEscalatorSide)) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            IBlock.onBreakCreative(world, player, pos.offset(IBlock.getSideDirection(state)));
        }
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        BlockEscalatorBase.EnumEscalatorOrientation orientation = (BlockEscalatorBase.EnumEscalatorOrientation)IBlock.getStatePropertySafe(state, new Property((net.minecraft.state.Property)BlockEscalatorStep.ORIENTATION.data));
        if (orientation == BlockEscalatorBase.EnumEscalatorOrientation.FLAT || orientation == BlockEscalatorBase.EnumEscalatorOrientation.TRANSITION_BOTTOM) {
            return Block.createCuboidShape(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);
        }
        return VoxelShapes.combine(Block.createCuboidShape(1.0, 0.0, 1.0, 15.0, 16.0, 15.0), super.getCollisionShape2(state, world, pos, context), BooleanBiFunction.getAndMapped());
    }

    @Override
    public void onEntityCollision2(BlockState state, World world, BlockPos pos, Entity entity) {
        super.onEntityCollision2(state, world, pos, entity);
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        boolean direction = IBlock.getStatePropertySafe(state, DIRECTION);
        float speed = 0.1f;
        if (IBlock.getStatePropertySafe(state, STATUS)) {
            switch (facing) {
                case NORTH: {
                    entity.addVelocity(0.0, 0.0, direction ? (double)-0.1f : (double)0.1f);
                    break;
                }
                case EAST: {
                    entity.addVelocity(direction ? (double)0.1f : (double)-0.1f, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    entity.addVelocity(0.0, 0.0, direction ? (double)0.1f : (double)-0.1f);
                    break;
                }
                case WEST: {
                    entity.addVelocity(direction ? (double)-0.1f : (double)0.1f, 0.0, 0.0);
                    break;
                }
            }
        }
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean newRunning;
            boolean newDirection;
            boolean direction = IBlock.getStatePropertySafe(state, DIRECTION);
            boolean running = IBlock.getStatePropertySafe(state, STATUS);
            Direction blockFacing = IBlock.getStatePropertySafe(state, FACING);
            if (direction && running) {
                newDirection = false;
                newRunning = true;
            } else if (!direction && running) {
                newDirection = false;
                newRunning = false;
            } else {
                newDirection = true;
                newRunning = true;
            }
            this.update(world, pos, blockFacing, newDirection, newRunning);
            this.update(world, pos, blockFacing.getOpposite(), newDirection, newRunning);
            BlockPos sidePos = pos.offset(IBlock.getSideDirection(state));
            if (this.isStep(world, sidePos)) {
                BlockEscalatorStep block = (BlockEscalatorStep)world.getBlockState((BlockPos)sidePos).getBlock().data;
                block.update(world, sidePos, blockFacing, newDirection, newRunning);
                block.update(world, sidePos, blockFacing.getOpposite(), newDirection, newRunning);
            }
        });
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(DIRECTION);
        properties.add(ORIENTATION);
        properties.add(SIDE);
        properties.add(STATUS);
    }

    private void update(World world, BlockPos pos, Direction offset, boolean direction, boolean running) {
        world.setBlockState(pos, world.getBlockState(pos).with(new Property((net.minecraft.state.Property)BlockEscalatorStep.DIRECTION.data), direction).with(new Property((net.minecraft.state.Property)BlockEscalatorStep.STATUS.data), running));
        BlockPos offsetPos = pos.offset(offset);
        if (this.isStep(world, offsetPos)) {
            this.update(world, offsetPos, offset, direction, running);
        }
        if (this.isStep(world, offsetPos.up())) {
            this.update(world, offsetPos.up(), offset, direction, running);
        }
        if (this.isStep(world, offsetPos.down())) {
            this.update(world, offsetPos.down(), offset, direction, running);
        }
    }

    private boolean isStep(World world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        return block.data instanceof BlockEscalatorStep;
    }
}

