/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.operation.PressLift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Blocks;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockWaterloggable;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketPressLiftButton;

public class BlockLiftButtons
extends BlockWaterloggable
implements DirectionHelper,
BlockWithEntity {
    public static final BooleanProperty UNLOCKED = BooleanProperty.of("unlocked");

    public BlockLiftButtons() {
        super(Blocks.createDefaultBlockSettings(true));
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        ActionResult result = IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = !IBlock.getStatePropertySafe(state, UNLOCKED);
            world.setBlockState(pos, state.with(new Property((net.minecraft.state.Property)BlockLiftButtons.UNLOCKED.data), unlocked));
            player.sendMessage((unlocked ? TranslationProvider.GUI_MTR_LIFT_BUTTONS_UNLOCKED : TranslationProvider.GUI_MTR_LIFT_BUTTONS_LOCKED).getText(new Object[0]), true);
        });
        if (result == ActionResult.SUCCESS) {
            return ActionResult.SUCCESS;
        }
        if (player.isHolding(Items.LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.LIFT_BUTTONS_LINK_REMOVER.get())) {
            return ActionResult.PASS;
        }
        boolean unlocked = IBlock.getStatePropertySafe(state, UNLOCKED);
        double hitY = MathHelper.fractionalPart(hit.getPos().getYMapped());
        if (unlocked && hitY < 0.5) {
            if (world.isClient()) {
                org.mtr.mapping.holder.BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity != null && blockEntity.data instanceof BlockEntity) {
                    boolean[] buttonStates = new boolean[]{false, false};
                    ((BlockEntity)((Object)blockEntity.data)).trackPositions.forEach(trackPosition -> BlockLiftButtons.hasButtonsClient(trackPosition, buttonStates, (floor, lift) -> {}));
                    LiftDirection liftDirection = buttonStates[0] && buttonStates[1] ? (hitY < 0.25 ? LiftDirection.DOWN : LiftDirection.UP) : (buttonStates[0] ? LiftDirection.DOWN : LiftDirection.UP);
                    PressLift pressLift = new PressLift();
                    ((BlockEntity)((Object)blockEntity.data)).trackPositions.forEach(trackPosition -> pressLift.add(Init.blockPosToPosition(trackPosition), liftDirection));
                    InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketPressLiftButton(pressLift));
                    return ActionResult.SUCCESS;
                }
                return ActionResult.FAIL;
            }
            return ActionResult.SUCCESS;
        }
        return ActionResult.FAIL;
    }

    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext itemPlacementContext) {
        Direction facing = itemPlacementContext.getPlayerFacing();
        return super.getPlacementState2(itemPlacementContext).with(new Property((net.minecraft.state.Property)BlockLiftButtons.FACING.data), facing.data);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection(4.0, 0.0, 0.0, 12.0, 16.0, 1.0, IBlock.getStatePropertySafe(state, FACING));
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add(FACING);
        properties.add(UNLOCKED);
    }

    public static void hasButtonsClient(BlockPos trackPosition, boolean[] buttonStates, FloorLiftCallback callback) {
        MinecraftClientData.getInstance().lifts.forEach(lift -> {
            int floorIndex = lift.getFloorIndex(Init.blockPosToPosition(trackPosition));
            if (floorIndex > 0) {
                buttonStates[0] = true;
            }
            if (floorIndex >= 0 && floorIndex < lift.getFloorCount() - 1) {
                buttonStates[1] = true;
            }
            if (floorIndex >= 0) {
                callback.accept(floorIndex, (Lift)lift);
            }
        });
    }

    @FunctionalInterface
    public static interface FloorLiftCallback {
        public void accept(int var1, Lift var2);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        private final ObjectOpenHashSet<BlockPos> trackPositions = new ObjectOpenHashSet();
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";

        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.LIFT_BUTTONS_1.get(), pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.trackPositions.clear();
            for (long position : compoundTag.getLongArray(KEY_TRACK_FLOOR_POS)) {
                this.trackPositions.add(BlockPos.fromLong(position));
            }
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            ArrayList<Long> trackPositionsList = new ArrayList<Long>();
            this.trackPositions.forEach(position -> trackPositionsList.add(position.asLong()));
            compoundTag.putLongArray(KEY_TRACK_FLOOR_POS, trackPositionsList);
        }

        public void registerFloor(BlockPos pos, boolean isAdd) {
            if (isAdd) {
                this.trackPositions.add(pos);
            } else {
                this.trackPositions.remove(pos);
            }
            this.markDirty2();
        }

        public void forEachTrackPosition(Consumer<BlockPos> consumer) {
            this.trackPositions.forEach(consumer);
        }
    }
}

