/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.Blocks;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.block.TripleHorizontalBlock;
import org.mtr.mod.generated.lang.TranslationProvider;

public abstract class BlockLiftPanelBase
extends BlockExtension
implements IBlock,
DirectionHelper,
TripleHorizontalBlock,
BlockWithEntity {
    private final boolean isOdd;
    private final boolean isFlat;

    public BlockLiftPanelBase(boolean isOdd, boolean isFlat) {
        super(Blocks.createDefaultBlockSettings(true, blockState -> 5));
        this.isOdd = isOdd;
        this.isFlat = isFlat;
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (this.isOdd) {
            return TripleHorizontalBlock.getStateForNeighborUpdate(state, direction, neighborState.isOf(new Block(this)), super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos));
        }
        if (IBlock.getSideDirection(state) == direction && !neighborState.isOf(new Block(this))) {
            return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction direction = ctx.getPlayerFacing();
        if (this.isOdd) {
            return TripleHorizontalBlock.getPlacementState(ctx, this.getDefaultState2());
        }
        return IBlock.isReplaceable(ctx, direction.rotateYClockwise(), 2) ? this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockLiftPanelBase.FACING.data), direction.data).with(new Property((net.minecraft.state.Property)BlockLiftPanelBase.SIDE.data), IBlock.EnumSide.LEFT) : null;
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection(0.0, 0.0, 0.0, 16.0, 16.0, this.isFlat ? 1.0 : 4.0, Direction.convert((net.minecraft.util.Direction)state.get(new Property((net.minecraft.state.Property)BlockLiftPanelBase.FACING.data))));
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction direction = IBlock.getStatePropertySafe(state, FACING);
            if (this.isOdd) {
                TripleHorizontalBlock.onPlaced(world, pos, state, this.getDefaultState2());
            } else {
                world.setBlockState(pos.offset(direction.rotateYClockwise()), this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockLiftPanelBase.FACING.data), direction.data).with(new Property((net.minecraft.state.Property)BlockLiftPanelBase.SIDE.data), IBlock.EnumSide.RIGHT), 3);
            }
            world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((IWorld)world.data), pos, 3);
        }
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (this.isOdd) {
            TripleHorizontalBlock.onBreak(world, pos, state, player);
        } else if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            IBlock.onBreakCreative(world, player, pos.offset(IBlock.getSideDirection(state)));
        }
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        if (world.isClient()) {
            return ActionResult.SUCCESS;
        }
        return player.isHolding(Items.LIFT_BUTTONS_LINK_CONNECTOR.get()) || player.isHolding(Items.LIFT_BUTTONS_LINK_REMOVER.get()) ? ActionResult.PASS : ActionResult.FAIL;
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add((this.isOdd ? TranslationProvider.TOOLTIP_MTR_RAILWAY_SIGN_ODD : TranslationProvider.TOOLTIP_MTR_RAILWAY_SIGN_EVEN).getMutableText(new Object[0]).formatted(TextFormatting.GRAY));
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension {
        private BlockPos trackPosition = null;
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";

        public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state, boolean isOdd) {
            super(type, pos, state);
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            long data = compoundTag.getLong(KEY_TRACK_FLOOR_POS);
            this.trackPosition = data == 0L ? null : BlockPos.fromLong(data);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLong(KEY_TRACK_FLOOR_POS, this.trackPosition == null ? 0L : this.trackPosition.asLong());
        }

        public void registerFloor(World world, BlockPos pos, boolean isAdd) {
            if (IBlock.getStatePropertySafe(world, this.getPos2(), IBlock.SIDE) == IBlock.EnumSide.RIGHT) {
                BlockEntity blockEntity = world.getBlockEntity(this.getPos2().offset(IBlock.getStatePropertySafe(world, this.getPos2(), DirectionHelper.FACING).rotateYCounterclockwise()));
                if (blockEntity != null && blockEntity.data instanceof BlockEntityBase) {
                    ((BlockEntityBase)((Object)blockEntity.data)).registerFloor(world, pos, isAdd);
                }
            } else {
                this.trackPosition = isAdd ? pos : null;
                this.markDirty2();
            }
        }

        @Nullable
        public BlockPos getTrackPosition() {
            return this.trackPosition;
        }
    }
}

