/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockLiftTrackBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.generated.lang.TranslationProvider;

public class BlockLiftTrackDiagonal
extends BlockLiftTrackBase
implements IBlock {
    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext context) {
        Vector3d vector3d = context.getHitPos().rotateY((float)Math.toRadians(BlockLiftTrackDiagonal.getFacing(context).asRotation()));
        return super.getPlacementState2(context).with(new Property((net.minecraft.state.Property)BlockLiftTrackDiagonal.HALF.data), MathHelper.fractionalPart(vector3d.getYMapped()) < 0.5 ? IBlock.DoubleBlockHalf.LOWER : IBlock.DoubleBlockHalf.UPPER).with(new Property((net.minecraft.state.Property)BlockLiftTrackDiagonal.SIDE.data), MathHelper.fractionalPart(vector3d.getXMapped()) < 0.5 ? IBlock.EnumSide.RIGHT : IBlock.EnumSide.LEFT);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        boolean isUpper = IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean isRight = IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT;
        return VoxelShapes.union(IBlock.getVoxelShapeByDirection(6.0, isUpper ? 6.0 : 0.0, 0.0, 10.0, isUpper ? 16.0 : 10.0, 1.0, IBlock.getStatePropertySafe(state, FACING)), IBlock.getVoxelShapeByDirection(isRight ? 6.0 : 0.0, 6.0, 0.0, isRight ? 16.0 : 10.0, 10.0, 1.0, IBlock.getStatePropertySafe(state, FACING)));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(SIDE);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TranslationProvider.TOOLTIP_MTR_LIFT_TRACK_DIAGONAL.getMutableText(new Object[0]).formatted(TextFormatting.GRAY));
    }

    @Override
    public Vector getCenterPoint(BlockPos blockPos, BlockState blockState) {
        Direction facing = IBlock.getStatePropertySafe(blockState, FACING);
        Direction newFacing = IBlock.getStatePropertySafe(blockState, SIDE) == IBlock.EnumSide.RIGHT ? facing.rotateYClockwise() : facing.rotateYCounterclockwise();
        return new Vector((double)blockPos.getX() + 0.25 * (double)newFacing.getOffsetX(), (double)blockPos.getY() + 0.25 * (double)(IBlock.getStatePropertySafe(blockState, HALF) == IBlock.DoubleBlockHalf.UPPER ? 1 : -1), (double)blockPos.getZ() + 0.25 * (double)newFacing.getOffsetZ());
    }

    @Override
    public ObjectArrayList<Direction> getConnectingDirections(BlockState blockState) {
        Direction facing = IBlock.getStatePropertySafe(blockState, FACING);
        return ObjectArrayList.of(new Direction[]{IBlock.getStatePropertySafe(blockState, HALF) == IBlock.DoubleBlockHalf.UPPER ? Direction.UP : Direction.DOWN, IBlock.getStatePropertySafe(blockState, SIDE) == IBlock.EnumSide.RIGHT ? facing.rotateYClockwise() : facing.rotateYCounterclockwise()});
    }
}

