/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.tool.Angle;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.Waterloggable;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.Init;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockWaterloggable;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.ClientPacketHelper;
import org.mtr.mod.packet.PacketDeleteData;

public class BlockNode
extends BlockWaterloggable
implements DirectionHelper,
Waterloggable {
    public final TransportMode transportMode;
    public static final BooleanProperty FACING = BooleanProperty.of("facing");
    public static final BooleanProperty IS_22_5 = BooleanProperty.of("is_22_5");
    public static final BooleanProperty IS_45 = BooleanProperty.of("is_45");
    public static final BooleanProperty IS_CONNECTED = BooleanProperty.of("is_connected");
    private static final double SHAPE_PADDING = 0.1;

    public BlockNode(TransportMode transportMode) {
        super(Blocks.createDefaultBlockSettings(true).nonOpaque());
        this.transportMode = transportMode;
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockHitResult hit) {
        if (world.isClient() && playerEntity.isHolding(Items.BRUSH.get())) {
            ObjectObjectImmutablePair<Rail, BlockPos> railAndBlockPos = MinecraftClientData.getInstance().getFacingRailAndBlockPos(false);
            if (railAndBlockPos == null) {
                return ActionResult.FAIL;
            }
            ClientPacketHelper.openRailShapeModifierScreen(railAndBlockPos.left().getHexId());
            return ActionResult.SUCCESS;
        }
        return ActionResult.FAIL;
    }

    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext itemPlacementContext) {
        int quadrant = Angle.getQuadrant(itemPlacementContext.getPlayerYaw(), true);
        return super.getPlacementState2(itemPlacementContext).with(new Property((net.minecraft.state.Property)BlockNode.FACING.data), quadrant % 8 >= 4).with(new Property((net.minecraft.state.Property)BlockNode.IS_45.data), quadrant % 4 >= 2).with(new Property((net.minecraft.state.Property)BlockNode.IS_22_5.data), quadrant % 2 == 1).with(new Property((net.minecraft.state.Property)BlockNode.IS_CONNECTED.data), false);
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.onBreak2(world, pos, state, player);
        if (!world.isClient()) {
            PacketDeleteData.sendDirectlyToServerRailNodePosition(ServerWorld.cast(world), Init.blockPosToPosition(pos));
        }
    }

    @Override
    @Nonnull
    public final VoxelShape getOutlineShape2(BlockState blockState, BlockView world, BlockPos pos, ShapeContext context) {
        return Block.createCuboidShape(0.1, this.getShapeY1(), 0.1, 15.9, this.getShapeY2(blockState), 15.9);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add(FACING);
        properties.add(IS_22_5);
        properties.add(IS_45);
        properties.add(IS_CONNECTED);
    }

    double getShapeY1() {
        return 0.1;
    }

    double getShapeY2(BlockState blockState) {
        return IBlock.getStatePropertySafe(blockState, IS_CONNECTED) ? 1.0 : 15.9;
    }

    public static void resetRailNode(ServerWorld serverWorld, BlockPos blockPos) {
        BlockState state = serverWorld.getBlockState(blockPos);
        if (state.getBlock().data instanceof BlockNode) {
            serverWorld.setBlockState(blockPos, state.with(new Property((net.minecraft.state.Property)BlockNode.IS_CONNECTED.data), false));
        }
    }

    public static float getAngle(BlockState state) {
        return (float)(IBlock.getStatePropertySafe(state, FACING) ? 0 : 90) + (IBlock.getStatePropertySafe(state, IS_22_5) ? 22.5f : 0.0f) + (float)(IBlock.getStatePropertySafe(state, IS_45) ? 45 : 0);
    }

    public static class BlockContinuousMovementNode
    extends BlockNode {
        public final boolean upper;
        public final boolean isStation;

        public BlockContinuousMovementNode(boolean upper, boolean isStation) {
            super(TransportMode.CABLE_CAR);
            this.upper = upper;
            this.isStation = isStation;
        }

        @Override
        @Nonnull
        public BlockState getPlacementState2(ItemPlacementContext itemPlacementContext) {
            int quadrant = Angle.getQuadrant(itemPlacementContext.getPlayerYaw(), false);
            return super.getPlacementState2(itemPlacementContext).with(new Property((net.minecraft.state.Property)BlockContinuousMovementNode.FACING.data), quadrant % 4 >= 2).with(new Property((net.minecraft.state.Property)BlockContinuousMovementNode.IS_45.data), quadrant % 2 == 1).with(new Property((net.minecraft.state.Property)BlockContinuousMovementNode.IS_22_5.data), false).with(new Property((net.minecraft.state.Property)BlockContinuousMovementNode.IS_CONNECTED.data), false);
        }

        @Override
        public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
            String[] strings;
            for (String string : strings = (this.isStation ? TranslationProvider.TOOLTIP_MTR_CABLE_CAR_NODE_STATION : TranslationProvider.TOOLTIP_MTR_CABLE_CAR_NODE).getString(new Object[0]).split("\n")) {
                tooltip.add(TextHelper.literal(string).formatted(TextFormatting.GRAY));
            }
        }

        @Override
        double getShapeY1() {
            return this.upper ? 8.0 : 0.1;
        }

        @Override
        double getShapeY2(BlockState blockState) {
            return this.upper ? 15.9 : 8.0;
        }
    }
}

