/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPIDSBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.generated.lang.TranslationProvider;

public abstract class BlockPIDSHorizontalBase
extends BlockPIDSBase {
    public BlockPIDSHorizontalBase(int maxArrivals) {
        super(maxArrivals, BlockPIDSHorizontalBase::canStoreData, BlockPIDSHorizontalBase::getBlockPosWithData);
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (IBlock.getStatePropertySafe(state, FACING) == direction && !neighborState.isOf(new Block(this))) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction direction = IBlock.getStatePropertySafe(state, FACING);
            world.setBlockState(pos.offset(direction), this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockPIDSHorizontalBase.FACING.data), direction.getOpposite().data), 3);
            world.updateNeighbors(pos, Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((IWorld)world.data), pos, 3);
        }
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction direction = ctx.getPlayerFacing().getOpposite();
        return IBlock.isReplaceable(ctx, direction, 2) ? this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockPIDSHorizontalBase.FACING.data), direction.data) : null;
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        if (facing == Direction.SOUTH || facing == Direction.WEST) {
            IBlock.onBreakCreative(world, player, pos.offset(facing));
        }
        super.onBreak2(world, pos, state, player);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TranslationProvider.TOOLTIP_MTR_ARRIVALS.getMutableText(this.maxArrivals).formatted(TextFormatting.GRAY));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
    }

    private static boolean canStoreData(World world, BlockPos blockPos) {
        Direction facing = IBlock.getStatePropertySafe(world, blockPos, FACING);
        return facing == Direction.NORTH || facing == Direction.EAST;
    }

    private static BlockPos getBlockPosWithData(World world, BlockPos blockPos) {
        if (BlockPIDSHorizontalBase.canStoreData(world, blockPos)) {
            return blockPos;
        }
        return blockPos.offset(IBlock.getStatePropertySafe(world, blockPos, FACING));
    }

    public static abstract class BlockEntityHorizontalBase
    extends BlockPIDSBase.BlockEntityBase {
        public BlockEntityHorizontalBase(int maxArrivals, BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(maxArrivals, (x$0, x$1) -> BlockPIDSHorizontalBase.canStoreData(x$0, x$1), (x$0, x$1) -> BlockPIDSHorizontalBase.getBlockPosWithData(x$0, x$1), type, pos, state);
        }

        @Override
        public boolean alternateLines() {
            return false;
        }

        @Override
        public int textColorArrived() {
            return 0xFF9900;
        }

        @Override
        public int textColor() {
            return 0xFF9900;
        }
    }
}

