/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderType;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.BlockPSDAPGGlassEndBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;

public abstract class BlockPSDAPGDoorBase
extends BlockPSDAPGBase
implements BlockWithEntity {
    public static final BooleanProperty END = BooleanProperty.of("end");
    public static final BooleanProperty UNLOCKED = BooleanProperty.of("unlocked");

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (IBlock.getSideDirection(state) == direction && !neighborState.isOf(new Block(this))) {
            return Blocks.getAirMapped().getDefaultState();
        }
        BlockState superState = super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
        if (superState.getBlock().equals(Blocks.getAirMapped())) {
            return superState;
        }
        boolean end = world.getBlockState((BlockPos)pos.offset((Direction)IBlock.getSideDirection((BlockState)state).getOpposite())).getBlock().data instanceof BlockPSDAPGGlassEndBase;
        return superState.with(new Property((net.minecraft.state.Property)BlockPSDAPGDoorBase.END.data), end);
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos offsetPos = pos;
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER) {
            offsetPos = offsetPos.down();
        }
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            offsetPos = offsetPos.offset(IBlock.getSideDirection(state));
        }
        IBlock.onBreakCreative(world, player, offsetPos);
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = IBlock.getStatePropertySafe(state, UNLOCKED);
            for (int y = -1; y <= 1; ++y) {
                BlockState scanState = world.getBlockState(pos.up(y));
                if (!state.isOf(scanState.getBlock())) continue;
                BlockPSDAPGDoorBase.lockDoor(world, pos.up(y), scanState, !unlocked);
            }
            player.sendMessage((unlocked ? TranslationProvider.GUI_MTR_PSD_APG_DOOR_LOCKED : TranslationProvider.GUI_MTR_PSD_APG_DOOR_UNLOCKED).getText(new Object[0]), true);
        });
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity != null && entity.data instanceof BlockEntityBase && entity.getWorld() != null && entity.getWorld().isClient() && ((BlockEntityBase)entity.data).getDoorValue() == 0.0) {
            return super.getCollisionShape2(state, world, pos, context);
        }
        return VoxelShapes.empty();
    }

    @Override
    public void onEntityCollision2(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.isClient() && PlayerEntity.isInstance(entity)) {
            boolean inDoorHitbox;
            Direction facing = IBlock.getStatePropertySafe(state, FACING);
            switch (facing) {
                case NORTH: {
                    inDoorHitbox = entity.getZ() + (double)0.3f > (double)pos.getZ() + 0.01 && entity.getZ() - (double)0.3f < (double)pos.getZ() + 0.24;
                    break;
                }
                case EAST: {
                    inDoorHitbox = entity.getX() + (double)0.3f > (double)(pos.getX() + 1) - 0.24 && entity.getX() - (double)0.3f < (double)(pos.getX() + 1) - 0.01;
                    break;
                }
                case SOUTH: {
                    inDoorHitbox = entity.getZ() + (double)0.3f > (double)(pos.getZ() + 1) - 0.24 && entity.getZ() - (double)0.3f < (double)(pos.getZ() + 1) - 0.01;
                    break;
                }
                case WEST: {
                    inDoorHitbox = entity.getX() + (double)0.3f > (double)pos.getX() + 0.01 && entity.getX() - (double)0.3f < (double)pos.getX() + 0.24;
                    break;
                }
                default: {
                    inDoorHitbox = false;
                }
            }
            if (inDoorHitbox) {
                double doorBlockedAmount;
                boolean southWest = facing == Direction.SOUTH || facing == Direction.WEST;
                boolean side = IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT;
                switch (facing) {
                    case NORTH: 
                    case SOUTH: {
                        doorBlockedAmount = Utilities.isBetween(entity.getX(), pos.getX(), pos.getX() + 1) ? (side == southWest ? (double)(pos.getX() + 1) - entity.getX() : entity.getX() - (double)pos.getX()) + (double)0.3f : 0.0;
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        doorBlockedAmount = Utilities.isBetween(entity.getZ(), pos.getZ(), pos.getZ() + 1) ? (side == southWest ? (double)(pos.getZ() + 1) - entity.getZ() : entity.getZ() - (double)pos.getZ()) + (double)0.3f : 0.0;
                        break;
                    }
                    default: {
                        doorBlockedAmount = 0.0;
                    }
                }
                if (doorBlockedAmount > 0.0) {
                    // empty if block
                }
            }
        }
    }

    @Override
    @Nonnull
    public BlockRenderType getRenderType2(BlockState state) {
        return BlockRenderType.getEntityblockAnimatedMapped();
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(END);
        properties.add(FACING);
        properties.add(HALF);
        properties.add(SIDE);
        properties.add(UNLOCKED);
    }

    private static void lockDoor(World world, BlockPos pos, BlockState state, boolean unlocked) {
        BlockState toggled;
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        BlockPos leftPos = pos.offset(facing.rotateYCounterclockwise());
        BlockPos rightPos = pos.offset(facing.rotateYClockwise());
        BlockState leftState = world.getBlockState(leftPos);
        BlockState rightState = world.getBlockState(rightPos);
        if (leftState.isOf(state.getBlock())) {
            toggled = leftState.with(new Property((net.minecraft.state.Property)BlockPSDAPGDoorBase.UNLOCKED.data), unlocked);
            world.setBlockState(leftPos, toggled);
        }
        if (rightState.isOf(state.getBlock())) {
            toggled = rightState.with(new Property((net.minecraft.state.Property)BlockPSDAPGDoorBase.UNLOCKED.data), unlocked);
            world.setBlockState(rightPos, toggled);
        }
        world.setBlockState(pos, state.with(new Property((net.minecraft.state.Property)BlockPSDAPGDoorBase.UNLOCKED.data), unlocked));
    }

    @Nullable
    private static BlockEntityBase getBottomBlockEntity(@Nullable World world, BlockPos pos) {
        BlockEntity blockEntity = world == null ? null : world.getBlockEntity(pos.down(IBlock.getStatePropertySafe(world.getBlockState(pos), HALF) == IBlock.DoubleBlockHalf.UPPER ? 1 : 0));
        return blockEntity != null && blockEntity.data instanceof BlockEntityBase ? (BlockEntityBase)blockEntity.data : null;
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension
    implements IGui {
        private double doorValue;
        private double doorOverrideValue;
        private int doorTarget;
        private static final int REDSTONE_DETECT_DEPTH = 3;

        public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void setDoorValue(double vehicleDoorValue) {
            BlockEntityBase blockEntityBase = BlockPSDAPGDoorBase.getBottomBlockEntity(this.getWorld2(), this.getPos2());
            if (blockEntityBase != null) {
                blockEntityBase.doorValue = Utilities.clamp(vehicleDoorValue, 0.0, 1.0);
                blockEntityBase.doorTarget = 1;
            }
        }

        public double getDoorValue() {
            BlockState state = this.getCachedState2();
            Direction facing = IBlock.getStatePropertySafe(state, DirectionHelper.FACING);
            Direction otherDirection = IBlock.getStatePropertySafe(state, IBlock.SIDE) == IBlock.EnumSide.RIGHT ? facing.rotateYCounterclockwise() : facing.rotateYClockwise();
            BlockEntityBase blockEntityBase1 = BlockPSDAPGDoorBase.getBottomBlockEntity(this.getWorld2(), this.getPos2());
            BlockEntityBase blockEntityBase2 = BlockPSDAPGDoorBase.getBottomBlockEntity(this.getWorld2(), this.getPos2().offset(otherDirection));
            return Math.max(blockEntityBase1 == null ? 0.0 : blockEntityBase1.doorValue, blockEntityBase2 == null ? 0.0 : blockEntityBase2.doorValue);
        }

        public void tick(float tickDelta) {
            World world = this.getWorld2();
            if (world == null) {
                return;
            }
            if (IBlock.getStatePropertySafe(this.getCachedState2(), IBlock.HALF) == IBlock.DoubleBlockHalf.UPPER) {
                return;
            }
            if (BlockEntityBase.receivedRedstonePower(world, this.getPos2(), this.getCachedState2())) {
                this.doorTarget = 2;
            }
            double millisElapsed = tickDelta * 20.0f;
            if (this.doorTarget == 2) {
                this.doorValue = Math.min(1.0, this.doorValue + millisElapsed / 3200.0 * 2.0);
            }
            if (this.doorTarget >= 0) {
                --this.doorTarget;
            } else {
                this.doorValue = Math.max(this.doorOverrideValue, this.doorValue - millisElapsed / 3200.0 * 2.0);
            }
            this.doorOverrideValue = 0.0;
        }

        private static boolean receivedRedstonePower(World world, BlockPos pos, BlockState state) {
            if (!IBlock.getStatePropertySafe(state, UNLOCKED)) {
                return false;
            }
            Direction facing = IBlock.getStatePropertySafe(state, DirectionHelper.FACING);
            Direction otherDirection = IBlock.getStatePropertySafe(state, IBlock.SIDE) == IBlock.EnumSide.RIGHT ? facing.rotateYCounterclockwise() : facing.rotateYClockwise();
            for (int i = 2; i <= 3; ++i) {
                BlockPos checkPos = pos.down(i);
                boolean emit = world.isEmittingRedstonePower(checkPos, Direction.UP);
                boolean emitNearby = world.isEmittingRedstonePower(checkPos.offset(otherDirection), Direction.UP);
                if (!emit && !emitNearby) continue;
                return true;
            }
            return false;
        }
    }
}

