/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockPSDAPGGlassBase
extends BlockPSDAPGBase {
    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            for (int y = -1; y <= 1; ++y) {
                BlockState scanState = world.getBlockState(pos.up(y));
                if (!state.isOf(scanState.getBlock())) continue;
                this.connectGlass(world, pos.up(y), scanState);
            }
        });
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(HALF);
        properties.add(SIDE_EXTENDED);
    }

    private void connectGlass(World world, BlockPos pos, BlockState state) {
        BlockPos rightPos;
        BlockState rightState;
        boolean rightValid;
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        BlockPos leftPos = pos.offset(facing.rotateYCounterclockwise());
        BlockState leftState = world.getBlockState(leftPos);
        boolean leftValid = state.isOf(leftState.getBlock());
        if (leftValid) {
            IBlock.EnumSide side = (IBlock.EnumSide)IBlock.getStatePropertySafe(leftState, SIDE_EXTENDED);
            IBlock.EnumSide newLeftSide = side == IBlock.EnumSide.RIGHT ? IBlock.EnumSide.MIDDLE : (side == IBlock.EnumSide.SINGLE ? IBlock.EnumSide.LEFT : side);
            world.setBlockState(leftPos, leftState.with(new Property((net.minecraft.state.Property)BlockPSDAPGGlassBase.SIDE_EXTENDED.data), newLeftSide));
        }
        if (rightValid = state.isOf((rightState = world.getBlockState(rightPos = pos.offset(facing.rotateYClockwise()))).getBlock())) {
            IBlock.EnumSide side = (IBlock.EnumSide)IBlock.getStatePropertySafe(rightState, SIDE_EXTENDED);
            IBlock.EnumSide newRightSide = side == IBlock.EnumSide.LEFT ? IBlock.EnumSide.MIDDLE : (side == IBlock.EnumSide.SINGLE ? IBlock.EnumSide.RIGHT : side);
            world.setBlockState(rightPos, rightState.with(new Property((net.minecraft.state.Property)BlockPSDAPGGlassBase.SIDE_EXTENDED.data), newRightSide));
        }
        IBlock.EnumSide newSide = leftValid && rightValid ? IBlock.EnumSide.MIDDLE : (leftValid ? IBlock.EnumSide.RIGHT : (rightValid ? IBlock.EnumSide.LEFT : IBlock.EnumSide.SINGLE));
        world.setBlockState(pos, state.with(new Property((net.minecraft.state.Property)BlockPSDAPGGlassBase.SIDE_EXTENDED.data), newSide));
    }
}

