/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.IItemProvider;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemConvertible;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Blocks;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.BlockPSDAPGGlassEndBase;
import org.mtr.mod.block.BlockPSDDoor;
import org.mtr.mod.block.BlockPSDGlass;
import org.mtr.mod.block.BlockPSDGlassEnd;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.item.ItemBrush;

public class BlockPSDTop
extends BlockExtension
implements IBlock,
DirectionHelper,
BlockWithEntity {
    private static final float PERSISTENT_OFFSET = 7.5f;
    public static final float PERSISTENT_OFFSET_SMALL = 0.46875f;
    public static final BooleanProperty AIR_LEFT = BooleanProperty.of("air_left");
    public static final BooleanProperty AIR_RIGHT = BooleanProperty.of("air_right");
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.of("propagate_property", 0, 3);
    public static final EnumProperty<EnumPersistent> PERSISTENT = EnumProperty.of("persistent", EnumPersistent.class);

    public BlockPSDTop() {
        super(Blocks.createDefaultBlockSettings(true).nonOpaque());
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingItem(world, player, item -> {
            if (item.data instanceof ItemBrush) {
                world.setBlockState(pos, state.cycle(new Property((net.minecraft.state.Property)BlockPSDTop.ARROW_DIRECTION.data)));
                this.propagate(world, pos, IBlock.getStatePropertySafe(state, FACING).rotateYClockwise(), new Property((net.minecraft.state.Property)BlockPSDTop.ARROW_DIRECTION.data), 1);
                this.propagate(world, pos, IBlock.getStatePropertySafe(state, FACING).rotateYCounterclockwise(), new Property((net.minecraft.state.Property)BlockPSDTop.ARROW_DIRECTION.data), 1);
            } else {
                boolean shouldBePersistent = IBlock.getStatePropertySafe(state, new Property((net.minecraft.state.Property)BlockPSDTop.PERSISTENT.data)) == EnumPersistent.NONE;
                this.setState(world, pos, shouldBePersistent);
                this.propagate(world, pos, IBlock.getStatePropertySafe(state, FACING).rotateYClockwise(), offsetPos -> this.setState(world, (BlockPos)offsetPos, shouldBePersistent), 1);
                this.propagate(world, pos, IBlock.getStatePropertySafe(state, FACING).rotateYCounterclockwise(), offsetPos -> this.setState(world, (BlockPos)offsetPos, shouldBePersistent), 1);
            }
        }, null, Items.BRUSH.get(), org.mtr.mapping.holder.Items.getShearsMapped());
    }

    private void setState(World world, BlockPos pos, boolean shouldBePersistent) {
        Block blockBelow = world.getBlockState(pos.down()).getBlock();
        if (blockBelow.data instanceof BlockPSDDoor || blockBelow.data instanceof BlockPSDGlass || blockBelow.data instanceof BlockPSDGlassEnd) {
            if (shouldBePersistent) {
                world.setBlockState(pos, world.getBlockState(pos).with(new Property((net.minecraft.state.Property)BlockPSDTop.PERSISTENT.data), blockBelow.data instanceof BlockPSDDoor ? EnumPersistent.ARROW : (blockBelow.data instanceof BlockPSDGlass ? EnumPersistent.ROUTE : EnumPersistent.BLANK)));
            } else {
                world.setBlockState(pos, world.getBlockState(pos).with(new Property((net.minecraft.state.Property)BlockPSDTop.PERSISTENT.data), EnumPersistent.NONE));
            }
        }
    }

    @Override
    @Nonnull
    public Item asItem2() {
        return Items.PSD_GLASS_1.get();
    }

    @Override
    @Nonnull
    public ItemStack getPickStack2(BlockView world, BlockPos pos, BlockState state) {
        return new ItemStack(new ItemConvertible((IItemProvider)this.asItem2().data));
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Block blockDown = world.getBlockState(pos.down()).getBlock();
        if (blockDown.data instanceof BlockPSDAPGBase) {
            ((BlockPSDAPGBase)blockDown.data).onBreak2(world, pos.down(), world.getBlockState(pos.down()), player);
            world.setBlockState(pos.down(), org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState());
        }
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && IBlock.getStatePropertySafe(state, new Property((net.minecraft.state.Property)BlockPSDTop.PERSISTENT.data)) == EnumPersistent.NONE && !(neighborState.getBlock().data instanceof BlockPSDAPGBase)) {
            return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
        }
        return BlockPSDTop.getActualState(world, pos);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        VoxelShape baseShape = IBlock.getVoxelShapeByDirection(0.0, IBlock.getStatePropertySafe(state, new Property((net.minecraft.state.Property)BlockPSDTop.PERSISTENT.data)) == EnumPersistent.NONE ? 0.0 : 7.5, 0.0, 16.0, 16.0, 6.0, IBlock.getStatePropertySafe(state, FACING));
        boolean airLeft = IBlock.getStatePropertySafe(state, AIR_LEFT);
        boolean airRight = IBlock.getStatePropertySafe(state, AIR_RIGHT);
        if (airLeft || airRight) {
            return BlockPSDAPGGlassEndBase.getEndOutlineShape(baseShape, state, 16, 6, airLeft, airRight);
        }
        return baseShape;
    }

    @Override
    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(SIDE_EXTENDED);
        properties.add(AIR_LEFT);
        properties.add(AIR_RIGHT);
        properties.add(ARROW_DIRECTION);
        properties.add(PERSISTENT);
    }

    public static BlockState getActualState(WorldAccess world, BlockPos pos) {
        Direction facing = null;
        IBlock.EnumSide side = null;
        boolean airLeft = false;
        boolean airRight = false;
        BlockState stateBelow = world.getBlockState(pos.down());
        Block blockBelow = stateBelow.getBlock();
        if (blockBelow.data instanceof BlockPSDGlass || blockBelow.data instanceof BlockPSDDoor || blockBelow.data instanceof BlockPSDGlassEnd) {
            side = blockBelow.data instanceof BlockPSDDoor ? (IBlock.EnumSide)IBlock.getStatePropertySafe(stateBelow, SIDE) : (IBlock.EnumSide)IBlock.getStatePropertySafe(stateBelow, SIDE_EXTENDED);
            if (blockBelow.data instanceof BlockPSDGlassEnd) {
                if (IBlock.getStatePropertySafe(stateBelow, new Property((net.minecraft.state.Property)BlockPSDGlassEnd.TOUCHING_LEFT.data)) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airLeft = true;
                }
                if (IBlock.getStatePropertySafe(stateBelow, new Property((net.minecraft.state.Property)BlockPSDGlassEnd.TOUCHING_RIGHT.data)) == BlockPSDAPGGlassEndBase.EnumPSDAPGGlassEndSide.AIR) {
                    airRight = true;
                }
            }
            facing = IBlock.getStatePropertySafe(stateBelow, FACING);
        }
        BlockState oldState = world.getBlockState(pos);
        BlockState neighborState = (oldState.getBlock().data instanceof BlockPSDTop ? oldState : Blocks.PSD_TOP.get().getDefaultState()).with(new Property((net.minecraft.state.Property)BlockPSDTop.AIR_LEFT.data), airLeft).with(new Property((net.minecraft.state.Property)BlockPSDTop.AIR_RIGHT.data), airRight);
        if (facing != null) {
            neighborState = neighborState.with(new Property((net.minecraft.state.Property)BlockPSDTop.FACING.data), facing.data);
        }
        if (side != null) {
            neighborState = neighborState.with(new Property((net.minecraft.state.Property)BlockPSDTop.SIDE_EXTENDED.data), side);
        }
        return neighborState;
    }

    public static enum EnumPersistent implements StringIdentifiable
    {
        NONE("none"),
        ARROW("arrow"),
        ROUTE("route"),
        BLANK("blank");

        private final String name;

        private EnumPersistent(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }

    public static enum EnumDoorLight implements StringIdentifiable
    {
        ON("on"),
        OFF("off"),
        NONE("none");

        private final String name;

        private EnumDoorLight(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }

    public static class BlockEntityBase
    extends BlockEntityExtension {
        public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }
    }

    public static class BlockEntity
    extends BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType<?>)BlockEntityTypes.PSD_TOP.get(), pos, state);
        }
    }
}

