/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.generated.lang.TranslationProvider;

public abstract class BlockPoleCheckBase
extends BlockExtension
implements DirectionHelper {
    public BlockPoleCheckBase(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockState stateBelow = ctx.getWorld().getBlockState(ctx.getBlockPos().down());
        if (this.isBlock(stateBelow.getBlock())) {
            return this.placeWithState(stateBelow);
        }
        return null;
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        String[] strings;
        for (String string : strings = TranslationProvider.TOOLTIP_MTR_POLE_PLACEMENT.getString(this.getTooltipBlockText().data).split("\n")) {
            tooltip.add(TextHelper.literal(string).formatted(TextFormatting.GRAY));
        }
    }

    protected BlockState placeWithState(BlockState stateBelow) {
        return this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockPoleCheckBase.FACING.data), IBlock.getStatePropertySafe((BlockState)stateBelow, (DirectionProperty)BlockPoleCheckBase.FACING).data);
    }

    protected abstract boolean isBlock(Block var1);

    protected abstract Text getTooltipBlockText();
}

