/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPoleCheckBase;
import org.mtr.mod.block.BlockRailwaySign;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.generated.lang.TranslationProvider;

public class BlockRailwaySignPole
extends BlockPoleCheckBase {
    public static final IntegerProperty TYPE = IntegerProperty.of("type", 0, 3);

    public BlockRailwaySignPole(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        switch (IBlock.getStatePropertySafe(state, TYPE)) {
            case 0: {
                return IBlock.getVoxelShapeByDirection(14.0, 0.0, 7.0, 15.25, 16.0, 9.0, facing);
            }
            case 1: {
                return IBlock.getVoxelShapeByDirection(10.0, 0.0, 7.0, 11.25, 16.0, 9.0, facing);
            }
            case 2: {
                return IBlock.getVoxelShapeByDirection(6.0, 0.0, 7.0, 7.25, 16.0, 9.0, facing);
            }
            case 3: {
                return IBlock.getVoxelShapeByDirection(2.0, 0.0, 7.0, 3.25, 16.0, 9.0, facing);
            }
        }
        return VoxelShapes.fullCube();
    }

    @Override
    protected BlockState placeWithState(BlockState stateBelow) {
        Block block = stateBelow.getBlock();
        int type = block.data instanceof BlockRailwaySign ? (((BlockRailwaySign)block.data).length + (((BlockRailwaySign)block.data).isOdd ? 2 : 0)) % 4 : IBlock.getStatePropertySafe(stateBelow, TYPE);
        return super.placeWithState(stateBelow).with(new Property((net.minecraft.state.Property)BlockRailwaySignPole.TYPE.data), type);
    }

    @Override
    protected boolean isBlock(Block block) {
        return block.data instanceof BlockRailwaySign && ((BlockRailwaySign)block.data).length > 0 || block.data instanceof BlockRailwaySignPole;
    }

    @Override
    protected Text getTooltipBlockText() {
        return TranslationProvider.BLOCK_MTR_RAILWAY_SIGN.getText(new Object[0]);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(TYPE);
    }
}

