/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.SoundEvents;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.TicketSystem;

public class BlockTicketBarrier
extends BlockExtension
implements DirectionHelper {
    private final boolean isEntrance;
    public static final EnumProperty<TicketSystem.EnumTicketBarrierOpen> OPEN = EnumProperty.of("open", TicketSystem.EnumTicketBarrierOpen.class);

    public BlockTicketBarrier(boolean isEntrance) {
        super(Blocks.createDefaultBlockSettings(true, blockState -> 5));
        this.isEntrance = isEntrance;
    }

    @Override
    public void onEntityCollision2(BlockState state, World world, BlockPos blockPos, Entity entity) {
        if (!world.isClient() && PlayerEntity.isInstance(entity)) {
            Direction facing = IBlock.getStatePropertySafe(state, FACING);
            Vector3d playerPosRotated = entity.getPos().subtract((double)blockPos.getX() + 0.5, 0.0, (double)blockPos.getZ() + 0.5).rotateY((float)Math.toRadians(facing.asRotation()));
            TicketSystem.EnumTicketBarrierOpen open = (TicketSystem.EnumTicketBarrierOpen)IBlock.getStatePropertySafe(state, new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data));
            if ((open == TicketSystem.EnumTicketBarrierOpen.OPEN || open == TicketSystem.EnumTicketBarrierOpen.OPEN_CONCESSIONARY) && playerPosRotated.getZMapped() > 0.0) {
                world.setBlockState(blockPos, state.with(new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data), TicketSystem.EnumTicketBarrierOpen.CLOSED));
            } else if (open == TicketSystem.EnumTicketBarrierOpen.CLOSED && playerPosRotated.getZMapped() < 0.0) {
                BlockPos blockPosCopy = new BlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                world.setBlockState(blockPosCopy, state.with(new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data), TicketSystem.EnumTicketBarrierOpen.PENDING));
                TicketSystem.passThrough(world, blockPosCopy, PlayerEntity.cast(entity), this.isEntrance, !this.isEntrance, SoundEvents.TICKET_BARRIER.get(), SoundEvents.TICKET_BARRIER_CONCESSIONARY.get(), SoundEvents.TICKET_BARRIER.get(), SoundEvents.TICKET_BARRIER_CONCESSIONARY.get(), null, false, newOpen -> {
                    world.setBlockState(blockPosCopy, state.with(new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data), newOpen));
                    if (newOpen != TicketSystem.EnumTicketBarrierOpen.CLOSED && !BlockTicketBarrier.hasScheduledBlockTick(world, blockPosCopy, new Block(this))) {
                        BlockTicketBarrier.scheduleBlockTick(world, blockPosCopy, new Block(this), 40);
                    }
                });
            }
        }
    }

    @Override
    public void scheduledTick2(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.setBlockState(pos, state.with(new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data), TicketSystem.EnumTicketBarrierOpen.CLOSED));
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockTicketBarrier.FACING.data), ctx.getPlayerFacing().data).with(new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data), TicketSystem.EnumTicketBarrierOpen.CLOSED);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        return IBlock.getVoxelShapeByDirection(12.0, 0.0, 0.0, 16.0, 15.0, 16.0, facing);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        TicketSystem.EnumTicketBarrierOpen open = (TicketSystem.EnumTicketBarrierOpen)IBlock.getStatePropertySafe(state, new Property((net.minecraft.state.Property)BlockTicketBarrier.OPEN.data));
        VoxelShape base = IBlock.getVoxelShapeByDirection(15.0, 0.0, 0.0, 16.0, 24.0, 16.0, facing);
        return open == TicketSystem.EnumTicketBarrierOpen.OPEN || open == TicketSystem.EnumTicketBarrierOpen.OPEN_CONCESSIONARY ? base : VoxelShapes.union(IBlock.getVoxelShapeByDirection(0.0, 0.0, 7.0, 16.0, 24.0, 9.0, facing), base);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(OPEN);
    }
}

