/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import net.minecraft.util.text.ITextComponent;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.KeyBindings;

public class DebugKeys {
    private int index;
    private boolean isPressing;
    private float lastPressedTicks;
    private final int categories;
    private final float scale;
    private final int[] field1;
    private final int[] field2;
    private final int[] field3;

    public DebugKeys(int categories, float scale) {
        this.categories = categories;
        this.scale = scale;
        this.field1 = new int[categories];
        this.field2 = new int[categories];
        this.field3 = new int[categories];
    }

    public void tick() {
        boolean fastPress;
        boolean shouldIncrement;
        boolean tempPressing1Negative = KeyBindings.DEBUG_1_NEGATIVE.isPressed();
        boolean tempPressing2Negative = KeyBindings.DEBUG_2_NEGATIVE.isPressed();
        boolean tempPressing3Negative = KeyBindings.DEBUG_3_NEGATIVE.isPressed();
        boolean tempPressing1Positive = KeyBindings.DEBUG_1_POSITIVE.isPressed();
        boolean tempPressing2Positive = KeyBindings.DEBUG_2_POSITIVE.isPressed();
        boolean tempPressing3Positive = KeyBindings.DEBUG_3_POSITIVE.isPressed();
        boolean tempPressingCategoryNegative = KeyBindings.DEBUG_ROTATE_CATEGORY_NEGATIVE.isPressed();
        boolean tempPressingCategoryPositive = KeyBindings.DEBUG_ROTATE_CATEGORY_POSITIVE.isPressed();
        boolean tempIsPressing = tempPressing1Negative || tempPressing2Negative || tempPressing3Negative || tempPressing1Positive || tempPressing2Positive || tempPressing3Positive || tempPressingCategoryNegative || tempPressingCategoryPositive;
        float gameTick = InitClient.getGameTick();
        if (!this.isPressing && tempIsPressing) {
            this.lastPressedTicks = gameTick;
            shouldIncrement = true;
            fastPress = false;
        } else {
            shouldIncrement = tempIsPressing && gameTick - this.lastPressedTicks > 10.0f;
            fastPress = true;
        }
        if (shouldIncrement) {
            int n = this.index = (this.categories + this.index + (tempPressingCategoryNegative ? -1 : (tempPressingCategoryPositive ? 1 : 0))) % this.categories;
            this.field1[n] = this.field1[n] + (fastPress ? 10 : 1) * (tempPressing1Negative ? -1 : (tempPressing1Positive ? 1 : 0));
            int n2 = this.index;
            this.field2[n2] = this.field2[n2] + (fastPress ? 10 : 1) * (tempPressing2Negative ? -1 : (tempPressing2Positive ? 1 : 0));
            int n3 = this.index;
            this.field3[n3] = this.field3[n3] + (fastPress ? 10 : 1) * (tempPressing3Negative ? -1 : (tempPressing3Positive ? 1 : 0));
            ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
            if (clientPlayerEntity != null) {
                if (tempPressingCategoryNegative || tempPressingCategoryPositive) {
                    clientPlayerEntity.sendMessage(new Text((ITextComponent)TextHelper.literal((String)String.format((String)"Category: %s", (Object[])new Object[]{Integer.valueOf((int)this.index)})).data), true);
                }
                if (tempPressing1Negative || tempPressing1Positive) {
                    clientPlayerEntity.sendMessage(new Text((ITextComponent)TextHelper.literal((String)String.format((String)"Category: %s - Value: %s", (Object[])new Object[]{Integer.valueOf((int)this.index), Double.valueOf((double)this.getField1((int)this.index))})).data), true);
                }
                if (tempPressing2Negative || tempPressing2Positive) {
                    clientPlayerEntity.sendMessage(new Text((ITextComponent)TextHelper.literal((String)String.format((String)"Category: %s - Value: %s", (Object[])new Object[]{Integer.valueOf((int)this.index), Double.valueOf((double)this.getField2((int)this.index))})).data), true);
                }
                if (tempPressing3Negative || tempPressing3Positive) {
                    clientPlayerEntity.sendMessage(new Text((ITextComponent)TextHelper.literal((String)String.format((String)"Category: %s - Value: %s", (Object[])new Object[]{Integer.valueOf((int)this.index), Double.valueOf((double)this.getField3((int)this.index))})).data), true);
                }
            }
        }
        this.isPressing = tempIsPressing;
    }

    public double getField1(int category) {
        return Utilities.round((float)this.field1[Math.abs(category) % this.categories] * this.scale, 5);
    }

    public double getField2(int category) {
        return Utilities.round((float)this.field2[Math.abs(category) % this.categories] * this.scale, 5);
    }

    public double getField3(int category) {
        return Utilities.round((float)this.field3[Math.abs(category) % this.categories] * this.scale, 5);
    }
}

