/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.config;

import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.mod.config.LanguageDisplay;
import org.mtr.mod.generated.config.ClientSchema;

public final class Client
extends ClientSchema {
    public static final int DYNAMIC_RESOLUTION_COUNT = 8;
    public static final int TRAIN_OSCILLATION_COUNT = 15;

    public Client(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public boolean getChatAnnouncements() {
        return this.chatAnnouncements;
    }

    public boolean getTextToSpeechAnnouncements() {
        return this.textToSpeechAnnouncements;
    }

    public boolean getHideTranslucentParts() {
        return this.hideTranslucentParts;
    }

    public LanguageDisplay getLanguageDisplay() {
        return this.languageDisplay;
    }

    public int getDynamicTextureResolution() {
        return (int)this.dynamicTextureResolution;
    }

    public double getVehicleOscillationMultiplier() {
        return this.vehicleOscillationMultiplier;
    }

    public boolean getDefaultRail3D() {
        return this.defaultRail3D;
    }

    public boolean getUseMTRFont() {
        return this.useMTRFont;
    }

    public boolean getDisableShadowsForShaders() {
        return this.disableShadowsForShaders;
    }

    public boolean matchesPreloadResourcePattern(String id) {
        return id.replaceFirst(this.preloadResourcePattern, "").isEmpty();
    }

    public boolean showBetaWarningScreen() {
        return false;
    }

    public void toggleChatAnnouncements() {
        this.chatAnnouncements = !this.chatAnnouncements;
    }

    public void toggleTextToSpeechAnnouncements() {
        this.textToSpeechAnnouncements = !this.textToSpeechAnnouncements;
    }

    public void toggleHideTranslucentParts() {
        this.hideTranslucentParts = !this.hideTranslucentParts;
    }

    public void cycleLanguageDisplay() {
        this.languageDisplay = LanguageDisplay.values()[(this.languageDisplay.ordinal() + 1) % LanguageDisplay.values().length];
    }

    public void setDynamicTextureResolution(int dynamicTextureResolution) {
        this.dynamicTextureResolution = Utilities.clamp(dynamicTextureResolution, 0, 8);
    }

    public void setVehicleOscillationMultiplier(double trainOscillationMultiplier) {
        this.vehicleOscillationMultiplier = Utilities.clamp(trainOscillationMultiplier, 0.0, 1.5);
    }

    public void toggleDefaultRail3D() {
        this.defaultRail3D = !this.defaultRail3D;
    }

    public void toggleUseMTRFont() {
        this.useMTRFont = !this.useMTRFont;
    }

    public void toggleDisableShadowsForShaders() {
        this.disableShadowsForShaders = !this.disableShadowsForShaders;
    }

    public void hideBetaWarningScreen() {
        this.betaWarningVersion = "4.0.2+1.16.5";
    }
}

