/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mtr.core.data.Rail;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.SlabBlock;
import org.mtr.mapping.holder.SlabType;
import org.mtr.mapping.mapper.SlabBlockExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.block.BlockNode;
import org.mtr.mod.data.RailActionType;

public class RailAction {
    private double distance;
    public final long id;
    private final ServerWorld serverWorld;
    private final UUID uuid;
    private final String playerName;
    private final RailActionType railActionType;
    private final Rail rail;
    private final int radius;
    private final int height;
    private final double length;
    private final BlockState state;
    private final boolean isSlab;
    private final ObjectOpenHashSet<BlockPos> blacklistedPositions = new ObjectOpenHashSet();
    private static final double INCREMENT = 0.1;

    public RailAction(ServerWorld serverWorld, ServerPlayerEntity serverPlayerEntity, RailActionType railActionType, Rail rail, int radius, int height, @Nullable BlockState state) {
        this.id = new Random().nextLong();
        this.serverWorld = serverWorld;
        this.uuid = serverPlayerEntity.getUuid();
        this.playerName = serverPlayerEntity.getName().getString();
        this.railActionType = railActionType;
        this.rail = rail;
        this.radius = radius;
        this.height = height;
        this.state = state;
        this.isSlab = state != null && SlabBlock.isInstance(state.getBlock());
        this.length = rail.railMath.getLength();
        this.distance = 0.0;
    }

    public String getDescription() {
        return this.railActionType.nameTranslation.getString(this.playerName, Utilities.round(this.length, 1), this.state == null ? "" : TextHelper.translatable(this.state.getBlock().getTranslationKey(), new Object[0]).getString());
    }

    public int getColor() {
        return this.railActionType.color;
    }

    public boolean build() {
        switch (this.railActionType) {
            case BRIDGE: {
                return this.createBridge();
            }
            case TUNNEL: {
                return this.createTunnel();
            }
            case TUNNEL_WALL: {
                return this.createTunnelWall();
            }
        }
        return true;
    }

    private boolean createTunnel() {
        return this.create(true, vector -> {
            BlockPos blockPos = RailAction.fromVector(vector);
            if (!this.blacklistedPositions.contains(blockPos) && RailAction.canPlace(this.serverWorld, blockPos)) {
                this.serverWorld.setBlockState(blockPos, Blocks.getAirMapped().getDefaultState());
                this.blacklistedPositions.add(blockPos);
            }
        });
    }

    private boolean createTunnelWall() {
        return this.create(false, vector -> {
            BlockPos blockPos = RailAction.fromVector(vector);
            if (!this.blacklistedPositions.contains(blockPos) && RailAction.canPlace(this.serverWorld, blockPos)) {
                this.serverWorld.setBlockState(blockPos, this.state);
                this.blacklistedPositions.add(blockPos);
            }
        });
    }

    private boolean createBridge() {
        return this.create(false, vector -> {
            boolean placeHalf;
            BlockState placeState;
            BlockPos placePos;
            boolean isTopHalf = vector.y - Math.floor(vector.y) >= 0.5;
            BlockPos blockPos = RailAction.fromVector(vector);
            if (this.isSlab && isTopHalf) {
                placePos = blockPos;
                placeState = this.state.with(new Property(SlabBlockExtension.field_196505_a), SlabType.BOTTOM.data);
                placeHalf = false;
            } else {
                placePos = blockPos.down();
                placeState = this.isSlab ? this.state.with(new Property(SlabBlockExtension.field_196505_a), SlabType.TOP.data) : this.state;
                placeHalf = true;
            }
            BlockPos halfPos = RailAction.getHalfPos(placePos, placeHalf);
            if (this.blacklistedPositions.contains(halfPos)) {
                return;
            }
            if (placePos != blockPos && RailAction.canPlace(this.serverWorld, blockPos)) {
                this.serverWorld.setBlockState(blockPos, Blocks.getAirMapped().getDefaultState());
            }
            if (RailAction.canPlace(this.serverWorld, placePos)) {
                this.serverWorld.setBlockState(placePos, placeState);
                this.blacklistedPositions.add(halfPos);
            }
        });
    }

    private boolean create(boolean includeMiddle, Consumer<Vector> consumer) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 2L) {
            Vector pos1 = this.rail.railMath.getPosition(this.distance, false);
            this.distance += 0.1;
            Vector pos2 = this.rail.railMath.getPosition(this.distance, false);
            Vector vec3 = new Vector(pos2.x - pos1.x, 0.0, pos2.z - pos1.z).normalize().rotateY(1.5707963705062866);
            for (double x = (double)(-this.radius); x <= (double)this.radius; x += 0.1) {
                boolean wholeNumber;
                Vector editPos = pos1.add(vec3.multiply(x, 0.0, x));
                boolean bl = wholeNumber = Math.floor(editPos.y) == Math.ceil(editPos.y);
                if (includeMiddle || Math.abs(x) > (double)this.radius - 0.1 || this.radius == 0) {
                    for (int y = 0; y <= this.height; ++y) {
                        if (y >= this.height && wholeNumber && (this.height != 0 || this.radius != 0)) continue;
                        consumer.accept(editPos.add(0.0, y, 0.0));
                    }
                    continue;
                }
                consumer.accept(editPos.add(0.0, Math.max(0, wholeNumber ? this.height - 1 : this.height), 0.0));
            }
            if (!(this.length - this.distance < 0.1)) continue;
            this.sendProgressMessage(100.0f);
            return true;
        }
        this.sendProgressMessage((float)Utilities.round(100.0 * this.distance / this.length, 1));
        return false;
    }

    private void sendProgressMessage(float percentage) {
        PlayerEntity playerEntity = this.serverWorld.getPlayerByUuid(this.uuid);
        if (playerEntity != null) {
            playerEntity.sendMessage(this.railActionType.progressTranslation.getText(Float.valueOf(percentage)), true);
        }
    }

    private static boolean canPlace(ServerWorld serverWorld, BlockPos pos) {
        return serverWorld.getBlockEntity(pos) == null && !(serverWorld.getBlockState((BlockPos)pos).getBlock().data instanceof BlockNode);
    }

    private static BlockPos getHalfPos(BlockPos pos, boolean isTopHalf) {
        return new BlockPos(pos.getX(), pos.getY() * 2 + (isTopHalf ? 1 : 0), pos.getZ());
    }

    private static BlockPos fromVector(Vector vector) {
        return Init.newBlockPos(vector.x, vector.y, vector.z);
    }
}

