/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.data;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import org.mtr.core.data.Station;
import org.mtr.core.operation.NearbyAreasRequest;
import org.mtr.core.operation.NearbyAreasResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ScoreboardCriterionRenderType;
import org.mtr.mapping.holder.ScoreboardObjective;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ScoreboardCriteria;
import org.mtr.mapping.mapper.ScoreboardHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.generated.lang.TranslationProvider;

public class TicketSystem {
    public static final String BALANCE_OBJECTIVE = "mtr_balance";
    public static final String BALANCE_OBJECTIVE_TITLE = "Balance";
    private static final String ENTRY_ZONE_1_OBJECTIVE = "mtr_entry_zone_1";
    private static final String ENTRY_ZONE_1_TITLE = "Entry Zone 1";
    private static final String ENTRY_ZONE_2_OBJECTIVE = "mtr_entry_zone_2";
    private static final String ENTRY_ZONE_2_TITLE = "Entry Zone 2";
    private static final String ENTRY_ZONE_3_OBJECTIVE = "mtr_entry_zone_3";
    private static final String ENTRY_ZONE_3_TITLE = "Entry Zone 3";
    private static final int BASE_FARE = 2;
    private static final int ZONE_FARE = 1;
    private static final int EVASION_FINE = 500;

    public static void passThrough(World world, BlockPos blockPos, PlayerEntity player, boolean isEntrance, boolean isExit, SoundEvent entrySound, SoundEvent entrySoundConcessionary, SoundEvent exitSound, SoundEvent exitSoundConcessionary, @Nullable SoundEvent failSound, boolean remindIfNoRecord, Consumer<EnumTicketBarrierOpen> callback) {
        Init.sendMessageC2S("nearby_stations", world.getServer(), world, new NearbyAreasRequest(Init.blockPosToPosition(blockPos), 0L), nearbyAreasResponse -> {
            ObjectImmutableList<Station> stations = nearbyAreasResponse.getStations();
            if (stations.isEmpty()) {
                callback.accept(EnumTicketBarrierOpen.CLOSED);
            } else {
                Station station = stations.get(0);
                boolean isEntering = isEntrance && isExit ? !TicketSystem.entered(TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_1_OBJECTIVE, ENTRY_ZONE_1_TITLE), TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_2_OBJECTIVE, ENTRY_ZONE_2_TITLE), TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_3_OBJECTIVE, ENTRY_ZONE_3_TITLE)) : isEntrance;
                boolean canOpen = isEntering ? TicketSystem.onEnter(world, station, player, remindIfNoRecord) : TicketSystem.onExit(world, station, player, remindIfNoRecord);
                if (canOpen) {
                    world.playSound(null, blockPos, TicketSystem.isConcessionary(player) ? (isEntering ? entrySoundConcessionary : exitSoundConcessionary) : (isEntering ? entrySound : exitSound), SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (failSound != null) {
                    world.playSound(null, blockPos, failSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                callback.accept(canOpen ? (TicketSystem.isConcessionary(player) ? EnumTicketBarrierOpen.OPEN_CONCESSIONARY : EnumTicketBarrierOpen.OPEN) : EnumTicketBarrierOpen.CLOSED);
            }
        }, NearbyAreasResponse.class);
    }

    public static int getBalance(World world, PlayerEntity player) {
        return TicketSystem.getPlayerScore(world, player, BALANCE_OBJECTIVE, BALANCE_OBJECTIVE_TITLE);
    }

    public static void addBalance(World world, PlayerEntity player, int amount) {
        TicketSystem.incrementPlayerScore(world, player, BALANCE_OBJECTIVE, BALANCE_OBJECTIVE_TITLE, amount);
    }

    private static int getPlayerScore(World world, PlayerEntity player, String objective, String title) {
        ScoreboardObjective scoreboardObjective = TicketSystem.getOrCreateScoreboardObjective(world, objective, title);
        return scoreboardObjective == null ? 0 : ScoreboardHelper.getPlayerScore(world.getScoreboard(), player.getGameProfile().getName(), scoreboardObjective);
    }

    private static void setPlayerScore(World world, PlayerEntity player, String objective, String title, int value) {
        ScoreboardObjective scoreboardObjective = TicketSystem.getOrCreateScoreboardObjective(world, objective, title);
        if (scoreboardObjective != null) {
            ScoreboardHelper.setPlayerScore(world.getScoreboard(), player.getGameProfile().getName(), scoreboardObjective, value);
        }
    }

    private static void incrementPlayerScore(World world, PlayerEntity player, String objective, String title, int value) {
        ScoreboardObjective scoreboardObjective = TicketSystem.getOrCreateScoreboardObjective(world, objective, title);
        if (scoreboardObjective != null) {
            ScoreboardHelper.incrementPlayerScore(world.getScoreboard(), player.getGameProfile().getName(), scoreboardObjective, value);
        }
    }

    @Nullable
    private static ScoreboardObjective getOrCreateScoreboardObjective(World world, String objective, String title) {
        try {
            return ScoreboardHelper.addObjective(world.getScoreboard(), objective, ScoreboardCriteria.DUMMY, new Text((ITextComponent)TextHelper.literal((String)title).data), ScoreboardCriterionRenderType.INTEGER);
        }
        catch (Exception exception) {
            return ScoreboardHelper.getScoreboardObjective(world.getScoreboard(), objective);
        }
    }

    private static boolean onEnter(World world, Station station, PlayerEntity player, boolean remindIfNoRecord) {
        int balance;
        int entryZone3;
        int entryZone2;
        int entryZone1 = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_1_OBJECTIVE, ENTRY_ZONE_1_TITLE);
        if (TicketSystem.entered(entryZone1, entryZone2 = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_2_OBJECTIVE, ENTRY_ZONE_2_TITLE), entryZone3 = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_3_OBJECTIVE, ENTRY_ZONE_3_TITLE))) {
            if (remindIfNoRecord) {
                player.sendMessage(TranslationProvider.GUI_MTR_ALREADY_ENTERED.getText(new Object[0]), true);
                return false;
            }
            TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_1_OBJECTIVE, ENTRY_ZONE_1_TITLE, 0);
            TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_2_OBJECTIVE, ENTRY_ZONE_2_TITLE, 0);
            TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_3_OBJECTIVE, ENTRY_ZONE_3_TITLE, 0);
            TicketSystem.incrementPlayerScore(world, player, BALANCE_OBJECTIVE, BALANCE_OBJECTIVE_TITLE, -500);
        }
        if ((balance = TicketSystem.getPlayerScore(world, player, BALANCE_OBJECTIVE, BALANCE_OBJECTIVE_TITLE)) >= 0) {
            TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_1_OBJECTIVE, ENTRY_ZONE_1_TITLE, TicketSystem.encodeZone((int)station.getZone1()));
            TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_2_OBJECTIVE, ENTRY_ZONE_2_TITLE, TicketSystem.encodeZone((int)station.getZone2()));
            TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_3_OBJECTIVE, ENTRY_ZONE_3_TITLE, TicketSystem.encodeZone((int)station.getZone3()));
            player.sendMessage(TranslationProvider.GUI_MTR_ENTER_BARRIER.getText(TicketSystem.formatStationName(station), balance), true);
            return true;
        }
        player.sendMessage(TranslationProvider.GUI_MTR_INSUFFICIENT_BALANCE.getText(balance), true);
        return false;
    }

    private static boolean onExit(World world, Station station, PlayerEntity player, boolean remindIfNoRecord) {
        int entryZone3;
        int entryZone2;
        int entryZone1 = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_1_OBJECTIVE, ENTRY_ZONE_1_TITLE);
        boolean entered = TicketSystem.entered(entryZone1, entryZone2 = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_2_OBJECTIVE, ENTRY_ZONE_2_TITLE), entryZone3 = TicketSystem.getPlayerScore(world, player, ENTRY_ZONE_3_OBJECTIVE, ENTRY_ZONE_3_TITLE));
        if (!entered && remindIfNoRecord) {
            player.sendMessage(TranslationProvider.GUI_MTR_ALREADY_EXITED.getText(new Object[0]), true);
            return false;
        }
        long fare = 2L + 1L * (Math.abs(station.getZone1() - (long)TicketSystem.decodeZone(entryZone1)) + Math.abs(station.getZone2() - (long)TicketSystem.decodeZone(entryZone2)) + Math.abs(station.getZone3() - (long)TicketSystem.decodeZone(entryZone3)));
        long finalFare = entered ? (TicketSystem.isConcessionary(player) ? (long)Math.ceil((float)fare / 2.0f) : fare) : 500L;
        TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_1_OBJECTIVE, ENTRY_ZONE_1_TITLE, 0);
        TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_2_OBJECTIVE, ENTRY_ZONE_2_TITLE, 0);
        TicketSystem.setPlayerScore(world, player, ENTRY_ZONE_3_OBJECTIVE, ENTRY_ZONE_3_TITLE, 0);
        TicketSystem.incrementPlayerScore(world, player, BALANCE_OBJECTIVE, BALANCE_OBJECTIVE_TITLE, (int)(-finalFare));
        int balance = TicketSystem.getPlayerScore(world, player, BALANCE_OBJECTIVE, BALANCE_OBJECTIVE_TITLE);
        player.sendMessage(TranslationProvider.GUI_MTR_EXIT_BARRIER.getText(TicketSystem.formatStationName(station), finalFare, balance), true);
        return true;
    }

    private static boolean isConcessionary(PlayerEntity player) {
        return player.isCreative();
    }

    private static boolean entered(int entryZone1, int entryZone2, int entryZone3) {
        return entryZone1 != 0 && entryZone2 != 0 && entryZone3 != 0;
    }

    private static int encodeZone(int zone) {
        return zone >= 0 ? zone + 1 : zone;
    }

    private static int decodeZone(int zone) {
        return zone > 0 ? zone - 1 : zone;
    }

    private static String formatStationName(Station station) {
        return String.format("%s (%s/%s/%s)", station.getName().replace('|', ' '), station.getZone1(), station.getZone2(), station.getZone3());
    }

    public static enum EnumTicketBarrierOpen implements StringIdentifiable
    {
        CLOSED("closed"),
        PENDING("pending"),
        OPEN("open"),
        OPEN_CONCESSIONARY("open_concessionary");

        private final String name;

        private EnumTicketBarrierOpen(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

