/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.packet;

import java.util.UUID;
import java.util.stream.Collectors;
import org.mtr.core.data.Rail;
import org.mtr.core.data.TransportMode;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.core.tool.EnumHelper;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.packet.PacketUpdateData;

public final class PacketUpdateLastRailStyles
extends PacketHandler {
    private final TransportMode transportMode;
    private final ObjectArrayList<String> styles;
    public static final Cache SERVER_CACHE = new Cache();
    public static final Cache CLIENT_CACHE = new Cache();

    public PacketUpdateLastRailStyles(PacketBufferReceiver packetBufferReceiver) {
        this.transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packetBufferReceiver.readString());
        int count = packetBufferReceiver.readInt();
        this.styles = new ObjectArrayList(count);
        for (int i = 0; i < count; ++i) {
            this.styles.add(packetBufferReceiver.readString());
        }
    }

    public PacketUpdateLastRailStyles(UUID uuid, TransportMode transportMode, ObjectArrayList<String> styles) {
        this.transportMode = transportMode;
        this.styles = styles;
        PacketUpdateLastRailStyles.CLIENT_CACHE.setLastStyles(uuid, transportMode, styles);
    }

    @Override
    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.transportMode.toString());
        packetBufferSender.writeInt(this.styles.size());
        this.styles.forEach(packetBufferSender::writeString);
    }

    @Override
    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        PacketUpdateLastRailStyles.SERVER_CACHE.setLastStyles(serverPlayerEntity.getUuid(), this.transportMode, this.styles);
    }

    public static class Cache {
        private final Object2ObjectAVLTreeMap<UUID, Object2ObjectAVLTreeMap<TransportMode, ObjectArrayList<String>>> cache = new Object2ObjectAVLTreeMap();

        public boolean canApplyStylesToRail(UUID uuid, Rail rail, boolean modifyRail) {
            ObjectImmutableList<String> railStyles;
            ObjectArrayList<String> lastStyles = this.cache.getOrDefault(uuid, Cache.getDefaultStyles()).get((Object)rail.getTransportMode());
            if (Utilities.sameItems(lastStyles, railStyles = rail.getStyles())) {
                return false;
            }
            if (modifyRail) {
                InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getInstance()).addRail(this.getRailWithLastStyles(uuid, rail))));
            }
            return true;
        }

        public Rail getRailWithLastStyles(UUID uuid, Rail rail) {
            return Rail.copy(rail, this.cache.getOrDefault(uuid, Cache.getDefaultStyles()).get((Object)rail.getTransportMode()));
        }

        private void setLastStyles(UUID uuid, TransportMode transportMode, ObjectList<String> styles) {
            ObjectArrayList existingStyles = (ObjectArrayList)this.cache.computeIfAbsent(uuid, key -> Cache.getDefaultStyles()).get((Object)transportMode);
            existingStyles.clear();
            existingStyles.addAll(styles.stream().distinct().sorted().collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        private static Object2ObjectAVLTreeMap<TransportMode, ObjectArrayList<String>> getDefaultStyles() {
            Object2ObjectAVLTreeMap<TransportMode, ObjectArrayList<String>> stylesForTransportMode = new Object2ObjectAVLTreeMap<TransportMode, ObjectArrayList<String>>();
            for (TransportMode transportMode : TransportMode.values()) {
                stylesForTransportMode.put(transportMode, transportMode == TransportMode.BOAT ? new ObjectArrayList() : ObjectArrayList.of(new String[]{"default"}));
            }
            return stylesForTransportMode;
        }
    }
}

