/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import org.mtr.core.data.SimplifiedRoute;
import org.mtr.core.data.SimplifiedRoutePlatform;
import org.mtr.core.data.Station;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.BlockEntityAbstractMapping;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockArrivalProjectorBase;
import org.mtr.mod.block.BlockPIDSBase;
import org.mtr.mod.block.BlockPIDSHorizontalBase;
import org.mtr.mod.block.BlockPIDSVerticalSingleArrival1;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.ArrivalsCacheClient;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;

public class RenderPIDS<T extends BlockPIDSBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
Utilities {
    private final float startX;
    private final float startY;
    private final float startZ;
    private final float maxHeight;
    private final float maxWidth;
    private final boolean rotate90;
    private final float textPadding;
    public static final int SWITCH_LANGUAGE_TICKS = 60;
    private static final int STATIONS_PER_PAGE = 10;
    private static final int SWITCH_PAGE_TICKS = 120;

    public RenderPIDS(BlockEntityRenderer.Argument dispatcher, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, float textPadding) {
        super(dispatcher);
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.rotate90 = rotate90;
        this.textPadding = textPadding;
    }

    @Override
    public final void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = ((BlockEntityAbstractMapping)((Object)entity)).getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = ((BlockEntityAbstractMapping)((Object)entity)).getPos2();
        if (!((BlockPIDSBase.BlockEntityBase)((Object)entity)).canStoreData.test(world, blockPos)) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe(world, blockPos, DirectionHelper.FACING);
        if (((BlockPIDSBase.BlockEntityBase)((Object)entity)).getPlatformIds().isEmpty()) {
            LongArrayList platformIds = new LongArrayList();
            if (entity instanceof BlockArrivalProjectorBase.BlockEntityArrivalProjectorBase) {
                Station station = InitClient.findStation(blockPos);
                if (station != null) {
                    station.savedRails.forEach(platform -> platformIds.add(platform.getId()));
                }
            } else {
                InitClient.findClosePlatform(((BlockEntityAbstractMapping)((Object)entity)).getPos2().down(4), 5, platform -> platformIds.add(platform.getId()));
            }
            this.getArrivalsAndRender(entity, blockPos, facing, platformIds);
        } else {
            this.getArrivalsAndRender(entity, blockPos, facing, ((BlockPIDSBase.BlockEntityBase)((Object)entity)).getPlatformIds());
        }
    }

    public void renderText(GraphicsHolder graphicsHolder, String text, int x, int y, int color) {
        graphicsHolder.drawText(text, x, y, color, false, GraphicsHolder.getDefaultLight());
    }

    public String getArrivalString(long arrival, boolean isRealtime, boolean isCjk) {
        if (arrival >= 60L) {
            return (isRealtime ? "" : "*") + (isCjk ? TranslationProvider.GUI_MTR_ARRIVAL_MIN_CJK : TranslationProvider.GUI_MTR_ARRIVAL_MIN).getString(arrival / 60L);
        }
        if (arrival > 0L) {
            return (isRealtime ? "" : "*") + (isCjk ? TranslationProvider.GUI_MTR_ARRIVAL_SEC_CJK : TranslationProvider.GUI_MTR_ARRIVAL_SEC).getString(arrival);
        }
        return "";
    }

    private void getArrivalsAndRender(T entity, BlockPos blockPos, Direction facing, LongCollection platformIds) {
        ObjectArrayList<ArrivalResponse> arrivalResponseList = ArrivalsCacheClient.INSTANCE.requestArrivals(platformIds);
        MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
            this.render(entity, blockPos, facing, arrivalResponseList, (GraphicsHolder)graphicsHolder, (Vector3d)offset);
            if (entity instanceof BlockPIDSHorizontalBase.BlockEntityHorizontalBase) {
                this.render(entity, blockPos.offset(facing), facing.getOpposite(), arrivalResponseList, (GraphicsHolder)graphicsHolder, (Vector3d)offset);
            }
        });
    }

    private void render(T entity, BlockPos blockPos, Direction facing, ObjectArrayList<ArrivalResponse> arrivalResponseList, GraphicsHolder graphicsHolder, Vector3d offset) {
        float scale = (float)(160 * ((BlockPIDSBase.BlockEntityBase)((Object)entity)).maxArrivals) / this.maxHeight * this.textPadding;
        boolean hasDifferentCarLengths = RenderPIDS.hasDifferentCarLengths(arrivalResponseList);
        boolean isSingleArrival = entity instanceof BlockPIDSVerticalSingleArrival1.BlockEntity;
        int arrivalsPerPage = isSingleArrival ? 1 : (((BlockPIDSBase.BlockEntityBase)((Object)entity)).alternateLines() ? ((BlockPIDSBase.BlockEntityBase)((Object)entity)).maxArrivals / 2 : ((BlockPIDSBase.BlockEntityBase)((Object)entity)).maxArrivals);
        int arrivalIndex = ((BlockPIDSBase.BlockEntityBase)((Object)entity)).getDisplayPage() * arrivalsPerPage;
        for (int i = 0; i < ((BlockPIDSBase.BlockEntityBase)((Object)entity)).maxArrivals; ++i) {
            int languageIndex;
            boolean renderCustomMessage;
            String[] destinationSplit;
            ArrivalResponse arrivalResponse;
            int languageTicks = (int)Math.floor(InitClient.getGameTick()) / 60;
            String customMessage = ((BlockPIDSBase.BlockEntityBase)((Object)entity)).getMessage(i);
            String[] customMessageSplit = customMessage.split("\\|");
            if (((BlockPIDSBase.BlockEntityBase)((Object)entity)).getHideArrival(i)) {
                if (customMessage.isEmpty()) continue;
                arrivalResponse = null;
                destinationSplit = new String[]{};
                renderCustomMessage = true;
                languageIndex = languageTicks % customMessageSplit.length;
            } else {
                arrivalResponse = (ArrivalResponse)Utilities.getElement(arrivalResponseList, arrivalIndex);
                if (arrivalResponse == null) {
                    if (customMessage.isEmpty() || customMessageSplit.length == 0) continue;
                    destinationSplit = new String[]{};
                    renderCustomMessage = true;
                    languageIndex = languageTicks % customMessageSplit.length;
                } else {
                    String[] tempDestinationSplit = arrivalResponse.getDestination().split("\\|");
                    if (arrivalResponse.getRouteNumber().isEmpty()) {
                        destinationSplit = tempDestinationSplit;
                    } else {
                        String newDestination;
                        String[] tempNumberSplit = arrivalResponse.getRouteNumber().split("\\|");
                        int destinationIndex = 0;
                        int numberIndex = 0;
                        ObjectArrayList<String> newDestinations = new ObjectArrayList<String>();
                        while (!newDestinations.contains(newDestination = String.format("%s %s", tempNumberSplit[numberIndex % tempNumberSplit.length], tempDestinationSplit[destinationIndex % tempDestinationSplit.length]))) {
                            newDestinations.add(newDestination);
                            ++destinationIndex;
                            ++numberIndex;
                        }
                        destinationSplit = newDestinations.toArray(new String[0]);
                    }
                    int messageCount = destinationSplit.length + (customMessage.isEmpty() ? 0 : customMessageSplit.length);
                    renderCustomMessage = languageTicks % messageCount >= destinationSplit.length;
                    languageIndex = languageTicks % messageCount - (renderCustomMessage ? destinationSplit.length : 0);
                    if (!(isSingleArrival || ((BlockPIDSBase.BlockEntityBase)((Object)entity)).alternateLines() && i % 2 != 1)) {
                        ++arrivalIndex;
                    }
                }
            }
            graphicsHolder.push();
            graphicsHolder.translate((double)blockPos.getX() - offset.getXMapped() + 0.5, (double)blockPos.getY() - offset.getYMapped(), (double)blockPos.getZ() - offset.getZMapped() + 0.5);
            graphicsHolder.rotateYDegrees((float)(this.rotate90 ? 90 : 0) - facing.asRotation());
            graphicsHolder.rotateZDegrees(180.0f);
            graphicsHolder.translate((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f + (float)i * this.maxHeight / (float)((BlockPIDSBase.BlockEntityBase)((Object)entity)).maxArrivals / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.00625f);
            graphicsHolder.scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
            if (renderCustomMessage) {
                this.renderText(graphicsHolder, customMessageSplit[languageIndex], ((BlockPIDSBase.BlockEntityBase)((Object)entity)).textColor(), this.maxWidth * scale / 16.0f, IGui.HorizontalAlignment.LEFT);
            } else {
                String destinationFormatted;
                long arrival = (arrivalResponse.getArrival() - ArrivalsCacheClient.INSTANCE.getMillisOffset() - System.currentTimeMillis()) / 1000L;
                int color = arrival <= 0L ? ((BlockPIDSBase.BlockEntityBase)((Object)entity)).textColorArrived() : ((BlockPIDSBase.BlockEntityBase)((Object)entity)).textColor();
                String destination = destinationSplit[languageIndex];
                boolean isCjk = IGui.isCjk(destination);
                switch (arrivalResponse.getCircularState()) {
                    case CLOCKWISE: {
                        destinationFormatted = (isCjk ? TranslationProvider.GUI_MTR_CLOCKWISE_VIA_CJK : TranslationProvider.GUI_MTR_CLOCKWISE_VIA).getString(destination);
                        break;
                    }
                    case ANTICLOCKWISE: {
                        destinationFormatted = (isCjk ? TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA_CJK : TranslationProvider.GUI_MTR_ANTICLOCKWISE_VIA).getString(destination);
                        break;
                    }
                    default: {
                        destinationFormatted = destination;
                    }
                }
                String carLengthString = (isCjk ? TranslationProvider.GUI_MTR_ARRIVAL_CAR_CJK : TranslationProvider.GUI_MTR_ARRIVAL_CAR).getString(arrivalResponse.getCarCount());
                String arrivalString = this.getArrivalString(arrival, arrivalResponse.getRealtime(), isCjk);
                if (isSingleArrival) {
                    if (i == 0) {
                        float halfWidth = this.maxWidth * scale / 16.0f / 2.0f;
                        this.renderText(graphicsHolder, arrivalString, color, halfWidth, IGui.HorizontalAlignment.LEFT);
                        graphicsHolder.translate(halfWidth, 0.0, 0.0);
                        this.renderText(graphicsHolder, (isCjk ? TranslationProvider.GUI_MTR_PLATFORM_ABBREVIATED_CJK : TranslationProvider.GUI_MTR_PLATFORM_ABBREVIATED).getString(arrivalResponse.getPlatformName()), color, halfWidth, IGui.HorizontalAlignment.RIGHT);
                    } else if (i == 1) {
                        this.renderText(graphicsHolder, destinationFormatted, color, this.maxWidth * scale / 16.0f, IGui.HorizontalAlignment.LEFT);
                    } else if (i == 3) {
                        SimplifiedRoute simplifiedRoute = MinecraftClientData.getInstance().simplifiedRouteIdMap.get(arrivalResponse.getRouteId());
                        ObjectArrayList<SimplifiedRoutePlatform> stations = new ObjectArrayList<SimplifiedRoutePlatform>();
                        if (simplifiedRoute != null) {
                            for (int j = simplifiedRoute.getPlatformIndex(arrivalResponse.getPlatformId()) + 1; j < simplifiedRoute.getPlatforms().size(); ++j) {
                                stations.add(simplifiedRoute.getPlatforms().get(j));
                            }
                        }
                        ObjectArrayList<String> lines = new ObjectArrayList<String>();
                        if (stations.isEmpty()) {
                            lines.addAll((ObjectList<String>)RenderPIDS.wrapLines((isCjk ? TranslationProvider.GUI_MTR_TERMINATES_HERE_CJK : TranslationProvider.GUI_MTR_TERMINATES_HERE).getString(new Object[0]), this.maxWidth * scale / 16.0f));
                        } else {
                            int callingAtMaxPages = (int)Math.max(Math.ceil((float)stations.size() / 10.0f), 1.0);
                            int callingAtPage = callingAtMaxPages == 1 ? 0 : (int)Math.floor(InitClient.getGameTick() / 120.0f) % callingAtMaxPages;
                            lines.add((isCjk ? TranslationProvider.GUI_MTR_CALLING_AT_CJK : TranslationProvider.GUI_MTR_CALLING_AT).getString(callingAtPage + 1, callingAtMaxPages));
                            for (int j = 0; j < 10; ++j) {
                                SimplifiedRoutePlatform simplifiedRoutePlatform = (SimplifiedRoutePlatform)Utilities.getElement(stations, j + callingAtPage * 10);
                                if (simplifiedRoutePlatform == null) continue;
                                String[] stationNameSplit = simplifiedRoutePlatform.getStationName().split("\\|");
                                lines.add(stationNameSplit[languageTicks % stationNameSplit.length]);
                            }
                        }
                        lines.forEach(line -> {
                            this.renderText(graphicsHolder, (String)line, color, this.maxWidth * scale / 16.0f, stations.isEmpty() ? IGui.HorizontalAlignment.CENTER : IGui.HorizontalAlignment.LEFT);
                            graphicsHolder.translate(0.0, this.maxHeight * scale / (float)entity.maxArrivals / 16.0f, 0.0);
                        });
                    } else if (i == 15) {
                        this.renderText(graphicsHolder, carLengthString, 0xFF0000, this.maxWidth * scale / 16.0f, IGui.HorizontalAlignment.RIGHT);
                    }
                } else if (((BlockPIDSBase.BlockEntityBase)((Object)entity)).alternateLines()) {
                    if (i % 2 == 0) {
                        this.renderText(graphicsHolder, destinationFormatted, color, this.maxWidth * scale / 16.0f, IGui.HorizontalAlignment.LEFT);
                    } else {
                        if (hasDifferentCarLengths) {
                            this.renderText(graphicsHolder, carLengthString, 0xFF0000, 32.0f, IGui.HorizontalAlignment.LEFT);
                            graphicsHolder.translate(32.0, 0.0, 0.0);
                        }
                        this.renderText(graphicsHolder, arrivalString, color, this.maxWidth * scale / 16.0f - (float)(hasDifferentCarLengths ? 32 : 0), IGui.HorizontalAlignment.RIGHT);
                    }
                } else {
                    boolean showPlatformNumber = entity instanceof BlockArrivalProjectorBase.BlockEntityArrivalProjectorBase;
                    if (((BlockPIDSBase.BlockEntityBase)((Object)entity)).showArrivalNumber()) {
                        this.renderText(graphicsHolder, String.valueOf(arrivalIndex), color, 12.0f, IGui.HorizontalAlignment.LEFT);
                        graphicsHolder.translate(12.0, 0.0, 0.0);
                    }
                    float destinationWidth = this.maxWidth * scale / 16.0f - 40.0f - (float)(hasDifferentCarLengths || showPlatformNumber ? (showPlatformNumber ? 16 : 32) : 0) - (float)(((BlockPIDSBase.BlockEntityBase)((Object)entity)).showArrivalNumber() ? 12 : 0);
                    this.renderText(graphicsHolder, destinationFormatted, color, destinationWidth, IGui.HorizontalAlignment.LEFT);
                    graphicsHolder.translate(destinationWidth, 0.0, 0.0);
                    if (hasDifferentCarLengths || showPlatformNumber) {
                        if (showPlatformNumber) {
                            this.renderText(graphicsHolder, arrivalResponse.getPlatformName(), color, 16.0f, IGui.HorizontalAlignment.LEFT);
                            graphicsHolder.translate(16.0, 0.0, 0.0);
                        } else {
                            this.renderText(graphicsHolder, carLengthString, 0xFF0000, 32.0f, IGui.HorizontalAlignment.LEFT);
                            graphicsHolder.translate(32.0, 0.0, 0.0);
                        }
                    }
                    this.renderText(graphicsHolder, arrivalString, color, 40.0f, IGui.HorizontalAlignment.RIGHT);
                }
            }
            graphicsHolder.pop();
        }
    }

    private void renderText(GraphicsHolder graphicsHolder, String text, int color, float availableWidth, IGui.HorizontalAlignment horizontalAlignment) {
        graphicsHolder.push();
        int textWidth = GraphicsHolder.getTextWidth(text);
        if (availableWidth < (float)textWidth) {
            graphicsHolder.scale(textWidth == 0 ? 1.0f : availableWidth / (float)textWidth, 1.0f, 1.0f);
        }
        this.renderText(graphicsHolder, text, (int)horizontalAlignment.getOffset(0.0f, (float)textWidth - availableWidth), 0, color | 0xFF000000);
        graphicsHolder.pop();
    }

    private static boolean hasDifferentCarLengths(ObjectArrayList<ArrivalResponse> arrivalResponseList) {
        int carCount = 0;
        for (ArrivalResponse arrivalResponse : arrivalResponseList) {
            int currentCarCount = arrivalResponse.getCarCount();
            if (carCount > 0 && currentCarCount != carCount) {
                return true;
            }
            carCount = currentCarCount;
        }
        return false;
    }

    private static ObjectArrayList<String> wrapLines(String text, float availableWidth) {
        ObjectArrayList<String> lines = new ObjectArrayList<String>();
        String[] textSplit = text.split("\\s");
        String tempText = "";
        for (String textPart : textSplit) {
            String newText = tempText + " " + textPart;
            if (!tempText.isEmpty() && (float)GraphicsHolder.getTextWidth(newText) > availableWidth) {
                lines.add(tempText);
                tempText = textPart;
                continue;
            }
            tempText = newText;
        }
        lines.add(tempText);
        return lines;
    }
}

