/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.data.TransportMode;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.VehicleExtension;
import org.mtr.mod.generated.resource.VehicleResourceSchema;
import org.mtr.mod.render.DynamicVehicleModel;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import org.mtr.mod.resource.CachedResource;
import org.mtr.mod.resource.CustomResourceTools;
import org.mtr.mod.resource.MinecraftModelResource;
import org.mtr.mod.resource.OptimizedModelWrapper;
import org.mtr.mod.resource.PartCondition;
import org.mtr.mod.resource.ResourceProvider;
import org.mtr.mod.resource.VehicleModel;
import org.mtr.mod.resource.VehicleResourceCache;
import org.mtr.mod.resource.VehicleResourceWrapper;
import org.mtr.mod.sound.BveVehicleSound;
import org.mtr.mod.sound.BveVehicleSoundConfig;
import org.mtr.mod.sound.LegacyVehicleSound;
import org.mtr.mod.sound.VehicleSoundBase;

public final class VehicleResource
extends VehicleResourceSchema {
    public final Supplier<VehicleSoundBase> createVehicleSoundBase;
    public final boolean shouldPreload;
    @Nullable
    private final LegacyVehicleSupplier<ObjectArrayList<VehicleModel>> extraModelsSupplier;
    private final Int2ObjectAVLTreeMap<Int2ObjectAVLTreeMap<ObjectArrayList<VehicleModel>>> allModels = new Int2ObjectAVLTreeMap();
    private final Int2ObjectAVLTreeMap<Int2ObjectAVLTreeMap<CachedResource<CachedResource<CachedResource<VehicleResourceCacheHolder>>>>> cachedVehicleResource = new Int2ObjectAVLTreeMap();
    private static final boolean[][] CHRISTMAS_LIGHT_STAGES = new boolean[][]{{true, false, false, false}, {false, true, false, false}, {false, false, true, false}, {false, false, false, true}, {true, false, false, false}, {false, true, false, false}, {false, false, true, false}, {false, false, false, true}, {true, true, false, false}, {false, true, true, false}, {false, false, true, true}, {true, false, false, true}, {true, true, false, false}, {false, true, true, false}, {false, false, true, true}, {true, false, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, true, false}, {false, true, false, true}, {true, false, false, false}, {true, true, false, false}, {true, true, true, false}, {true, true, true, true}, {false, true, false, false}, {false, true, true, false}, {false, true, true, true}, {true, true, true, true}, {false, false, true, false}, {false, false, true, true}, {true, false, true, true}, {true, true, true, true}, {false, false, false, true}, {true, false, false, true}, {true, true, false, true}, {true, true, true, true}, {false, false, false, false}, {true, true, true, true}, {true, true, true, true}, {true, true, true, true}, {false, false, false, false}, {true, true, true, true}, {true, true, true, true}, {true, true, true, true}};

    public VehicleResource(ReaderBase readerBase, @Nullable LegacyVehicleSupplier<ObjectArrayList<VehicleModel>> extraModelsSupplier, ResourceProvider resourceProvider) {
        super(readerBase, resourceProvider);
        this.updateData(readerBase);
        this.extraModelsSupplier = extraModelsSupplier;
        this.createVehicleSoundBase = this.createVehicleSoundBaseInitializer();
        this.shouldPreload = Config.getClient().matchesPreloadResourcePattern(this.id);
        if (this.shouldPreload) {
            this.models.forEach(model -> {
                model.shouldPreload = true;
            });
        }
    }

    public VehicleResource(ReaderBase readerBase, ResourceProvider resourceProvider) {
        this(readerBase, null, resourceProvider);
    }

    VehicleResource(String id, String name, String color, TransportMode transportMode, double length, double width, double bogie1Position, double bogie2Position, double couplingPadding1, double couplingPadding2, String description, String wikipediaArticle, ObjectArrayList<String> tags, ObjectArrayList<VehicleModel> models, ObjectArrayList<VehicleModel> bogie1Models, ObjectArrayList<VehicleModel> bogie2Models, boolean hasGangway1, boolean hasGangway2, boolean hasBarrier1, boolean hasBarrier2, double legacyRiderOffset, String bveSoundBaseResource, String legacySpeedSoundBaseResource, long legacySpeedSoundCount, boolean legacyUseAccelerationSoundsWhenCoasting, boolean legacyConstantPlaybackSpeed, String legacyDoorSoundBaseResource, double legacyDoorCloseSoundTime, ResourceProvider resourceProvider) {
        super(id, name, color, transportMode, length, width, bogie1Position, bogie2Position, couplingPadding1, couplingPadding2, description, wikipediaArticle, hasGangway1, hasGangway2, hasBarrier1, hasBarrier2, legacyRiderOffset, bveSoundBaseResource, legacySpeedSoundBaseResource, legacySpeedSoundCount, legacyUseAccelerationSoundsWhenCoasting, legacyConstantPlaybackSpeed, legacyDoorSoundBaseResource, legacyDoorCloseSoundTime, resourceProvider);
        this.tags.addAll(tags);
        this.models.addAll(models);
        this.bogie1Models.addAll(bogie1Models);
        this.bogie2Models.addAll(bogie2Models);
        this.extraModelsSupplier = null;
        this.createVehicleSoundBase = this.createVehicleSoundBaseInitializer();
        this.shouldPreload = Config.getClient().matchesPreloadResourcePattern(id);
        if (this.shouldPreload) {
            models.forEach(model -> {
                model.shouldPreload = true;
            });
        }
    }

    @Override
    @Nonnull
    protected ResourceProvider modelsResourceProviderParameter() {
        return this.resourceProvider;
    }

    @Override
    @Nonnull
    protected ResourceProvider bogie1ModelsResourceProviderParameter() {
        return this.resourceProvider;
    }

    @Override
    @Nonnull
    protected ResourceProvider bogie2ModelsResourceProviderParameter() {
        return this.resourceProvider;
    }

    @Nullable
    public VehicleResourceCache getCachedVehicleResource(int carNumber, int totalCars, boolean force) {
        VehicleResourceCacheHolder data3;
        CachedResource data2;
        int newCarNumber = this.extraModelsSupplier == null ? 0 : carNumber;
        int newTotalCars = this.extraModelsSupplier == null ? 0 : totalCars;
        CachedResource data1 = (CachedResource)this.cachedVehicleResource.computeIfAbsent(newCarNumber, key -> new Int2ObjectAVLTreeMap()).computeIfAbsent(newTotalCars, key -> this.cachedVehicleResourceInitializer(newCarNumber, newTotalCars, force)).getData(force);
        if (data1 != null && (data2 = (CachedResource)data1.getData(force)) != null && (data3 = (VehicleResourceCacheHolder)data2.getData(force)) != null) {
            Object2ObjectOpenHashMap optimizedModels = (Object2ObjectOpenHashMap)data3.optimizedModels.getData(force);
            Object2ObjectOpenHashMap optimizedModelsDoorsClosed = (Object2ObjectOpenHashMap)data3.optimizedModelsDoorsClosed.getData(force);
            Object2ObjectOpenHashMap optimizedModelsBogie1 = (Object2ObjectOpenHashMap)data3.optimizedModelsBogie1.getData(force);
            Object2ObjectOpenHashMap optimizedModelsBogie2 = (Object2ObjectOpenHashMap)data3.optimizedModelsBogie2.getData(force);
            if (optimizedModels != null && optimizedModelsDoorsClosed != null && optimizedModelsBogie1 != null && optimizedModelsBogie2 != null) {
                return new VehicleResourceCache(data3.floors, data3.doorways, optimizedModels, optimizedModelsDoorsClosed, optimizedModelsBogie1, optimizedModelsBogie2);
            }
        }
        return null;
    }

    public void queue(StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int carNumber, int totalCars, int light, boolean noOpenDoorways) {
        VehicleResourceCache vehicleResourceCache = this.getCachedVehicleResource(carNumber, totalCars, false);
        if (vehicleResourceCache != null) {
            if (noOpenDoorways) {
                VehicleResource.queue(vehicleResourceCache.optimizedModelsDoorsClosed, storedMatrixTransformations, vehicle, light, true);
            } else {
                VehicleResource.queue(vehicleResourceCache.optimizedModels, storedMatrixTransformations, vehicle, light, false);
            }
        }
    }

    public void queueBogie(int bogieIndex, StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int light) {
        VehicleResourceCache vehicleResourceCache = this.getCachedVehicleResource(0, 1, false);
        if (vehicleResourceCache != null && Utilities.isBetween(bogieIndex, 0.0, 1.0)) {
            VehicleResource.queue(bogieIndex == 0 ? vehicleResourceCache.optimizedModelsBogie1 : vehicleResourceCache.optimizedModelsBogie2, storedMatrixTransformations, vehicle, light, true);
        }
    }

    public String getId() {
        return this.id;
    }

    public MutableText getName() {
        return TextHelper.translatable(this.name, new Object[0]);
    }

    public int getColor() {
        return CustomResourceTools.colorStringToInt(this.color);
    }

    public TransportMode getTransportMode() {
        return this.transportMode;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public double getBogie1Position() {
        return this.bogie1Position;
    }

    public double getBogie2Position() {
        return this.bogie2Position;
    }

    public double getCouplingPadding1() {
        return this.couplingPadding1;
    }

    public double getCouplingPadding2() {
        return this.couplingPadding2;
    }

    public MutableText getDescription() {
        return TextHelper.translatable(this.description, new Object[0]);
    }

    public String getWikipediaArticle() {
        return this.wikipediaArticle;
    }

    public void iterateModels(int carNumber, int totalCars, ModelConsumer modelConsumer) {
        VehicleResource.iterateModels(this.getAllModels(carNumber, totalCars), modelConsumer);
    }

    public void iterateBogieModels(int bogieIndex, ModelConsumer modelConsumer) {
        if (Utilities.isBetween(bogieIndex, 0.0, 1.0)) {
            VehicleResource.iterateModels(bogieIndex == 0 ? this.bogie1Models : this.bogie2Models, modelConsumer);
        }
    }

    public VehicleResourceWrapper toVehicleResourceWrapper() {
        int carNumber = this.id.endsWith("trailer") ? 1 : (this.id.endsWith("cab_2") ? 2 : 0);
        int totalCars = this.id.endsWith("cab_3") ? 1 : 3;
        this.getCachedVehicleResource(carNumber, totalCars, true);
        return new VehicleResourceWrapper(this.id, this.name, this.color, this.transportMode, this.length, this.width, this.bogie1Position, this.bogie2Position, this.couplingPadding1, this.couplingPadding2, this.description, this.wikipediaArticle, this.tags, this.getAllModels(carNumber, totalCars).stream().map(VehicleModel::toVehicleModelWrapper).collect(Collectors.toCollection(ObjectArrayList::new)), this.bogie1Models.stream().map(VehicleModel::toVehicleModelWrapper).collect(Collectors.toCollection(ObjectArrayList::new)), this.bogie2Models.stream().map(VehicleModel::toVehicleModelWrapper).collect(Collectors.toCollection(ObjectArrayList::new)), this.hasGangway1, this.hasGangway2, this.hasBarrier1, this.hasBarrier2, this.legacyRiderOffset, this.bveSoundBaseResource, this.legacySpeedSoundBaseResource, this.legacySpeedSoundCount, this.legacyUseAccelerationSoundsWhenCoasting, this.legacyConstantPlaybackSpeed, this.legacyDoorSoundBaseResource, this.legacyDoorCloseSoundTime);
    }

    public void writeMinecraftResource(ObjectArraySet<MinecraftModelResource> minecraftModelResources, ObjectArraySet<String> minecraftTextureResources) {
        this.models.forEach(vehicleModel -> {
            minecraftModelResources.add(vehicleModel.getAsMinecraftResource());
            vehicleModel.addToTextureResource(minecraftTextureResources);
        });
        this.bogie1Models.forEach(vehicleModel -> {
            minecraftModelResources.add(vehicleModel.getAsMinecraftResource());
            vehicleModel.addToTextureResource(minecraftTextureResources);
        });
        this.bogie2Models.forEach(vehicleModel -> {
            minecraftModelResources.add(vehicleModel.getAsMinecraftResource());
            vehicleModel.addToTextureResource(minecraftTextureResources);
        });
    }

    public boolean hasGangway1() {
        return this.hasGangway1;
    }

    public boolean hasGangway2() {
        return this.hasGangway2;
    }

    public boolean hasBarrier1() {
        return this.hasBarrier1;
    }

    public boolean hasBarrier2() {
        return this.hasBarrier2;
    }

    private ObjectArrayList<VehicleModel> getAllModels(int carNumber, int totalCars) {
        if (this.extraModelsSupplier == null) {
            return this.models;
        }
        return this.allModels.getOrDefault(carNumber, new Int2ObjectAVLTreeMap()).getOrDefault(totalCars, new ObjectArrayList());
    }

    public static boolean matchesCondition(VehicleExtension vehicle, PartCondition partCondition, boolean noOpenDoorways) {
        switch (partCondition) {
            case AT_DEPOT: {
                return !vehicle.getIsOnRoute();
            }
            case ON_ROUTE_FORWARDS: {
                return vehicle.getIsOnRoute() && !vehicle.getReversed();
            }
            case ON_ROUTE_BACKWARDS: {
                return vehicle.getIsOnRoute() && vehicle.getReversed();
            }
            case DOORS_CLOSED: {
                return vehicle.persistentVehicleData.getDoorValue() == 0.0 && noOpenDoorways;
            }
            case DOORS_OPENED: {
                return vehicle.persistentVehicleData.getDoorValue() > 0.0 || !noOpenDoorways;
            }
        }
        return VehicleResource.getChristmasLightState(partCondition);
    }

    public void collectTags(Object2ObjectAVLTreeMap<String, Object2ObjectAVLTreeMap<String, ObjectArrayList<String>>> tagMap) {
        this.tags.forEach(tag -> {
            String[] tagSplit = tag.split(":");
            if (tagSplit.length == 2) {
                tagMap.computeIfAbsent(tagSplit[0], key -> new Object2ObjectAVLTreeMap()).computeIfAbsent(tagSplit[1], key -> new ObjectArrayList()).add(this.id);
            }
        });
    }

    private CachedResource<CachedResource<CachedResource<VehicleResourceCacheHolder>>> cachedVehicleResourceInitializer(int carNumber, int totalCars, boolean force) {
        int modelLifespan = this.shouldPreload ? Integer.MAX_VALUE : 60000;
        return new CachedResource<CachedResource<CachedResource<VehicleResourceCacheHolder>>>(() -> {
            ObjectArrayList allModelsList = this.allModels.computeIfAbsent(carNumber, key -> new Int2ObjectAVLTreeMap()).computeIfAbsent(totalCars, key -> new ObjectArrayList());
            allModelsList.clear();
            allModelsList.addAll(this.models);
            if (this.extraModelsSupplier != null) {
                long startMillis = System.currentTimeMillis();
                allModelsList.addAll((ObjectList)this.extraModelsSupplier.apply(carNumber, totalCars));
                long endMillis = System.currentTimeMillis();
                if (endMillis - startMillis >= 100L) {
                    Init.LOGGER.warn("[{}] Model loading took {} ms, which is longer than usual!", (Object)this.id, (Object)(endMillis - startMillis));
                }
            }
            ObjectArrayList modelsToInitialize = new ObjectArrayList();
            modelsToInitialize.addAll(allModelsList);
            modelsToInitialize.addAll(this.bogie1Models);
            modelsToInitialize.addAll(this.bogie2Models);
            return new CachedResource<CachedResource>(() -> {
                for (VehicleModel vehicleModel : modelsToInitialize) {
                    DynamicVehicleModel dynamicVehicleModel2 = vehicleModel.cachedModel.getData(force);
                    if (dynamicVehicleModel2 != null) continue;
                    return null;
                }
                ObjectArrayList<Box> floors = new ObjectArrayList<Box>();
                Object2ObjectOpenHashMap materialGroupsModel = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap materialGroupsModelDoorsClosed = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap materialGroupsBogie1Model = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap materialGroupsBogie2Model = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap objModelsModel = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap objModelsModelDoorsClosed = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap objModelsBogie1Model = new Object2ObjectOpenHashMap();
                Object2ObjectOpenHashMap objModelsBogie2Model = new Object2ObjectOpenHashMap();
                ObjectArrayList<Box> doorways = new ObjectArrayList<Box>();
                VehicleResource.forEachNonNull(allModelsList, dynamicVehicleModel -> dynamicVehicleModel.writeFloorsAndDoorways(floors, doorways, materialGroupsModel, materialGroupsModelDoorsClosed, objModelsModel, objModelsModelDoorsClosed), force);
                if (floors.isEmpty() && doorways.isEmpty()) {
                    Init.LOGGER.info("[{}] No floors or doorways found in vehicle models", (Object)this.id);
                    double x1 = this.width / 2.0 + 0.25;
                    double x2 = this.width / 2.0 + 0.5;
                    double y = 1.0 + this.legacyRiderOffset;
                    double z = this.length / 2.0 - 0.5;
                    floors.add(new Box(-x1, y, -z, x1, y, z));
                    for (double j = -z; j <= z + 0.001; j += 1.0) {
                        doorways.add(new Box(-x1, y, j, -x2, y, j + 1.0));
                        doorways.add(new Box(x1, y, j, x2, y, j + 1.0));
                    }
                }
                VehicleResource.forEachNonNull(allModelsList, dynamicVehicleModel -> dynamicVehicleModel.modelProperties.iterateParts(modelPropertiesPart -> modelPropertiesPart.mapDoors(doorways)), force);
                VehicleResource.forEachNonNull(this.bogie1Models, dynamicVehicleModel -> dynamicVehicleModel.writeFloorsAndDoorways(new ObjectArrayList<Box>(), new ObjectArrayList<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), materialGroupsBogie1Model, new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), objModelsBogie1Model), force);
                VehicleResource.forEachNonNull(this.bogie2Models, dynamicVehicleModel -> dynamicVehicleModel.writeFloorsAndDoorways(new ObjectArrayList<Box>(), new ObjectArrayList<Box>(), new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>>(), materialGroupsBogie2Model, new Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>>(), objModelsBogie2Model), force);
                return new CachedResource<VehicleResourceCacheHolder>(() -> {
                    CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModels = VehicleResource.writeToOptimizedModels(materialGroupsModel, objModelsModel, modelLifespan);
                    CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsDoorsClosed = VehicleResource.writeToOptimizedModels(materialGroupsModelDoorsClosed, objModelsModelDoorsClosed, modelLifespan);
                    CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsBogie1 = VehicleResource.writeToOptimizedModels(materialGroupsBogie1Model, objModelsBogie1Model, modelLifespan);
                    CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsBogie2 = VehicleResource.writeToOptimizedModels(materialGroupsBogie2Model, objModelsBogie2Model, modelLifespan);
                    return new VehicleResourceCacheHolder(new ObjectImmutableList(floors), new ObjectImmutableList(doorways), optimizedModels, optimizedModelsDoorsClosed, optimizedModelsBogie1, optimizedModelsBogie2);
                }, modelLifespan);
            }, modelLifespan);
        }, modelLifespan);
    }

    private Supplier<VehicleSoundBase> createVehicleSoundBaseInitializer() {
        if (this.bveSoundBaseResource.isEmpty()) {
            LegacyVehicleSound legacyVehicleSound = new LegacyVehicleSound(this.legacySpeedSoundBaseResource, (int)this.legacySpeedSoundCount, this.legacyUseAccelerationSoundsWhenCoasting, this.legacyConstantPlaybackSpeed, this.legacyDoorSoundBaseResource, this.legacyDoorCloseSoundTime);
            return () -> legacyVehicleSound;
        }
        BveVehicleSoundConfig bveVehicleSoundConfig = new BveVehicleSoundConfig(this.bveSoundBaseResource);
        return () -> new BveVehicleSound(bveVehicleSoundConfig);
    }

    private static void iterateModels(ObjectArrayList<VehicleModel> models, ModelConsumer modelConsumer) {
        for (int i = 0; i < models.size(); ++i) {
            DynamicVehicleModel dynamicVehicleModel;
            VehicleModel vehicleModel = models.get(i);
            if (vehicleModel == null || (dynamicVehicleModel = vehicleModel.cachedModel.getData(false)) == null) continue;
            modelConsumer.accept(i, dynamicVehicleModel);
        }
    }

    private static boolean getChristmasLightState(PartCondition partCondition) {
        int index;
        switch (partCondition) {
            case CHRISTMAS_LIGHT_RED: {
                index = 0;
                break;
            }
            case CHRISTMAS_LIGHT_YELLOW: {
                index = 1;
                break;
            }
            case CHRISTMAS_LIGHT_GREEN: {
                index = 2;
                break;
            }
            case CHRISTMAS_LIGHT_BLUE: {
                index = 3;
                break;
            }
            default: {
                return true;
            }
        }
        return CHRISTMAS_LIGHT_STAGES[(int)(System.currentTimeMillis() / 500L % (long)CHRISTMAS_LIGHT_STAGES.length)][index];
    }

    private static void queue(Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModels, StoredMatrixTransformations storedMatrixTransformations, VehicleExtension vehicle, int light, boolean noOpenDoorways) {
        optimizedModels.forEach((partCondition, optimizedModel) -> {
            if (VehicleResource.matchesCondition(vehicle, partCondition, noOpenDoorways)) {
                MainRenderer.scheduleRender(QueuedRenderLayer.TEXT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
                    CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.queue((OptimizedModelWrapper)optimizedModel, (GraphicsHolder)graphicsHolder, light);
                    graphicsHolder.pop();
                });
            }
        });
    }

    private static CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> writeToOptimizedModels(Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.MaterialGroupWrapper>> materialGroupsModel, Object2ObjectOpenHashMap<PartCondition, ObjectArrayList<OptimizedModelWrapper.ObjModelWrapper>> objModelsModel, int modelLifespan) {
        return new CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>>(() -> {
            CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.beginReload();
            Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper> optimizedModels = new Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>();
            for (PartCondition partCondition : PartCondition.values()) {
                ObjectArrayList materialGroups = (ObjectArrayList)materialGroupsModel.get((Object)partCondition);
                OptimizedModelWrapper optimizedModel1 = materialGroups == null ? null : OptimizedModelWrapper.fromMaterialGroups(materialGroups);
                ObjectArrayList objModels = (ObjectArrayList)objModelsModel.get((Object)partCondition);
                OptimizedModelWrapper optimizedModel2 = objModels == null ? null : OptimizedModelWrapper.fromObjModels(objModels);
                optimizedModels.put(partCondition, new OptimizedModelWrapper(optimizedModel1, optimizedModel2));
            }
            CustomResourceLoader.OPTIMIZED_RENDERER_WRAPPER.finishReload();
            return optimizedModels;
        }, modelLifespan);
    }

    private static void forEachNonNull(ObjectArrayList<VehicleModel> models, Consumer<DynamicVehicleModel> consumer, boolean force) {
        models.forEach(vehicleModel -> {
            DynamicVehicleModel dynamicVehicleModel = vehicleModel.cachedModel.getData(force);
            if (dynamicVehicleModel != null) {
                consumer.accept(dynamicVehicleModel);
            }
        });
    }

    @FunctionalInterface
    public static interface LegacyVehicleSupplier<T> {
        public T apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface ModelConsumer {
        public void accept(int var1, DynamicVehicleModel var2);
    }

    private static class VehicleResourceCacheHolder {
        private final ObjectImmutableList<Box> floors;
        private final ObjectImmutableList<Box> doorways;
        private final CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModels;
        private final CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsDoorsClosed;
        private final CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsBogie1;
        private final CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsBogie2;

        private VehicleResourceCacheHolder(ObjectImmutableList<Box> floors, ObjectImmutableList<Box> doorways, CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModels, CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsDoorsClosed, CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsBogie1, CachedResource<Object2ObjectOpenHashMap<PartCondition, OptimizedModelWrapper>> optimizedModelsBogie2) {
            this.floors = floors;
            this.doorways = doorways;
            this.optimizedModels = optimizedModels;
            this.optimizedModelsDoorsClosed = optimizedModelsDoorsClosed;
            this.optimizedModelsBogie1 = optimizedModelsBogie1;
            this.optimizedModelsBogie2 = optimizedModelsBogie2;
        }
    }
}

