/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.Collections;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.Widget;
import org.mtr.core.data.Station;
import org.mtr.core.data.StationExit;
import org.mtr.core.operation.UpdateDataRequest;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.screen.DashboardList;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.EditNameColorScreenBase;

public class EditStationScreen
extends EditNameColorScreenBase<Station> {
    private StationExit editingExit;
    private int editingDestinationIndex;
    private int clickDelay;
    private final MutableText stationZoneText = TranslationProvider.GUI_MTR_ZONE.getMutableText(new Object[0]);
    private final MutableText exitParentsText = TranslationProvider.GUI_MTR_EXIT_PARENTS.getMutableText(new Object[0]);
    private final MutableText exitDestinationsText = TranslationProvider.GUI_MTR_EXIT_DESTINATIONS.getMutableText(new Object[0]);
    private final TextFieldWidgetExtension textFieldZone = new TextFieldWidgetExtension(0, 0, 0, 20, 6, TextCase.DEFAULT, "[^-\\d]", null);
    private final TextFieldWidgetExtension textFieldExitParentLetter = new TextFieldWidgetExtension(0, 0, 0, 20, 2, TextCase.UPPER, "[^A-Z]", "A");
    private final TextFieldWidgetExtension textFieldExitParentNumber = new TextFieldWidgetExtension(0, 0, 0, 20, 2, TextCase.DEFAULT, "\\D", "1");
    private final TextFieldWidgetExtension textFieldExitDestination = new TextFieldWidgetExtension(0, 0, 0, 20, 1024, TextCase.DEFAULT, null, null);
    private final ButtonWidgetExtension buttonAddExitParent = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_ADD_EXIT.getMutableText(new Object[0]), button -> this.checkClickDelay(() -> this.changeEditingExit(new StationExit(), -1)));
    private final ButtonWidgetExtension buttonDoneExitParent = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.done", new Object[0]), button -> this.checkClickDelay(this::onDoneExitParent));
    private final ButtonWidgetExtension buttonAddExitDestination = new ButtonWidgetExtension(0, 0, 0, 20, TranslationProvider.GUI_MTR_ADD_EXIT_DESTINATION.getMutableText(new Object[0]), button -> this.checkClickDelay(() -> this.changeEditingExit(this.editingExit, this.editingExit == null ? -1 : this.editingExit.getDestinations().size())));
    private final ButtonWidgetExtension buttonDoneExitDestination = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable("gui.done", new Object[0]), button -> this.checkClickDelay(this::onDoneExitDestination));
    private final DashboardList exitParentList = new DashboardList(null, null, this::onEditExitParent, null, null, this::onDeleteExitParent, null, () -> MinecraftClientData.EXIT_PARENTS_SEARCH, text -> {
        MinecraftClientData.EXIT_PARENTS_SEARCH = text;
    });
    private final DashboardList exitDestinationList = new DashboardList(null, null, this::onEditExitDestination, this::onSortExitDestination, null, this::onDeleteExitDestination, this::getExitDestinationList, () -> MinecraftClientData.EXIT_DESTINATIONS_SEARCH, text -> {
        MinecraftClientData.EXIT_DESTINATIONS_SEARCH = text;
    });
    private static final int EXIT_PANELS_START = 70;

    public EditStationScreen(Station station, ScreenExtension previousScreenExtension) {
        super(station, TranslationProvider.GUI_MTR_STATION_NAME, TranslationProvider.GUI_MTR_STATION_COLOR, previousScreenExtension);
    }

    @Override
    protected void init2() {
        this.setPositionsAndInit(0, this.field_230708_k_ / 2, this.field_230708_k_ / 4 * 3);
        IDrawing.setPositionAndWidth(this.textFieldZone, this.field_230708_k_ / 4 * 3 + 2, 22, this.field_230708_k_ / 4 - 4);
        int yExitText = this.field_230709_l_ - 40 - 2;
        IDrawing.setPositionAndWidth(this.textFieldExitParentLetter, 2, yExitText, this.field_230708_k_ / 4 - 4);
        IDrawing.setPositionAndWidth(this.textFieldExitParentNumber, 2 + this.field_230708_k_ / 4, yExitText, this.field_230708_k_ / 4 - 4);
        IDrawing.setPositionAndWidth(this.textFieldExitDestination, this.field_230708_k_ / 2 + 2, yExitText, this.field_230708_k_ / 2 - 4);
        IDrawing.setPositionAndWidth(this.buttonAddExitParent, 0, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        IDrawing.setPositionAndWidth(this.buttonDoneExitParent, 0, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        IDrawing.setPositionAndWidth(this.buttonAddExitDestination, this.field_230708_k_ / 2, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        IDrawing.setPositionAndWidth(this.buttonDoneExitDestination, this.field_230708_k_ / 2, this.field_230709_l_ - 20, this.field_230708_k_ / 2);
        this.textFieldZone.setText2(String.valueOf(((Station)this.data).getZone1()));
        this.exitParentList.x = 0;
        this.exitParentList.y = 70;
        this.exitParentList.height = this.field_230709_l_ - 70 - 20;
        this.exitParentList.width = this.field_230708_k_ / 2;
        this.exitDestinationList.x = this.field_230708_k_ / 2;
        this.exitDestinationList.y = 70;
        this.exitDestinationList.height = this.field_230709_l_ - 70 - 20;
        this.exitDestinationList.width = this.field_230708_k_ / 2;
        this.exitParentList.init(this::addChild);
        this.exitDestinationList.init(this::addChild);
        this.addChild(new ClickableWidget((Widget)this.textFieldZone));
        this.addChild(new ClickableWidget((Widget)this.textFieldExitParentLetter));
        this.addChild(new ClickableWidget((Widget)this.textFieldExitParentNumber));
        this.addChild(new ClickableWidget((Widget)this.textFieldExitDestination));
        this.addChild(new ClickableWidget((Widget)this.buttonAddExitParent));
        this.addChild(new ClickableWidget((Widget)this.buttonDoneExitParent));
        this.addChild(new ClickableWidget((Widget)this.buttonAddExitDestination));
        this.addChild(new ClickableWidget((Widget)this.buttonDoneExitDestination));
        this.changeEditingExit(null, -1);
    }

    @Override
    public void tick2() {
        super.tick2();
        if (this.clickDelay > 0) {
            --this.clickDelay;
        }
        this.textFieldZone.tick2();
        this.textFieldExitParentLetter.tick2();
        this.textFieldExitParentNumber.tick2();
        this.textFieldExitDestination.tick2();
        this.exitParentList.tick();
        this.exitDestinationList.tick();
        this.exitParentList.setData(EditStationScreen.getExitsForDashboardList(EditStationScreen.getStationExits((Station)this.data, false)), false, false, true, false, false, true);
        ObjectArrayList exitDestinations = this.parentExists() ? this.editingExit.getDestinations().stream().map(value -> new DashboardListItem(0L, (String)value, 0)).collect(Collectors.toCollection(ObjectArrayList::new)) : new ObjectArrayList();
        this.exitDestinationList.setData(exitDestinations, false, false, true, true, false, true);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            this.renderBackground(graphicsHolder);
            this.renderTextFields(graphicsHolder);
            GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
            guiDrawing.beginDrawingRectangle();
            guiDrawing.drawRectangle((float)this.field_230708_k_ / 2.0f, 50.0, (float)this.field_230708_k_ / 2.0f + 1.0f, this.field_230709_l_, Integer.MAX_VALUE);
            guiDrawing.finishDrawingRectangle();
            this.exitParentList.render(graphicsHolder);
            this.exitDestinationList.render(graphicsHolder);
            graphicsHolder.drawCenteredText(this.stationZoneText, this.field_230708_k_ / 8 * 7, 6, -1);
            graphicsHolder.drawCenteredText(this.exitParentsText, this.field_230708_k_ / 4, 56, -1);
            if (this.parentExists()) {
                graphicsHolder.drawCenteredText(this.exitDestinationsText, 3 * this.field_230708_k_ / 4, 56, -1);
            }
            super.render(graphicsHolder, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public void mouseMoved2(double mouseX, double mouseY) {
        this.exitParentList.mouseMoved(mouseX, mouseY);
        this.exitDestinationList.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.exitParentList.mouseScrolled(mouseX, mouseY, amount);
        this.exitDestinationList.mouseScrolled(mouseX, mouseY, amount);
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    protected void saveData() {
        super.saveData();
        try {
            ((Station)this.data).setZone1(Integer.parseInt(this.textFieldZone.getText2()));
        }
        catch (Exception ignored) {
            ((Station)this.data).setZone1(0L);
        }
        ObjectArrayList<StationExit> exitsToRemove = new ObjectArrayList<StationExit>();
        ObjectOpenHashSet visitedExits = new ObjectOpenHashSet();
        ((Station)this.data).getExits().forEach(exit -> {
            if (visitedExits.contains(exit.getName())) {
                exitsToRemove.add((StationExit)exit);
            } else {
                visitedExits.add(exit.getName());
            }
        });
        exitsToRemove.forEach(((Station)this.data).getExits()::remove);
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateData(new UpdateDataRequest(MinecraftClientData.getDashboardInstance()).addStation((Station)this.data)));
    }

    private void changeEditingExit(@Nullable StationExit editingExit, int editingDestinationIndex) {
        this.editingExit = editingExit;
        int n = this.editingDestinationIndex = this.parentExists() ? editingDestinationIndex : -1;
        if (editingExit != null) {
            this.textFieldExitParentLetter.setText2(editingExit.getName().toUpperCase(Locale.ENGLISH).replaceAll("[^A-Z]", ""));
            this.textFieldExitParentNumber.setText2(editingExit.getName().replaceAll("\\D", ""));
        }
        if (editingExit != null && editingDestinationIndex >= 0 && editingDestinationIndex < editingExit.getDestinations().size()) {
            this.textFieldExitDestination.setText2(editingExit.getDestinations().get(editingDestinationIndex));
        } else {
            this.textFieldExitDestination.setText2("");
        }
        this.textFieldExitParentLetter.field_230694_p_ = editingExit != null;
        this.textFieldExitParentNumber.field_230694_p_ = editingExit != null;
        this.textFieldExitDestination.field_230694_p_ = editingDestinationIndex >= 0;
        this.buttonAddExitParent.field_230694_p_ = editingExit == null;
        this.buttonDoneExitParent.field_230694_p_ = editingExit != null;
        this.buttonAddExitDestination.field_230694_p_ = this.parentExists() && editingDestinationIndex < 0;
        this.buttonDoneExitDestination.field_230694_p_ = editingDestinationIndex >= 0;
        this.exitDestinationList.x = this.parentExists() ? this.field_230708_k_ / 2 : this.field_230708_k_;
        this.exitParentList.height = this.field_230709_l_ - 70 - (editingExit == null ? 20 : 44);
        this.exitDestinationList.height = this.field_230709_l_ - 70 - (editingDestinationIndex >= 0 ? 44 : 20);
    }

    private void onDoneExitParent() {
        String parentLetter = this.textFieldExitParentLetter.getText2();
        String parentNumber = this.textFieldExitParentNumber.getText2();
        if (!parentLetter.isEmpty() && !parentNumber.isEmpty() && this.parentExists()) {
            try {
                String exitName = parentLetter + Integer.parseInt(parentNumber);
                this.editingExit.setName(exitName);
                if (!((Station)this.data).getExits().contains(this.editingExit)) {
                    StationExit overlappingExit = this.getStationExit(exitName);
                    if (overlappingExit == null) {
                        ((Station)this.data).getExits().add(this.editingExit);
                    } else {
                        overlappingExit.getDestinations().addAll((ObjectList<String>)this.editingExit.getDestinations());
                    }
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
        this.changeEditingExit(null, -1);
    }

    private void onDoneExitDestination() {
        String destination = this.textFieldExitDestination.getText2();
        if (this.parentExists() && this.editingDestinationIndex >= 0 && !destination.isEmpty()) {
            ObjectArrayList<String> destinations = this.editingExit.getDestinations();
            if (this.editingDestinationIndex < destinations.size()) {
                destinations.set(this.editingDestinationIndex, destination);
            } else {
                destinations.add(destination);
            }
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onEditExitParent(DashboardListItem dashboardListItem, int index) {
        this.changeEditingExit(this.getStationExit(EditStationScreen.formatExitName(dashboardListItem.getName(true))), -1);
    }

    private void onDeleteExitParent(DashboardListItem dashboardListItem, int index) {
        ((Station)this.data).getExits().remove(index);
        this.changeEditingExit(null, -1);
    }

    private void onEditExitDestination(DashboardListItem dashboardListItem, int index) {
        this.changeEditingExit(this.editingExit, index);
    }

    private void onSortExitDestination() {
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onDeleteExitDestination(DashboardListItem dashboardListItem, int index) {
        if (this.parentExists()) {
            this.editingExit.getDestinations().remove(dashboardListItem.getName(true));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private ObjectArrayList<String> getExitDestinationList() {
        return this.parentExists() ? this.editingExit.getDestinations() : new ObjectArrayList<String>();
    }

    private void checkClickDelay(Runnable callback) {
        if (this.clickDelay == 0) {
            callback.run();
            this.clickDelay = 10;
        }
    }

    private boolean parentExists() {
        return this.editingExit != null;
    }

    @Nullable
    private StationExit getStationExit(String exitName) {
        for (StationExit exit : ((Station)this.data).getExits()) {
            if (!exit.getName().equals(exitName)) continue;
            return exit;
        }
        return null;
    }

    public static ObjectArrayList<StationExit> getStationExits(Station station, boolean addExitParents) {
        ObjectArrayList<StationExit> newExits = new ObjectArrayList<StationExit>();
        ObjectArrayList<StationExit> exits = station.getExits();
        Object2ObjectOpenHashMap addedParentExits = new Object2ObjectOpenHashMap();
        Collections.sort(exits);
        exits.forEach(exit -> {
            if (addExitParents) {
                StationExit parentExit;
                String parentExitName = exit.getName().substring(0, 1);
                if (!addedParentExits.containsKey(parentExitName)) {
                    StationExit newExit = new StationExit();
                    newExit.setName(parentExitName);
                    newExits.add(newExit);
                    addedParentExits.put(parentExitName, newExit);
                }
                if ((parentExit = (StationExit)addedParentExits.get(parentExitName)) != null && parentExit != exit) {
                    parentExit.getDestinations().addAll((ObjectList<String>)exit.getDestinations());
                }
            }
            newExits.add((StationExit)exit);
        });
        return newExits;
    }

    public static ObjectArrayList<DashboardListItem> getExitsForDashboardList(ObjectArrayList<StationExit> exits) {
        return exits.stream().map(stationExit -> {
            ObjectArrayList<String> destinations = stationExit.getDestinations();
            String additional = destinations.size() > 1 ? String.format("|(+%s)", destinations.size() - 1) : "";
            return new DashboardListItem(EditStationScreen.serializeExit(stationExit.getName()), String.format("%s%s", stationExit.getName(), destinations.isEmpty() ? "" : String.format("|%s%s", destinations.get(0), additional)), 0);
        }).collect(Collectors.toCollection(ObjectArrayList::new));
    }

    public static String deserializeExit(long code) {
        StringBuilder exit = new StringBuilder();
        for (long charCodes = code; charCodes > 0L; charCodes >>= 8) {
            exit.insert(0, (char)(charCodes & 0xFFL));
        }
        return exit.toString();
    }

    private static long serializeExit(String exitName) {
        char[] characters = exitName.toCharArray();
        long code = 0L;
        for (char character : characters) {
            code <<= 8;
            code += (long)character;
        }
        return code;
    }

    private static String formatExitName(String text) {
        return text.split("\\|")[0];
    }
}

