/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.world.World;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.operation.PressLift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.packet.PacketPressLiftButton;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.screen.DashboardList;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.MTRScreenBase;

public class LiftSelectionScreen
extends MTRScreenBase
implements IGui {
    private final DashboardList selectionList;
    private final ObjectArrayList<BlockPos> floorLevels = new ObjectArrayList();
    private final ObjectArrayList<String> floorDescriptions = new ObjectArrayList();
    private final long liftId;

    public LiftSelectionScreen(long liftId) {
        this.liftId = liftId;
        Lift lift = MinecraftClientData.getLift(liftId);
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (lift != null && clientWorld != null) {
            lift.iterateFloors(floor -> {
                BlockPos blockPos = Init.positionToBlockPos(floor.getPosition());
                this.floorLevels.add(blockPos);
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = RenderLifts.getLiftDetails(new org.mtr.mapping.holder.World((World)clientWorld.data), lift, blockPos);
                this.floorDescriptions.add(String.format("%s %s", liftDetails.right().left(), IGui.formatStationName(String.join((CharSequence)"|", liftDetails.right().right()))));
            });
        }
        this.selectionList = new DashboardList(this::onPress, null, null, null, null, null, null, () -> "", text -> {});
    }

    @Override
    protected void init2() {
        super.init2();
        this.selectionList.x = this.field_230708_k_ / 2 - 144;
        this.selectionList.y = 20;
        this.selectionList.width = 288;
        this.selectionList.height = this.field_230709_l_ - 40;
        this.selectionList.init(this::addChild);
    }

    @Override
    public void tick2() {
        Lift lift = MinecraftClientData.getLift(this.liftId);
        if (lift == null) {
            this.onClose2();
        } else {
            this.selectionList.tick();
            ObjectArrayList<DashboardListItem> list = new ObjectArrayList<DashboardListItem>();
            for (int i = this.floorLevels.size() - 1; i >= 0; --i) {
                BlockPos blockPos = this.floorLevels.get(i);
                list.add(new DashboardListItem(blockPos.asLong(), this.floorDescriptions.get(i), lift.hasInstruction(lift.getFloorIndex(Init.blockPosToPosition(blockPos))).contains((Object)LiftDirection.NONE) ? -65536 : -16777216));
            }
            this.selectionList.setData(list, true, false, false, false, false, false);
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        this.selectionList.render(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    @Override
    public void mouseMoved2(double mouseX, double mouseY) {
        this.selectionList.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.selectionList.mouseScrolled(mouseX, mouseY, amount);
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    private void onPress(DashboardListItem dashboardListItem, int index) {
        PressLift pressLift = new PressLift();
        pressLift.add(Init.blockPosToPosition(this.floorLevels.get(this.floorLevels.size() - index - 1)), LiftDirection.NONE);
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketPressLiftButton(pressLift));
        this.onClose2();
    }
}

