/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.widget.Widget;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateLiftTrackFloorConfig;
import org.mtr.mod.screen.MTRScreenBase;

public class LiftTrackFloorScreen
extends MTRScreenBase
implements IGui {
    private final TextFieldWidgetExtension textFieldFloorNumber;
    private final TextFieldWidgetExtension textFieldFloorDescription;
    private final CheckboxWidgetExtension checkboxShouldDing;
    private final BlockPos blockPos;
    private final String initialFloorNumber;
    private final String initialFloorDescription;
    private final boolean initialShouldDing;
    private final int textWidth;
    private static final MutableText TEXT_FLOOR_NUMBER = TranslationProvider.GUI_MTR_LIFT_FLOOR_NUMBER.getMutableText(new Object[0]);
    private static final MutableText TEXT_FLOOR_DESCRIPTION = TranslationProvider.GUI_MTR_LIFT_FLOOR_DESCRIPTION.getMutableText(new Object[0]);
    private static final int TEXT_FIELD_WIDTH = 240;

    public LiftTrackFloorScreen(BlockPos blockPos, BlockLiftTrackFloor.BlockEntity blockEntity) {
        this.blockPos = blockPos;
        this.textFieldFloorNumber = new TextFieldWidgetExtension(0, 0, 0, 20, 8, TextCase.DEFAULT, null, "1");
        this.textFieldFloorDescription = new TextFieldWidgetExtension(0, 0, 0, 20, 256, TextCase.DEFAULT, null, "Concourse");
        this.checkboxShouldDing = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> {});
        this.checkboxShouldDing.setMessage2(TranslationProvider.GUI_MTR_LIFT_SHOULD_DING.getText(new Object[0]));
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            this.initialFloorNumber = "1";
            this.initialFloorDescription = "";
            this.initialShouldDing = false;
        } else {
            this.initialFloorNumber = blockEntity.getFloorNumber();
            this.initialFloorDescription = blockEntity.getFloorDescription();
            this.initialShouldDing = blockEntity.getShouldDing();
        }
        this.textWidth = Math.max(GraphicsHolder.getTextWidth(TEXT_FLOOR_NUMBER), GraphicsHolder.getTextWidth(TEXT_FLOOR_DESCRIPTION));
    }

    @Override
    protected void init2() {
        super.init2();
        int startX = (this.field_230708_k_ - this.textWidth - 6 - 240) / 2;
        int startY = (this.field_230709_l_ - 60 - 8) / 2;
        IDrawing.setPositionAndWidth(this.textFieldFloorNumber, startX + this.textWidth + 6 + 2, startY + 2, 236);
        IDrawing.setPositionAndWidth(this.textFieldFloorDescription, startX + this.textWidth + 6 + 2, startY + 20 + 6, 236);
        IDrawing.setPositionAndWidth(this.checkboxShouldDing, startX, startY + 40 + 8, 240);
        this.textFieldFloorNumber.setText2(this.initialFloorNumber);
        this.textFieldFloorDescription.setText2(this.initialFloorDescription);
        this.checkboxShouldDing.setChecked(this.initialShouldDing);
        this.addChild(new ClickableWidget((Widget)this.textFieldFloorNumber));
        this.addChild(new ClickableWidget((Widget)this.textFieldFloorDescription));
    }

    @Override
    public void tick2() {
        this.textFieldFloorNumber.tick2();
        this.textFieldFloorDescription.tick2();
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        int startX = (this.field_230708_k_ - this.textWidth - 6 - 240) / 2;
        int startY = (this.field_230709_l_ - 60 - 8) / 2;
        graphicsHolder.drawText(TEXT_FLOOR_NUMBER, startX, startY + 2 + 6, -1, false, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TEXT_FLOOR_DESCRIPTION, startX, startY + 20 + 6 + 6, -1, false, GraphicsHolder.getDefaultLight());
        super.render(graphicsHolder, mouseX, mouseY, delta);
    }

    @Override
    public void onClose2() {
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateLiftTrackFloorConfig(this.blockPos, this.textFieldFloorNumber.getText2(), this.textFieldFloorDescription.getText2(), this.checkboxShouldDing.isChecked2()));
        super.onClose2();
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }
}

