/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import net.minecraft.client.gui.widget.Widget;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.NameColorDataBase;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.data.TransportMode;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.Init;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.screen.MTRScreenBase;
import org.mtr.mod.screen.WidgetShorterSlider;

public abstract class SavedRailScreenBase<T extends SavedRailBase<T, U>, U extends AreaBase<U, T>>
extends MTRScreenBase
implements IGui {
    protected final T savedRailBase;
    protected final int textWidth;
    protected final boolean showScheduleControls;
    protected final WidgetShorterSlider sliderDwellTimeMin;
    protected final WidgetShorterSlider sliderDwellTimeSec;
    private final TextFieldWidgetExtension textFieldSavedRailNumber;
    private final MutableText savedRailNumberText;
    protected static final int SECONDS_PER_MINUTE = 60;
    private static final int MAX_DWELL_TIME = 1200;
    private static final int MAX_SAVED_RAIL_NUMBER_LENGTH = 10;

    public SavedRailScreenBase(T savedRailBase, TransportMode transportMode, ScreenExtension previousScreenExtension, MutableText ... additionalTexts) {
        super(previousScreenExtension);
        this.savedRailBase = savedRailBase;
        this.showScheduleControls = !transportMode.continuousMovement;
        this.savedRailNumberText = this.getNumberStringKey().getMutableText(new Object[0]);
        this.textFieldSavedRailNumber = new TextFieldWidgetExtension(0, 0, 0, 20, 10, TextCase.DEFAULT, null, "1");
        int additionalTextWidths = 0;
        for (MutableText additionalText : additionalTexts) {
            additionalTextWidths = Math.max(additionalTextWidths, GraphicsHolder.getTextWidth(additionalText));
        }
        this.textWidth = Math.max(GraphicsHolder.getTextWidth(this.savedRailNumberText), additionalTextWidths) + 6;
        this.sliderDwellTimeMin = new WidgetShorterSlider(0, 0, (int)Math.floor(10.0), xva$0 -> TranslationProvider.GUI_MTR_ARRIVAL_MIN.getString(xva$0), null);
        this.sliderDwellTimeSec = new WidgetShorterSlider(0, 0, 119, 10, 2, value -> TranslationProvider.GUI_MTR_ARRIVAL_SEC.getString(Float.valueOf((float)value / 2.0f)), null);
    }

    @Override
    protected void init2() {
        super.init2();
        IDrawing.setPositionAndWidth(this.textFieldSavedRailNumber, 20 + this.textWidth + 2, 22, this.field_230708_k_ - this.textWidth - 40 - 4);
        this.textFieldSavedRailNumber.setText2(((NameColorDataBase)this.savedRailBase).getName());
        this.textFieldSavedRailNumber.setChangedListener2(text -> ((NameColorDataBase)this.savedRailBase).setName(this.textFieldSavedRailNumber.getText2()));
        int sliderTextWidth = Math.max(GraphicsHolder.getTextWidth(TranslationProvider.GUI_MTR_ARRIVAL_MIN.getMutableText("88")), GraphicsHolder.getTextWidth(TranslationProvider.GUI_MTR_ARRIVAL_SEC.getString("88.8"))) + 6;
        this.sliderDwellTimeMin.setX2(20 + this.textWidth);
        this.sliderDwellTimeMin.setHeight(10);
        this.sliderDwellTimeMin.setWidth2(this.field_230708_k_ - this.textWidth - 40 - sliderTextWidth);
        this.sliderDwellTimeSec.setX2(20 + this.textWidth);
        this.sliderDwellTimeSec.setHeight(10);
        this.sliderDwellTimeSec.setWidth2(this.field_230708_k_ - this.textWidth - 40 - sliderTextWidth);
        this.addChild(new ClickableWidget((Widget)this.textFieldSavedRailNumber));
        if (this.showScheduleControls) {
            this.addChild(new ClickableWidget((Widget)this.sliderDwellTimeMin));
            this.addChild(new ClickableWidget((Widget)this.sliderDwellTimeSec));
        }
    }

    @Override
    public void tick2() {
        this.textFieldSavedRailNumber.tick2();
        this.textFieldSavedRailNumber.setX2(20 + this.textWidth + 2);
        int maxMin = (int)Math.floor(10.0);
        if (this.sliderDwellTimeMin.getIntValue() == 0 && this.sliderDwellTimeSec.getIntValue() == 0) {
            this.sliderDwellTimeSec.setValue(1);
        }
        if (this.sliderDwellTimeMin.getIntValue() == maxMin && this.sliderDwellTimeSec.getIntValue() > 0) {
            this.sliderDwellTimeSec.setValue(0);
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            this.renderBackground(graphicsHolder);
            graphicsHolder.drawText(this.savedRailNumberText, 20, 28, -1, false, GraphicsHolder.getDefaultLight());
            super.render(graphicsHolder, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    protected abstract TranslationProvider.TranslationHolder getNumberStringKey();
}

