/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.stream.Collectors;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import org.mtr.core.data.Route;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.packet.PacketUpdateTrainSensorConfig;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;
import org.mtr.mod.screen.MTRScreenBase;

public abstract class TrainSensorScreenBase
extends MTRScreenBase
implements IGui {
    private boolean stoppedOnly;
    private boolean movingOnly;
    protected final BlockPos blockPos;
    protected final TextFieldWidgetExtension[] textFields;
    private final LongAVLTreeSet filterRouteIds;
    private final int textFieldCount;
    private final MutableText[] textFieldLabels;
    private final CheckboxWidgetExtension stoppedOnlyCheckbox;
    private final CheckboxWidgetExtension movingOnlyCheckbox;
    private final ButtonWidgetExtension filterButton;
    private final boolean hasSpeedCheckboxes;
    private final int yStart;

    @SafeVarargs
    public TrainSensorScreenBase(BlockPos blockPos, boolean hasSpeedCheckboxes, ObjectObjectImmutablePair<TextFieldWidgetExtension, MutableText> ... textFieldsAndLabels) {
        this.blockPos = blockPos;
        this.textFieldCount = textFieldsAndLabels.length;
        this.textFields = new TextFieldWidgetExtension[this.textFieldCount];
        this.textFieldLabels = new MutableText[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            this.textFields[i] = textFieldsAndLabels[i].left();
            this.textFieldLabels[i] = textFieldsAndLabels[i].right();
        }
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            this.filterRouteIds = new LongAVLTreeSet();
        } else {
            BlockEntity blockEntity = clientWorld.getBlockEntity(blockPos);
            if (blockEntity != null && blockEntity.data instanceof BlockTrainSensorBase.BlockEntityBase) {
                this.filterRouteIds = ((BlockTrainSensorBase.BlockEntityBase)((Object)blockEntity.data)).getRouteIds();
                this.stoppedOnly = ((BlockTrainSensorBase.BlockEntityBase)((Object)blockEntity.data)).getStoppedOnly();
                this.movingOnly = ((BlockTrainSensorBase.BlockEntityBase)((Object)blockEntity.data)).getMovingOnly();
            } else {
                this.filterRouteIds = new LongAVLTreeSet();
            }
        }
        this.stoppedOnlyCheckbox = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> this.setChecked((boolean)checked, this.movingOnly));
        this.stoppedOnlyCheckbox.setMessage2(TranslationProvider.GUI_MTR_STOPPED_ONLY.getText(new Object[0]));
        this.movingOnlyCheckbox = new CheckboxWidgetExtension(0, 0, 0, 20, true, checked -> this.setChecked(this.stoppedOnly, (boolean)checked));
        this.movingOnlyCheckbox.setMessage2(TranslationProvider.GUI_MTR_MOVING_ONLY.getText(new Object[0]));
        this.filterButton = new ButtonWidgetExtension(0, 0, 0, 20, button -> {
            ObjectArrayList routes = MinecraftClientData.getInstance().simplifiedRoutes.stream().map(simplifiedRoute -> new DashboardListItem(simplifiedRoute.getId(), simplifiedRoute.getName(), simplifiedRoute.getColor())).sorted().collect(Collectors.toCollection(ObjectArrayList::new));
            MinecraftClient.getInstance().openScreen(new Screen(new DashboardListSelectorScreen(new ObjectImmutableList<DashboardListItem>(routes), this.filterRouteIds, false, false, this)));
        });
        this.hasSpeedCheckboxes = hasSpeedCheckboxes;
        this.yStart = (this.textFieldCount == 0 ? 20 : 84) + (hasSpeedCheckboxes ? 40 : 0);
    }

    @Override
    protected void init2() {
        super.init2();
        int textFieldWidth = this.textFieldCount == 0 ? 0 : (this.field_230708_k_ - 40) / this.textFieldCount;
        for (int i = 0; i < this.textFieldCount; ++i) {
            IDrawing.setPositionAndWidth(this.textFields[i], 22 + textFieldWidth * i, 36, textFieldWidth - 4);
            this.addChild(new ClickableWidget((Widget)this.textFields[i]));
        }
        if (this.hasSpeedCheckboxes) {
            IDrawing.setPositionAndWidth(this.stoppedOnlyCheckbox, 20, this.yStart - 40, 144);
            IDrawing.setPositionAndWidth(this.movingOnlyCheckbox, 20, this.yStart - 20, 144);
            this.addChild(new ClickableWidget((Widget)this.stoppedOnlyCheckbox));
            this.addChild(new ClickableWidget((Widget)this.movingOnlyCheckbox));
            this.setChecked(this.stoppedOnly, this.movingOnly);
        }
        IDrawing.setPositionAndWidth(this.filterButton, 20, this.yStart + 40, 72);
        this.filterButton.setMessage2(new Text((ITextComponent)TextHelper.translatable((String)"selectWorld.edit", (Object[])new Object[0]).data));
        this.addChild(new ClickableWidget((Widget)this.filterButton));
    }

    @Override
    public void tick2() {
        for (TextFieldWidgetExtension textField : this.textFields) {
            textField.tick2();
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        try {
            int i;
            this.renderBackground(graphicsHolder);
            for (i = 0; i < this.textFieldCount; ++i) {
                graphicsHolder.drawText(this.textFieldLabels[i], 20 + (this.field_230708_k_ - 40) / this.textFieldLabels.length * i, 20, -1, false, GraphicsHolder.getDefaultLight());
            }
            graphicsHolder.drawText(TranslationProvider.GUI_MTR_FILTERED_ROUTES.getMutableText(this.filterRouteIds.size()), 20, this.yStart + 6, -1, false, GraphicsHolder.getDefaultLight());
            graphicsHolder.drawText((this.filterRouteIds.isEmpty() ? TranslationProvider.GUI_MTR_FILTERED_ROUTES_EMPTY : TranslationProvider.GUI_MTR_FILTERED_ROUTES_CONDITION).getMutableText(new Object[0]), 20, this.yStart + 20 + 6, -1, false, GraphicsHolder.getDefaultLight());
            i = 0;
            LongBidirectionalIterator longBidirectionalIterator = this.filterRouteIds.iterator();
            while (longBidirectionalIterator.hasNext()) {
                long routeId = (Long)longBidirectionalIterator.next();
                Route route = (Route)MinecraftClientData.getInstance().routeIdMap.get(routeId);
                if (route != null) {
                    graphicsHolder.drawText(TextHelper.literal(IGui.formatStationName(route.getName())), 20, this.yStart + 60 + 6 + i, -1, false, GraphicsHolder.getDefaultLight());
                }
                i += 8;
            }
            this.renderAdditional(graphicsHolder);
            super.render(graphicsHolder, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public void onClose2() {
        this.sendUpdate(this.blockPos, this.filterRouteIds, this.stoppedOnly, this.movingOnly);
        super.onClose2();
    }

    @Override
    public boolean isPauseScreen2() {
        return false;
    }

    protected void renderAdditional(GraphicsHolder graphicsHolder) {
    }

    protected void sendUpdate(BlockPos blockPos, LongAVLTreeSet filterRouteIds, boolean stoppedOnly, boolean movingOnly) {
        InitClient.REGISTRY_CLIENT.sendPacketToServer(new PacketUpdateTrainSensorConfig(blockPos, filterRouteIds, stoppedOnly, movingOnly));
    }

    private void setChecked(boolean newStoppedOnly, boolean newMovingOnly) {
        this.stoppedOnly = newMovingOnly && this.stoppedOnly ? false : newStoppedOnly;
        this.movingOnly = newStoppedOnly && this.movingOnly ? false : newMovingOnly;
        this.stoppedOnlyCheckbox.setChecked(this.stoppedOnly);
        this.movingOnlyCheckbox.setChecked(this.movingOnly);
    }
}

