/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.screen;

import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.SliderWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.data.IGui;

public class WidgetShorterSlider
extends SliderWidgetExtension
implements IGui {
    private final int maxValue;
    private final int markerFrequency;
    private final int markerDisplayedRatio;
    private final IntFunction<String> setMessage;
    private final IntConsumer shiftClickAction;
    private static final int SLIDER_WIDTH = 6;
    private static final int TICK_HEIGHT = 10;

    public WidgetShorterSlider(int x, int width, int maxValue, int markerFrequency, int markerDisplayedRatio, IntFunction<String> setMessage, @Nullable IntConsumer shiftClickAction) {
        super(x, 0, width, 0);
        this.maxValue = Math.max(maxValue, 1);
        this.setMessage = setMessage;
        this.shiftClickAction = shiftClickAction;
        this.markerFrequency = markerFrequency;
        this.markerDisplayedRatio = markerDisplayedRatio;
    }

    public WidgetShorterSlider(int x, int width, int maxValue, IntFunction<String> setMessage, @Nullable IntConsumer shiftClickAction) {
        this(x, width, maxValue, 0, 0, setMessage, shiftClickAction);
    }

    @Override
    public void onClick2(double d, double e) {
        super.onClick2(d, e);
        this.checkShiftClick();
    }

    @Override
    public void setWidth2(int width) {
        super.setWidth2(Math.min(width, 380));
    }

    @Override
    protected void updateMessage2() {
        this.setMessage2(new Text((ITextComponent)TextHelper.literal((String)this.setMessage.apply((int)this.getIntValue())).data));
    }

    @Override
    protected void onDrag2(double d, double e, double f, double g) {
        super.onDrag2(d, e, f, g);
        this.checkShiftClick();
    }

    @Override
    protected void applyValue2() {
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        boolean isHovered = this.func_230449_g_();
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingTexture(new Identifier(String.format("textures/gui/sprites/widget/slider%s.png", isHovered ? "_highlighted" : "")));
        IGui.drawTexture(guiDrawing, this.getX2(), this.getY2(), 0.0f, 0.0f, this.field_230688_j_ / 2, this.field_230689_k_ / 2, 200, 20);
        IGui.drawTexture(guiDrawing, this.getX2(), this.getY2() + this.field_230689_k_ / 2, 0.0f, 20.0f - (float)this.field_230689_k_ / 2.0f, this.field_230688_j_ / 2, this.field_230689_k_ / 2, 200, 20);
        IGui.drawTexture(guiDrawing, this.getX2() + this.field_230688_j_ / 2, this.getY2(), 200.0f - (float)this.field_230688_j_ / 2.0f, 0.0f, this.field_230688_j_ / 2, this.field_230689_k_ / 2, 200, 20);
        IGui.drawTexture(guiDrawing, this.getX2() + this.field_230688_j_ / 2, this.getY2() + this.field_230689_k_ / 2, 200.0f - (float)this.field_230688_j_ / 2.0f, 20.0f - (float)this.field_230689_k_ / 2.0f, this.field_230688_j_ / 2, this.field_230689_k_ / 2, 200, 20);
        guiDrawing.finishDrawingTexture();
        guiDrawing.beginDrawingTexture(new Identifier(String.format("textures/gui/sprites/widget/slider_handle%s.png", isHovered ? "_highlighted" : "")));
        int xOffset = (this.field_230688_j_ - 6) * this.getIntValue() / this.maxValue;
        IGui.drawTexture(guiDrawing, this.getX2() + xOffset, this.getY2(), 0.0f, 0.0f, 3, this.field_230689_k_ / 2, 8, 20);
        IGui.drawTexture(guiDrawing, this.getX2() + xOffset, this.getY2() + this.field_230689_k_ / 2, 0.0f, 20.0f - (float)this.field_230689_k_ / 2.0f, 3, this.field_230689_k_ / 2, 8, 20);
        IGui.drawTexture(guiDrawing, this.getX2() + xOffset + 3, this.getY2(), 197.0f, 0.0f, 3, this.field_230689_k_ / 2, 8, 20);
        IGui.drawTexture(guiDrawing, this.getX2() + xOffset + 3, this.getY2() + this.field_230689_k_ / 2, 197.0f, 20.0f - (float)this.field_230689_k_ / 2.0f, 3, this.field_230689_k_ / 2, 8, 20);
        guiDrawing.finishDrawingTexture();
        graphicsHolder.drawText(this.getMessage2().getString(), this.getX2() + this.field_230688_j_ + 6, this.getY2() + (this.field_230689_k_ - 8) / 2, -1, false, GraphicsHolder.getDefaultLight());
        if (this.markerFrequency > 0) {
            for (int i = 1; i <= this.maxValue / this.markerFrequency; ++i) {
                int xOffset1 = (this.field_230688_j_ - 6) * i * this.markerFrequency / this.maxValue;
                int x = this.getX2() + xOffset1 + 2;
                int y = this.getY2() + this.field_230689_k_;
                guiDrawing.beginDrawingRectangle();
                guiDrawing.drawRectangle(x, y, x + 2, y + 10, -10066330);
                guiDrawing.finishDrawingRectangle();
                graphicsHolder.drawCenteredText(String.valueOf(i * this.markerFrequency / this.markerDisplayedRatio), this.getX2() + xOffset1 + 3, this.getY2() + this.field_230689_k_ + 10 + 2, -1);
            }
        }
    }

    public void setValue(int valueInt) {
        this.field_230683_b_ = (double)valueInt / (double)this.maxValue;
        this.updateMessage2();
    }

    public int getIntValue() {
        return (int)Math.round(this.field_230683_b_ * (double)this.maxValue);
    }

    private void checkShiftClick() {
        if (this.shiftClickAction != null && Screen.hasShiftDown()) {
            this.shiftClickAction.accept(this.getIntValue());
        }
    }
}

