/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.sound;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mod.sound.BveMotorDataBase;
import org.mtr.mod.sound.BveVehicleSoundConfig;

public final class BveMotorData4
extends BveMotorDataBase {
    private final Channel[] channels = new Channel[4];
    private final int soundCount;

    public BveMotorData4(String baseName) {
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new Channel();
        }
        String textContent = BveVehicleSoundConfig.readResource(new Identifier(baseName + "/train.dat"));
        String[] lines = textContent.split("[\\r\\n]+");
        String section = "";
        for (String line : lines) {
            String lineTrim = line.trim().toLowerCase(Locale.ENGLISH);
            if (StringUtils.isEmpty((CharSequence)lineTrim)) continue;
            if (lineTrim.startsWith("#")) {
                section = lineTrim.substring(1).trim().toLowerCase(Locale.ENGLISH);
                continue;
            }
            switch (section) {
                case "motor_p1": 
                case "motor_p2": 
                case "motor_b1": 
                case "motor_b2": {
                    int listIndex = (section.charAt(6) == 'p' ? 0 : 2) + (section.charAt(7) == '1' ? 0 : 1);
                    String[] tokens = lineTrim.split(",");
                    this.channels[listIndex].soundIds.add(Integer.parseInt(tokens[0]));
                    this.channels[listIndex].pitches.add(Float.valueOf(Float.parseFloat(tokens[1]) / 100.0f));
                    this.channels[listIndex].volumes.add(Float.valueOf(Float.parseFloat(tokens[2]) / 128.0f));
                    this.channels[listIndex].maxSoundId = Math.max(this.channels[listIndex].maxSoundId, Integer.parseInt(tokens[0]));
                    ++this.channels[listIndex].maxEntryId;
                }
            }
        }
        int maxSoundId = -1;
        for (Channel channel : this.channels) {
            maxSoundId = Math.max(maxSoundId, channel.maxSoundId);
        }
        this.soundCount = maxSoundId + 1;
    }

    @Override
    public int getSoundCount() {
        return this.soundCount;
    }

    @Override
    public float getPitch(int index, float speed, float power) {
        if (power == 0.0f) {
            return 0.0f;
        }
        int offset = power > 0.0f ? 0 : 2;
        int entryIndex = (int)(speed / 0.2f);
        if (index == BveMotorData4.getSafe(this.channels[offset].soundIds, Math.min(this.channels[offset].maxEntryId, entryIndex))) {
            return BveMotorData4.getSafe(this.channels[offset].pitches, entryIndex).floatValue();
        }
        if (index == BveMotorData4.getSafe(this.channels[offset + 1].soundIds, Math.min(this.channels[offset + 1].maxEntryId, entryIndex))) {
            return BveMotorData4.getSafe(this.channels[offset + 1].pitches, entryIndex).floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getVolume(int index, float speed, float power) {
        if (power == 0.0f) {
            return 0.0f;
        }
        int offset = power > 0.0f ? 0 : 2;
        int entryIndex = (int)(speed / 0.2f);
        if (index == BveMotorData4.getSafe(this.channels[offset].soundIds, Math.min(this.channels[offset].maxEntryId, entryIndex))) {
            return BveMotorData4.getSafe(this.channels[offset].volumes, entryIndex).floatValue() * Math.abs(power);
        }
        if (index == BveMotorData4.getSafe(this.channels[offset + 1].soundIds, Math.min(this.channels[offset + 1].maxEntryId, entryIndex))) {
            return BveMotorData4.getSafe(this.channels[offset + 1].volumes, entryIndex).floatValue() * Math.abs(power);
        }
        return 0.0f;
    }

    private static <T> T getSafe(ArrayList<T> list, int index) {
        return list.get(MathHelper.clamp(index, 0, list.size() - 1));
    }

    public static class Channel {
        public ArrayList<Integer> soundIds = new ArrayList();
        public ArrayList<Float> pitches = new ArrayList();
        public ArrayList<Float> volumes = new ArrayList();
        public int maxEntryId = -1;
        public int maxSoundId = -1;
    }
}

