/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.resource;

import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.generated.resource.BlockbenchElementSchema;
import org.mtr.mod.resource.GroupTransformations;
import org.mtr.mod.resource.ModelDisplayPart;

public final class BlockbenchElement
extends BlockbenchElementSchema {
    public BlockbenchElement(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public String getUuid() {
        return this.uuid;
    }

    public Box setModelPart(ModelPartExtension parentModelPart, GroupTransformations groupTransformations, ModelDisplayPart modelDisplayPart, float modelYOffset) {
        float originX = -Utilities.getElement(this.origin, 0, 0.0).floatValue();
        float originY = -Utilities.getElement(this.origin, 1, 0.0).floatValue() - modelYOffset * 16.0f;
        float originZ = Utilities.getElement(this.origin, 2, 0.0).floatValue();
        float rotationX = (float)Math.toRadians(-Utilities.getElement(this.rotation, 0, 0.0).doubleValue());
        float rotationY = (float)Math.toRadians(-Utilities.getElement(this.rotation, 1, 0.0).doubleValue());
        float rotationZ = (float)Math.toRadians(Utilities.getElement(this.rotation, 2, 0.0));
        GroupTransformations newGroupTransformations = new GroupTransformations(groupTransformations, this.origin, this.rotation);
        ModelPartExtension modelPart = newGroupTransformations.create(parentModelPart, modelYOffset);
        modelPart.setTextureUVOffset(Utilities.getElement(this.uv_offset, 0, 0L).intValue(), Utilities.getElement(this.uv_offset, 1, 0L).intValue());
        float x = -Utilities.getElement(this.to, 0, 0.0).floatValue() - originX;
        float y = -Utilities.getElement(this.to, 1, 0.0).floatValue() - originY - modelYOffset * 16.0f;
        float z = Utilities.getElement(this.from, 2, 0.0).floatValue() - originZ;
        int sizeX = (int)Math.round(Utilities.getElement(this.to, 0, 0.0) - Utilities.getElement(this.from, 0, 0.0));
        int sizeY = (int)Math.round(Utilities.getElement(this.to, 1, 0.0) - Utilities.getElement(this.from, 1, 0.0));
        int sizeZ = (int)Math.round(Utilities.getElement(this.to, 2, 0.0) - Utilities.getElement(this.from, 2, 0.0));
        modelPart.addCuboid(x, y, z, sizeX, sizeY, sizeZ, (float)this.inflate, !this.shade || this.mirror_uv);
        newGroupTransformations.create(modelDisplayPart.storedMatrixTransformations, modelYOffset);
        modelDisplayPart.storedMatrixTransformations.add(graphicsHolder -> graphicsHolder.translate(x / 16.0f, y / 16.0f, z / 16.0f));
        modelDisplayPart.width = sizeX;
        modelDisplayPart.height = sizeY;
        Vector3d vector1 = new Vector3d(x, y, z).rotateX(rotationX).rotateY(rotationY).rotateZ(rotationZ);
        Vector3d vector2 = new Vector3d(x + (float)sizeX, y + (float)sizeY, z + (float)sizeZ).rotateX(rotationX).rotateY(rotationY).rotateZ(rotationZ);
        return new Box(-(vector1.getXMapped() + (double)originX) / 16.0, -(vector1.getYMapped() + (double)originY) / 16.0, -(vector1.getZMapped() + (double)originZ) / 16.0, -(vector2.getXMapped() + (double)originX) / 16.0, -(vector2.getYMapped() + (double)originY) / 16.0, -(vector2.getZMapped() + (double)originZ) / 16.0);
    }
}

