/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum OperatingSystem {
    LINUX(Util.OS.LINUX),
    SOLARIS(Util.OS.SOLARIS),
    WINDOWS(Util.OS.WINDOWS),
    OSX(Util.OS.OSX),
    UNKNOWN(Util.OS.UNKNOWN);

    public final Util.OS data;

    private OperatingSystem(Util.OS data) {
        this.data = data;
    }

    public static OperatingSystem convert(@Nullable Util.OS data) {
        return data == null ? null : OperatingSystem.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable OperatingSystem data) {
        return data != null && this.data == data.data;
    }

    @MappedMethod
    public void open(URL arg0) {
        this.data.m_137650_(arg0);
    }

    @MappedMethod
    public void open(String arg0) {
        this.data.m_137646_(arg0);
    }

    @MappedMethod
    public void open(URI arg0) {
        this.data.m_137648_(arg0);
    }

    @MappedMethod
    public void open(File arg0) {
        this.data.m_137644_(arg0);
    }

    @Nonnull
    @MappedMethod
    public static OperatingSystem getLinuxMapped() {
        return OperatingSystem.convert(Util.OS.LINUX);
    }

    @Nonnull
    @MappedMethod
    public static OperatingSystem getOsxMapped() {
        return OperatingSystem.convert(Util.OS.OSX);
    }

    @Nonnull
    @MappedMethod
    public static OperatingSystem getWindowsMapped() {
        return OperatingSystem.convert(Util.OS.WINDOWS);
    }

    @Nonnull
    @MappedMethod
    public static OperatingSystem getUnknownMapped() {
        return OperatingSystem.convert(Util.OS.UNKNOWN);
    }

    @Nonnull
    @MappedMethod
    public static OperatingSystem getSolarisMapped() {
        return OperatingSystem.convert(Util.OS.SOLARIS);
    }
}

