/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.mapper;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.tool.ColorHelper;
import org.mtr.mapping.tool.DummyClass;

public final class GraphicsHolder
extends DummyClass {
    VertexConsumer vertexConsumer;
    private int matrixPushes;
    final PoseStack matrixStack;
    final MultiBufferSource vertexConsumerProvider;
    final GuiGraphics drawContext;

    @MappedMethod
    public static int getDefaultLight() {
        return 0xF000F0;
    }

    @Deprecated
    public static void createInstanceSafe(@Nullable PoseStack matrixStack, @Nullable MultiBufferSource vertexConsumerProvider, Consumer<GraphicsHolder> consumer) {
        GraphicsHolder.createInstanceSafe(new GraphicsHolder(matrixStack, vertexConsumerProvider), consumer);
    }

    @Deprecated
    public static void createInstanceSafe(GuiGraphics drawContext, Consumer<GraphicsHolder> consumer) {
        GraphicsHolder.createInstanceSafe(new GraphicsHolder(drawContext), consumer);
    }

    private static void createInstanceSafe(GraphicsHolder graphicsHolder, Consumer<GraphicsHolder> consumer) {
        try {
            consumer.accept(graphicsHolder);
        }
        catch (Exception e) {
            GraphicsHolder.logException(e);
        }
        while (graphicsHolder.matrixPushes > 0) {
            graphicsHolder.pop();
        }
    }

    private GraphicsHolder(@Nullable PoseStack matrixStack, @Nullable MultiBufferSource vertexConsumerProvider) {
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.drawContext = null;
        this.push();
    }

    private GraphicsHolder(GuiGraphics drawContext) {
        this.matrixStack = drawContext.m_280168_();
        this.vertexConsumerProvider = drawContext.m_280091_();
        this.drawContext = drawContext;
        this.push();
    }

    @MappedMethod
    public void push() {
        if (this.matrixStack != null) {
            this.matrixStack.m_85836_();
            ++this.matrixPushes;
        }
    }

    @MappedMethod
    public void pop() {
        if (this.matrixStack != null && this.matrixPushes > 0) {
            this.matrixStack.m_85849_();
            --this.matrixPushes;
        }
    }

    @MappedMethod
    public void translate(double x, double y, double z) {
        if (this.matrixStack != null) {
            this.matrixStack.m_85837_(x, y, z);
        }
    }

    @MappedMethod
    public void scale(float x, float y, float z) {
        if (this.matrixStack != null) {
            this.matrixStack.m_85841_(x, y, z);
        }
    }

    @MappedMethod
    public void rotateXRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.m_252781_(Axis.f_252529_.m_252961_(angle));
        }
    }

    @MappedMethod
    public void rotateYRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.m_252781_(Axis.f_252436_.m_252961_(angle));
        }
    }

    @MappedMethod
    public void rotateZRadians(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.m_252781_(Axis.f_252403_.m_252961_(angle));
        }
    }

    @MappedMethod
    public void rotateXDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.m_252781_(Axis.f_252529_.m_252977_(angle));
        }
    }

    @MappedMethod
    public void rotateYDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        }
    }

    @MappedMethod
    public void rotateZDegrees(float angle) {
        if (this.matrixStack != null) {
            this.matrixStack.m_252781_(Axis.f_252403_.m_252977_(angle));
        }
    }

    @MappedMethod
    public void drawText(MutableText mutableText, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            MultiBufferSource.BufferSource immediate = this.drawContext == null ? MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()) : this.drawContext.m_280091_();
            GraphicsHolder.getInstance().f_91062_.m_272077_((Component)mutableText.data, (float)x, (float)y, color, shadow, this.matrixStack.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, light);
            if (this.drawContext == null) {
                immediate.m_109911_();
            } else {
                this.drawContext.m_280262_();
            }
        }
    }

    @MappedMethod
    public void drawText(OrderedText orderedText, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            MultiBufferSource.BufferSource immediate = this.drawContext == null ? MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()) : this.drawContext.m_280091_();
            GraphicsHolder.getInstance().f_91062_.m_272191_((FormattedCharSequence)orderedText.data, (float)x, (float)y, color, shadow, this.matrixStack.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, light);
            if (this.drawContext == null) {
                immediate.m_109911_();
            } else {
                this.drawContext.m_280262_();
            }
        }
    }

    @MappedMethod
    public void drawText(String text, int x, int y, int color, boolean shadow, int light) {
        if (this.matrixStack != null) {
            MultiBufferSource.BufferSource immediate = this.drawContext == null ? MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()) : this.drawContext.m_280091_();
            GraphicsHolder.getInstance().f_91062_.m_271703_(text, (float)x, (float)y, color, shadow, this.matrixStack.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, light);
            if (this.drawContext == null) {
                immediate.m_109911_();
            } else {
                this.drawContext.m_280262_();
            }
        }
    }

    @MappedMethod
    public void drawCenteredText(String text, int centerX, int y, int color) {
        if (this.drawContext != null) {
            this.drawContext.m_280137_(GraphicsHolder.getInstance().f_91062_, text, centerX, y, color);
        }
    }

    @MappedMethod
    public void drawCenteredText(MutableText text, int centerX, int y, int color) {
        if (this.drawContext != null) {
            this.drawContext.m_280653_(GraphicsHolder.getInstance().f_91062_, (Component)text.data, centerX, y, color);
        }
    }

    @MappedMethod
    public static int getTextWidth(MutableText mutableText) {
        return GraphicsHolder.getInstance().f_91062_.m_92852_((FormattedText)mutableText.data);
    }

    @MappedMethod
    public static int getTextWidth(OrderedText orderedText) {
        return GraphicsHolder.getInstance().f_91062_.m_92724_((FormattedCharSequence)orderedText.data);
    }

    @MappedMethod
    public static int getTextWidth(String text) {
        return GraphicsHolder.getInstance().f_91062_.m_92895_(text);
    }

    @MappedMethod
    public static List<OrderedText> wrapLines(MutableText mutableText, int width) {
        return GraphicsHolder.getInstance().f_91062_.m_92923_((FormattedText)mutableText.data, width).stream().map(OrderedText::new).collect(Collectors.toList());
    }

    private static Minecraft getInstance() {
        return Minecraft.m_91087_();
    }

    @MappedMethod
    public void createVertexConsumer(RenderLayer renderLayer) {
        if (this.vertexConsumerProvider != null) {
            this.vertexConsumer = this.vertexConsumerProvider.m_6299_((RenderType)renderLayer.data);
        }
    }

    @MappedMethod
    public void drawLineInWorld(float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        if (this.matrixStack != null && this.vertexConsumer != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                PoseStack.Pose entry = this.matrixStack.m_85850_();
                Matrix4f matrix4f = entry.m_252922_();
                Matrix3f matrix3f = entry.m_252943_();
                this.vertexConsumer.m_252986_(matrix4f, x1, y1, z1).m_6122_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                this.vertexConsumer.m_252986_(matrix4f, x2, y2, z2).m_6122_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            });
        }
    }

    @MappedMethod
    public void drawTextureInWorld(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        if (this.matrixStack != null && this.vertexConsumer != null) {
            ColorHelper.unpackColor(color, (a, r, g, b) -> {
                Vector3i vector3i = facing.getVector();
                int x = vector3i.getX();
                int y = vector3i.getY();
                int z = vector3i.getZ();
                PoseStack.Pose entry = this.matrixStack.m_85850_();
                Matrix4f matrix4f = entry.m_252922_();
                Matrix3f matrix3f = entry.m_252943_();
                this.vertexConsumer.m_252986_(matrix4f, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, (float)x, (float)y, (float)z).m_5752_();
                this.vertexConsumer.m_252986_(matrix4f, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, (float)x, (float)y, (float)z).m_5752_();
                this.vertexConsumer.m_252986_(matrix4f, x3, y3, z3).m_6122_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, (float)x, (float)y, (float)z).m_5752_();
                this.vertexConsumer.m_252986_(matrix4f, x4, y4, z4).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3f, (float)x, (float)y, (float)z).m_5752_();
            });
        }
    }

    @MappedMethod
    public void renderEntity(Entity entity, double x, double y, double z, float yaw, float tickDelta, int light) {
        if (this.matrixStack != null && this.vertexConsumerProvider != null) {
            GraphicsHolder.getInstance().m_91290_().m_114384_((net.minecraft.world.entity.Entity)entity.data, x, y, z, yaw, tickDelta, this.matrixStack, this.vertexConsumerProvider, light);
        }
    }
}

