/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.render;

import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.Init;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.PlatformHelper;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.PositionAndRotation;
import org.mtr.mod.render.QueuedRenderLayer;

public class RenderVehicleHelper {
    public static final float HALF_PLAYER_WIDTH = 0.3f;
    private static final int CHECK_DOOR_RADIUS_XZ = 1;
    private static final int CHECK_DOOR_RADIUS_Y = 2;
    private static final double RIDE_STEP_THRESHOLD = 0.75;

    public static boolean canOpenDoors(Box doorway, PositionAndRotation positionAndRotation, double doorValue) {
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld == null) {
            return false;
        }
        Vector3d doorwayPosition1 = positionAndRotation.transformForwards(new Vector3d(doorway.getMinXMapped(), doorway.getMaxYMapped(), doorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        Vector3d doorwayPosition2 = positionAndRotation.transformForwards(new Vector3d(doorway.getMaxXMapped(), doorway.getMaxYMapped(), doorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        Vector3d doorwayPosition3 = positionAndRotation.transformForwards(new Vector3d(doorway.getMaxXMapped(), doorway.getMaxYMapped(), doorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        Vector3d doorwayPosition4 = positionAndRotation.transformForwards(new Vector3d(doorway.getMinXMapped(), doorway.getMaxYMapped(), doorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
        double minX = Math.min(Math.min(doorwayPosition1.getXMapped(), doorwayPosition2.getXMapped()), Math.min(doorwayPosition3.getXMapped(), doorwayPosition4.getXMapped()));
        double maxX = Math.max(Math.max(doorwayPosition1.getXMapped(), doorwayPosition2.getXMapped()), Math.max(doorwayPosition3.getXMapped(), doorwayPosition4.getXMapped()));
        double minY = Math.min(Math.min(doorwayPosition1.getYMapped(), doorwayPosition2.getYMapped()), Math.min(doorwayPosition3.getYMapped(), doorwayPosition4.getYMapped()));
        double maxY = Math.max(Math.max(doorwayPosition1.getYMapped(), doorwayPosition2.getYMapped()), Math.max(doorwayPosition3.getYMapped(), doorwayPosition4.getYMapped()));
        double minZ = Math.min(Math.min(doorwayPosition1.getZMapped(), doorwayPosition2.getZMapped()), Math.min(doorwayPosition3.getZMapped(), doorwayPosition4.getZMapped()));
        double maxZ = Math.max(Math.max(doorwayPosition1.getZMapped(), doorwayPosition2.getZMapped()), Math.max(doorwayPosition3.getZMapped(), doorwayPosition4.getZMapped()));
        boolean canOpenDoors = false;
        for (double checkX = minX - 1.0; checkX <= maxX + 1.0; checkX += 1.0) {
            for (double checkY = minY - 2.0; checkY <= maxY + 2.0; checkY += 1.0) {
                for (double checkZ = minZ - 1.0; checkZ <= maxZ + 1.0; checkZ += 1.0) {
                    BlockPos checkPos = Init.newBlockPos(checkX, checkY, checkZ);
                    BlockState blockState = clientWorld.getBlockState(checkPos);
                    Block block = blockState.getBlock();
                    if (block.data instanceof PlatformHelper) {
                        canOpenDoors = true;
                        continue;
                    }
                    if (!(block.data instanceof BlockPSDAPGDoorBase) || !((Boolean)blockState.get(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGDoorBase.UNLOCKED.data))).booleanValue()) continue;
                    canOpenDoors = true;
                    BlockEntity blockEntity = clientWorld.getBlockEntity(checkPos);
                    if (blockEntity == null || !(blockEntity.data instanceof BlockPSDAPGDoorBase.BlockEntityBase)) continue;
                    ((BlockPSDAPGDoorBase.BlockEntityBase)blockEntity.data).setDoorValue(doorValue);
                }
            }
        }
        return canOpenDoors;
    }

    public static double getDoorBlockedAmount(Box doorway, double playerX, double playerY, double playerZ) {
        if (playerX > doorway.getMinXMapped() - (double)0.3f && playerX < doorway.getMaxXMapped() + (double)0.3f && Utilities.isBetween(playerY, doorway.getMinYMapped(), doorway.getMaxYMapped()) && playerZ > doorway.getMinZMapped() - (double)0.3f && playerZ < doorway.getMaxZMapped() + (double)0.3f) {
            double halfWidth = (doorway.getMaxZMapped() - doorway.getMinZMapped()) / 2.0;
            double distance = Math.min(playerZ - (double)0.3f - doorway.getMinZMapped(), doorway.getMaxZMapped() - (double)0.3f - playerZ);
            return Utilities.clamp((halfWidth - distance) / halfWidth, 0.0, 1.0);
        }
        return 0.0;
    }

    public static void renderFloorOrDoorway(Box floorOrDoorway, int color, Vector3d playerPosition, PositionAndRotation positionAndRotation, boolean useOffset) {
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity != null && clientPlayerEntity.isHolding(Items.BRUSH.get())) {
            Vector3d corner1 = positionAndRotation.transformForwards(new Vector3d(floorOrDoorway.getMinXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            Vector3d corner2 = positionAndRotation.transformForwards(new Vector3d(floorOrDoorway.getMaxXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMinZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            Vector3d corner3 = positionAndRotation.transformForwards(new Vector3d(floorOrDoorway.getMaxXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            Vector3d corner4 = positionAndRotation.transformForwards(new Vector3d(floorOrDoorway.getMinXMapped(), floorOrDoorway.getMaxYMapped(), floorOrDoorway.getMaxZMapped()), Vector3d::rotateX, Vector3d::rotateY, Vector3d::add);
            int newColor = RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() - (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() - (double)0.3f) || RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() + (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() - (double)0.3f) || RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() + (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() + (double)0.3f) || RenderVehicleHelper.boxContains(floorOrDoorway, playerPosition.getXMapped() - (double)0.3f, playerPosition.getYMapped(), playerPosition.getZMapped() + (double)0.3f) ? -16711936 : color;
            Vector3d zeroVector = Vector3d.getZeroMapped();
            MainRenderer.scheduleRender(QueuedRenderLayer.LINES, (graphicsHolder, offset) -> {
                RenderVehicleHelper.drawLine(graphicsHolder, corner1, corner2, useOffset ? offset : zeroVector, newColor);
                RenderVehicleHelper.drawLine(graphicsHolder, corner2, corner3, useOffset ? offset : zeroVector, newColor);
                RenderVehicleHelper.drawLine(graphicsHolder, corner3, corner4, useOffset ? offset : zeroVector, newColor);
                RenderVehicleHelper.drawLine(graphicsHolder, corner4, corner1, useOffset ? offset : zeroVector, newColor);
            });
        }
    }

    public static boolean boxContains(Box box, double x, double y, double z) {
        return Utilities.isBetween(x, box.getMinXMapped(), box.getMaxXMapped()) && Utilities.isBetween(y, box.getMinYMapped(), box.getMaxYMapped(), 0.75) && Utilities.isBetween(z, box.getMinZMapped(), box.getMaxZMapped());
    }

    private static void drawLine(GraphicsHolder graphicsHolder, Vector3d corner1, Vector3d corner2, Vector3d offset, int color) {
        graphicsHolder.drawLineInWorld((float)(corner1.getXMapped() - offset.getXMapped()), (float)(corner1.getYMapped() - offset.getYMapped()), (float)(corner1.getZMapped() - offset.getZMapped()), (float)(corner2.getXMapped() - offset.getXMapped()), (float)(corner2.getYMapped() - offset.getYMapped()), (float)(corner2.getZMapped() - offset.getZMapped()), color);
    }
}

