/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.map;

import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.mtr.core.Main;
import org.mtr.core.data.AreaBase;
import org.mtr.core.data.SavedRailBase;
import org.mtr.core.map.UpdateWebMap;
import org.mtr.core.simulation.Simulator;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;

public final class UpdateDynmap
implements UpdateWebMap {
    private static DynmapCommonAPI dynmapCommonAPI;

    public static void updateDynmap(Simulator simulator) {
        try {
            UpdateDynmap.updateDynmap(simulator.dimension, simulator.stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", "mtr_station");
            UpdateDynmap.updateDynmap(simulator.dimension, simulator.depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", "mtr_depot");
        }
        catch (Exception e) {
            Main.LOGGER.error("", (Throwable)e);
        }
    }

    private static <T extends AreaBase<T, U>, U extends SavedRailBase<U, T>> void updateDynmap(String dimension, ObjectArraySet<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) {
        if (dynmapCommonAPI != null) {
            String worldId;
            switch (dimension) {
                case "minecraft/overworld": {
                    worldId = "world";
                    break;
                }
                case "minecraft/the_nether": {
                    worldId = "DIM-1";
                    break;
                }
                case "minecraft/the_end": {
                    worldId = "DIM1";
                    break;
                }
                default: {
                    worldId = dimension.replaceFirst("/", ":");
                }
            }
            MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
            markerAPI.getPlayerSets().forEach(playerSet -> {
                Main.LOGGER.info(playerSet.getSetID());
                Main.LOGGER.info((Object)playerSet.getPlayers().size());
            });
            markerAPI.getMarkerSets().forEach(playerSet -> {
                Main.LOGGER.info(playerSet.getMarkerSetID());
                Main.LOGGER.info((Object)playerSet.getMarkers().size());
            });
            MarkerSet tempMarkerSetAreas = markerAPI.getMarkerSet(areasId);
            MarkerSet markerSetAreas = tempMarkerSetAreas == null ? markerAPI.createMarkerSet(areasId, areasTitle, ObjectSet.of(markerAPI.getMarkerIcon(iconKey)), false) : tempMarkerSetAreas;
            markerSetAreas.getMarkers().forEach(marker -> {
                if (marker.getMarkerID().startsWith(worldId)) {
                    marker.deleteMarker();
                }
            });
            MarkerSet tempMarkerSetAreaAreas = markerAPI.getMarkerSet(areaAreasId);
            MarkerSet markerSetAreaAreas = tempMarkerSetAreaAreas == null ? markerAPI.createMarkerSet(areaAreasId, areaAreasTitle, new ObjectArraySet(), false) : tempMarkerSetAreaAreas;
            markerSetAreaAreas.setHideByDefault(true);
            markerSetAreaAreas.getAreaMarkers().forEach(marker -> {
                if (marker.getMarkerID().startsWith(worldId)) {
                    marker.deleteMarker();
                }
            });
            UpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
                markerSetAreas.createMarker(worldId + id, name, worldId, areaX, 0.0, areaZ, markerAPI.getMarkerIcon(iconKey), false);
                AreaMarker areaMarker = markerSetAreaAreas.createAreaMarker(worldId + id, name, false, worldId, new double[]{areaCorner1X, areaCorner2X}, new double[]{areaCorner1Z, areaCorner2Z}, false);
                areaMarker.setFillStyle(0.5, 0xFFFFFF & color.getRGB());
                areaMarker.setLineStyle(1, 1.0, 0xFFFFFF & color.darker().getRGB());
            });
        }
    }

    static {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                    dynmapCommonAPI = dynmapCommonAPI;
                    try {
                        MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
                        UpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo.png", inputStream2 -> markerAPI.createMarkerIcon("mtr_station", "mtr_station", inputStream2));
                        UpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo_grayscale.png", inputStream2 -> markerAPI.createMarkerIcon("mtr_depot", "mtr_depot", inputStream2));
                    }
                    catch (Exception e) {
                        Main.LOGGER.error("", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Main.LOGGER.error("", (Throwable)e);
        }
    }
}

