/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionResult;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum ActionResult {
    SUCCESS(InteractionResult.SUCCESS),
    CONSUME(InteractionResult.CONSUME),
    CONSUME_PARTIAL(InteractionResult.CONSUME_PARTIAL),
    PASS(InteractionResult.PASS),
    FAIL(InteractionResult.FAIL);

    public final InteractionResult data;

    private ActionResult(InteractionResult data) {
        this.data = data;
    }

    public static ActionResult convert(@Nullable InteractionResult data) {
        return data == null ? null : ActionResult.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable ActionResult data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static ActionResult success(boolean arg0) {
        return ActionResult.convert(InteractionResult.m_19078_((boolean)arg0));
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getConsumeMapped() {
        return ActionResult.convert(InteractionResult.CONSUME);
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getFailMapped() {
        return ActionResult.convert(InteractionResult.FAIL);
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getSuccessMapped() {
        return ActionResult.convert(InteractionResult.SUCCESS);
    }

    @Nonnull
    @MappedMethod
    public static ActionResult getPassMapped() {
        return ActionResult.convert(InteractionResult.PASS);
    }
}

