/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.LightLayer;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum LightType {
    SKY(LightLayer.SKY),
    BLOCK(LightLayer.BLOCK);

    public final LightLayer data;

    private LightType(LightLayer data) {
        this.data = data;
    }

    public static LightType convert(@Nullable LightLayer data) {
        return data == null ? null : LightType.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable LightType data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static LightType getBlockMapped() {
        return LightType.convert(LightLayer.BLOCK);
    }

    @Nonnull
    @MappedMethod
    public static LightType getSkyMapped() {
        return LightType.convert(LightLayer.SKY);
    }
}

