/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BufferBuilderStorage;
import org.mtr.mapping.holder.ClientPlayNetworkHandler;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.EntityRenderDispatcher;
import org.mtr.mapping.holder.GameOptions;
import org.mtr.mapping.holder.GameRenderer;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.ResourceManager;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.SoundManager;
import org.mtr.mapping.holder.TextureManager;
import org.mtr.mapping.holder.Window;
import org.mtr.mapping.holder.WorldRenderer;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class MinecraftClient
extends HolderBase<Minecraft> {
    public MinecraftClient(Minecraft data) {
        super(data);
    }

    @MappedMethod
    public static MinecraftClient cast(HolderBase<?> data) {
        return new MinecraftClient((Minecraft)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof Minecraft;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((Minecraft)this.data).equals(((HolderBase)data).data);
    }

    @Nonnull
    @MappedMethod
    public BufferBuilderStorage getBufferBuilders() {
        return new BufferBuilderStorage(((Minecraft)this.data).m_91269_());
    }

    @Nonnull
    @MappedMethod
    public TextureManager getTextureManager() {
        return new TextureManager(((Minecraft)this.data).m_91097_());
    }

    @MappedMethod
    public final boolean isDemo() {
        return ((Minecraft)this.data).m_91402_();
    }

    @Nonnull
    @MappedMethod
    public ResourceManager getResourceManager() {
        return new ResourceManager(((Minecraft)this.data).m_91098_());
    }

    @MappedMethod
    public void setCameraEntity(Entity arg0) {
        ((Minecraft)this.data).m_91118_((net.minecraft.world.entity.Entity)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public <V> CompletableFuture<V> submit(Supplier<V> arg0) {
        return ((Minecraft)this.data).m_18691_(arg0);
    }

    @Nonnull
    @MappedMethod
    public CompletableFuture<Void> submit(Runnable arg0) {
        return ((Minecraft)this.data).m_18707_(arg0);
    }

    @MappedMethod
    public void tick() {
        ((Minecraft)this.data).m_91398_();
    }

    @Nonnull
    @MappedMethod
    public DataFixer getDataFixer() {
        return ((Minecraft)this.data).m_91295_();
    }

    @MappedMethod
    public void execute(Runnable arg0) {
        ((Minecraft)this.data).execute(arg0);
    }

    @MappedMethod
    public void openScreen(@Nullable Screen arg0) {
        ((Minecraft)this.data).m_91152_(arg0 == null ? null : (net.minecraft.client.gui.screens.Screen)arg0.data);
    }

    @MappedMethod
    public void joinWorld(ClientWorld arg0) {
        ((Minecraft)this.data).m_91156_((ClientLevel)arg0.data);
    }

    @MappedMethod
    public boolean is64Bit() {
        return ((Minecraft)this.data).m_91103_();
    }

    @MappedMethod
    public boolean isRunning() {
        return ((Minecraft)this.data).m_91396_();
    }

    @Nullable
    @MappedMethod
    public ClientPlayNetworkHandler getNetworkHandler() {
        ClientPacketListener tempData = ((Minecraft)this.data).m_91403_();
        return tempData == null ? null : new ClientPlayNetworkHandler(tempData);
    }

    @Nonnull
    @MappedMethod
    public Window getWindow() {
        return new Window(((Minecraft)this.data).m_91268_());
    }

    @Nonnull
    @MappedMethod
    public SoundManager getSoundManager() {
        return new SoundManager(((Minecraft)this.data).m_91106_());
    }

    @MappedMethod
    public float getTickDelta() {
        return ((Minecraft)this.data).m_91296_();
    }

    @Nullable
    @MappedMethod
    public Entity getCameraEntity() {
        net.minecraft.world.entity.Entity tempData = ((Minecraft)this.data).m_91288_();
        return tempData == null ? null : new Entity(tempData);
    }

    @Nonnull
    @MappedMethod
    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return new EntityRenderDispatcher(((Minecraft)this.data).m_91290_());
    }

    @MappedMethod
    public void runTasks(BooleanSupplier arg0) {
        ((Minecraft)this.data).m_18701_(arg0);
    }

    @Nonnull
    @MappedMethod
    public static MinecraftClient getInstance() {
        return new MinecraftClient(Minecraft.m_91087_());
    }

    @MappedMethod
    public void run() {
        ((Minecraft)this.data).m_91374_();
    }

    @MappedMethod
    public float getLastFrameDuration() {
        return ((Minecraft)this.data).m_91297_();
    }

    @MappedMethod
    public void close() {
        ((Minecraft)this.data).close();
    }

    @Nonnull
    @MappedMethod
    public Proxy getNetworkProxy() {
        return ((Minecraft)this.data).m_91096_();
    }

    @Nonnull
    @MappedMethod
    public MinecraftSessionService getSessionService() {
        return ((Minecraft)this.data).m_91108_();
    }

    @Nonnull
    @MappedMethod
    public String getVersionType() {
        return ((Minecraft)this.data).m_91389_();
    }

    @MappedMethod
    public boolean hasOutline(Entity arg0) {
        return ((Minecraft)this.data).m_91314_((net.minecraft.world.entity.Entity)arg0.data);
    }

    @Deprecated
    public MinecraftClient(GameConfig arg0) {
        super(new Minecraft(arg0));
    }

    @MappedMethod
    public void stop() {
        ((Minecraft)this.data).m_91395_();
    }

    @MappedMethod
    public boolean isPaused() {
        return ((Minecraft)this.data).m_91104_();
    }

    @MappedMethod
    public static boolean getIsSystemMacMapped() {
        return Minecraft.f_91002_;
    }

    @Nullable
    @MappedMethod
    public ClientPlayerEntity getPlayerMapped() {
        return ((Minecraft)this.data).f_91074_ == null ? null : new ClientPlayerEntity(((Minecraft)this.data).f_91074_);
    }

    @MappedMethod
    public void setPlayerMapped(@Nullable ClientPlayerEntity newData) {
        ((Minecraft)this.data).f_91074_ = newData == null ? null : (LocalPlayer)newData.data;
    }

    @Nonnull
    @MappedMethod
    public File getRunDirectoryMapped() {
        return ((Minecraft)this.data).f_91069_;
    }

    @Nonnull
    @MappedMethod
    public WorldRenderer getWorldRendererMapped() {
        return new WorldRenderer(((Minecraft)this.data).f_91060_);
    }

    @Nullable
    @MappedMethod
    public Screen getCurrentScreenMapped() {
        return ((Minecraft)this.data).f_91080_ == null ? null : new Screen(((Minecraft)this.data).f_91080_);
    }

    @MappedMethod
    public void setCurrentScreenMapped(@Nullable Screen newData) {
        ((Minecraft)this.data).f_91080_ = newData == null ? null : (net.minecraft.client.gui.screens.Screen)newData.data;
    }

    @Nullable
    @MappedMethod
    public HitResult getCrosshairTargetMapped() {
        return ((Minecraft)this.data).f_91077_ == null ? null : new HitResult(((Minecraft)this.data).f_91077_);
    }

    @MappedMethod
    public void setCrosshairTargetMapped(@Nullable HitResult newData) {
        ((Minecraft)this.data).f_91077_ = newData == null ? null : (net.minecraft.world.phys.HitResult)newData.data;
    }

    @Nullable
    @MappedMethod
    public ClientWorld getWorldMapped() {
        return ((Minecraft)this.data).f_91073_ == null ? null : new ClientWorld(((Minecraft)this.data).f_91073_);
    }

    @MappedMethod
    public void setWorldMapped(@Nullable ClientWorld newData) {
        ((Minecraft)this.data).f_91073_ = newData == null ? null : (ClientLevel)newData.data;
    }

    @Nullable
    @MappedMethod
    public Entity getTargetedEntityMapped() {
        return ((Minecraft)this.data).f_91076_ == null ? null : new Entity(((Minecraft)this.data).f_91076_);
    }

    @MappedMethod
    public void setTargetedEntityMapped(@Nullable Entity newData) {
        ((Minecraft)this.data).f_91076_ = newData == null ? null : (net.minecraft.world.entity.Entity)newData.data;
    }

    @Nullable
    @MappedMethod
    public Entity getCameraEntityMapped() {
        return ((Minecraft)this.data).f_91075_ == null ? null : new Entity(((Minecraft)this.data).f_91075_);
    }

    @MappedMethod
    public void setCameraEntityMapped(@Nullable Entity newData) {
        ((Minecraft)this.data).f_91075_ = newData == null ? null : (net.minecraft.world.entity.Entity)newData.data;
    }

    @Nonnull
    @MappedMethod
    public GameRenderer getGameRendererMapped() {
        return new GameRenderer(((Minecraft)this.data).f_91063_);
    }

    @Nonnull
    @MappedMethod
    public GameOptions getOptionsMapped() {
        return new GameOptions(((Minecraft)this.data).f_91066_);
    }

    @Nonnull
    @MappedMethod
    public String getFpsDebugStringMapped() {
        return ((Minecraft)this.data).f_90977_;
    }

    @MappedMethod
    public void setFpsDebugStringMapped(String newData) {
        ((Minecraft)this.data).f_90977_ = newData;
    }
}

