/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Chunk;
import org.mtr.mapping.holder.ChunkManager;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Difficulty;
import org.mtr.mapping.holder.DimensionType;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.FluidState;
import org.mtr.mapping.holder.HeightMapType;
import org.mtr.mapping.holder.LightType;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ParticleEffect;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.Scoreboard;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.WorldChunk;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class World
extends HolderBase<Level> {
    public World(Level data) {
        super(data);
    }

    @MappedMethod
    public static World cast(HolderBase<?> data) {
        return new World((Level)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof Level;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((Level)this.data).equals(((HolderBase)data).data);
    }

    @Nullable
    @MappedMethod
    public BlockHitResult raycastBlock(Vector3d arg0, Vector3d arg1, BlockPos arg2, VoxelShape arg3, BlockState arg4) {
        net.minecraft.world.phys.BlockHitResult tempData = ((Level)this.data).m_45558_((Vec3)arg0.data, (Vec3)arg1.data, (net.minecraft.core.BlockPos)arg2.data, (net.minecraft.world.phys.shapes.VoxelShape)arg3.data, (net.minecraft.world.level.block.state.BlockState)arg4.data);
        return tempData == null ? null : new BlockHitResult(tempData);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2, int arg3) {
        return ((Level)this.data).m_7740_((net.minecraft.core.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.world.entity.Entity)arg2.data, arg3);
    }

    @MappedMethod
    public boolean isAir(BlockPos arg0) {
        return ((Level)this.data).m_46859_((net.minecraft.core.BlockPos)arg0.data);
    }

    @MappedMethod
    public void addImportantParticle(ParticleEffect arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
        ((Level)this.data).m_7107_((ParticleOptions)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @MappedMethod
    public void addImportantParticle(ParticleEffect arg0, boolean arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7) {
        ((Level)this.data).m_6485_((ParticleOptions)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @MappedMethod
    public void removeBlockEntity(BlockPos arg0) {
        ((Level)this.data).m_46747_((net.minecraft.core.BlockPos)arg0.data);
    }

    @MappedMethod
    public double getDismountHeight(BlockPos arg0) {
        return ((Level)this.data).m_45573_((net.minecraft.core.BlockPos)arg0.data);
    }

    @MappedMethod
    public void updateListeners(BlockPos arg0, BlockState arg1, BlockState arg2, int arg3) {
        ((Level)this.data).m_7260_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data, (net.minecraft.world.level.block.state.BlockState)arg2.data, arg3);
    }

    @Nonnull
    @MappedMethod
    public Random getRandom() {
        return new Random(((Level)this.data).m_213780_());
    }

    @MappedMethod
    public void addParticle(ParticleEffect arg0, boolean arg1, double arg2, double arg3, double arg4, double arg5, double arg6, double arg7) {
        ((Level)this.data).m_6493_((ParticleOptions)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @MappedMethod
    public void addParticle(ParticleEffect arg0, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
        ((Level)this.data).m_7106_((ParticleOptions)arg0.data, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @MappedMethod
    public boolean removeBlock(BlockPos arg0, boolean arg1) {
        return ((Level)this.data).m_7471_((net.minecraft.core.BlockPos)arg0.data, arg1);
    }

    @Nonnull
    @MappedMethod
    public Difficulty getDifficulty() {
        return Difficulty.convert(((Level)this.data).m_46791_());
    }

    @Nonnull
    @MappedMethod
    public FluidState getFluidState(BlockPos arg0) {
        return new FluidState(((Level)this.data).m_6425_((net.minecraft.core.BlockPos)arg0.data));
    }

    @Nullable
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2, boolean arg3) {
        ChunkAccess tempData = ((Level)this.data).m_6522_(arg0, arg1, (net.minecraft.world.level.chunk.ChunkStatus)arg2.data, arg3);
        return tempData == null ? null : new Chunk(tempData);
    }

    @Nonnull
    @MappedMethod
    public WorldChunk getChunk(int arg0, int arg1) {
        return new WorldChunk(((Level)this.data).m_6325_(arg0, arg1));
    }

    @MappedMethod
    public boolean isThundering() {
        return ((Level)this.data).m_46470_();
    }

    @MappedMethod
    public boolean containsFluid(Box arg0) {
        return ((Level)this.data).m_46855_((AABB)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(BlockPos arg0) {
        return new Chunk(((Level)this.data).m_46865_((net.minecraft.core.BlockPos)arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2) {
        return new Chunk(((Level)this.data).m_46819_(arg0, arg1, (net.minecraft.world.level.chunk.ChunkStatus)arg2.data));
    }

    @MappedMethod
    public boolean isSpaceEmpty(Box arg0) {
        return ((Level)this.data).m_45772_((AABB)arg0.data);
    }

    @MappedMethod
    public int getMoonPhase() {
        return ((Level)this.data).m_46941_();
    }

    @MappedMethod
    public long getLunarTime() {
        return ((Level)this.data).m_8044_();
    }

    @MappedMethod
    public boolean isEmittingRedstonePower(BlockPos arg0, Direction arg1) {
        return ((Level)this.data).m_46616_((net.minecraft.core.BlockPos)arg0.data, arg1.data);
    }

    @Nonnull
    @MappedMethod
    public DimensionType getDimension() {
        return new DimensionType(((Level)this.data).m_6042_());
    }

    @MappedMethod
    public boolean isRaining() {
        return ((Level)this.data).m_46471_();
    }

    @MappedMethod
    public boolean isTopSolid(BlockPos arg0, Entity arg1) {
        return ((Level)this.data).m_46575_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.entity.Entity)arg1.data);
    }

    @MappedMethod
    public void playSound(double arg0, double arg1, double arg2, SoundEvent arg3, SoundCategory arg4, float arg5, float arg6, boolean arg7) {
        ((Level)this.data).m_7785_(arg0, arg1, arg2, (net.minecraft.sounds.SoundEvent)arg3.data, arg4.data, arg5, arg6, arg7);
    }

    @MappedMethod
    public boolean isNight() {
        return ((Level)this.data).m_46462_();
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1, @Nullable Entity arg2) {
        return ((Level)this.data).m_46953_((net.minecraft.core.BlockPos)arg0.data, arg1, arg2 == null ? null : (net.minecraft.world.entity.Entity)arg2.data);
    }

    @MappedMethod
    public boolean breakBlock(BlockPos arg0, boolean arg1) {
        return ((Level)this.data).m_46961_((net.minecraft.core.BlockPos)arg0.data, arg1);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getPlayerByUuid(UUID arg0) {
        Player tempData = ((Level)this.data).m_46003_(arg0);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public boolean spawnEntity(Entity arg0) {
        return ((Level)this.data).m_7967_((net.minecraft.world.entity.Entity)arg0.data);
    }

    @MappedMethod
    public void close() throws IOException {
        ((Level)this.data).close();
    }

    @MappedMethod
    public void updateNeighbor(BlockPos arg0, Block arg1, BlockPos arg2) {
        ((Level)this.data).m_46586_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.Block)arg1.data, (net.minecraft.core.BlockPos)arg2.data);
    }

    @MappedMethod
    public int getTopY(HeightMapType arg0, int arg1, int arg2) {
        return ((Level)this.data).m_6924_(arg0.data, arg1, arg2);
    }

    @MappedMethod
    public int getLightLevel(LightType arg0, BlockPos arg1) {
        return ((Level)this.data).m_45517_(arg0.data, (net.minecraft.core.BlockPos)arg1.data);
    }

    @MappedMethod
    public int getHeight() {
        return ((Level)this.data).m_141928_();
    }

    @Nonnull
    @MappedMethod
    public BlockState getBlockState(BlockPos arg0) {
        return new BlockState(((Level)this.data).m_8055_((net.minecraft.core.BlockPos)arg0.data));
    }

    @MappedMethod
    public boolean isWater(BlockPos arg0) {
        return ((Level)this.data).m_46801_((net.minecraft.core.BlockPos)arg0.data);
    }

    @Nonnull
    @MappedMethod
    public WorldChunk getWorldChunk(BlockPos arg0) {
        return new WorldChunk(((Level)this.data).m_46745_((net.minecraft.core.BlockPos)arg0.data));
    }

    @MappedMethod
    public float getBrightness(Direction arg0, boolean arg1) {
        return ((Level)this.data).m_7717_(arg0.data, arg1);
    }

    @MappedMethod
    public boolean isClient() {
        return ((Level)this.data).m_5776_();
    }

    @MappedMethod
    public void addFireworkParticle(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, @Nullable CompoundTag arg6) {
        ((Level)this.data).m_7228_(arg0, arg1, arg2, arg3, arg4, arg5, arg6 == null ? null : (net.minecraft.nbt.CompoundTag)arg6.data);
    }

    @MappedMethod
    public void updateNeighborsExcept(BlockPos arg0, Block arg1, Direction arg2) {
        ((Level)this.data).m_46590_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.Block)arg1.data, arg2.data);
    }

    @MappedMethod
    public void syncWorldEvent(@Nullable PlayerEntity arg0, int arg1, BlockPos arg2, int arg3) {
        ((Level)this.data).m_5898_(arg0 == null ? null : (Player)arg0.data, arg1, (net.minecraft.core.BlockPos)arg2.data, arg3);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2) {
        return ((Level)this.data).m_7731_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data, arg2);
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1, int arg2, int arg3) {
        return ((Level)this.data).m_6933_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data, arg2, arg3);
    }

    @MappedMethod
    public void sendEntityStatus(Entity arg0, byte arg1) {
        ((Level)this.data).m_7605_((net.minecraft.world.entity.Entity)arg0.data, arg1);
    }

    @MappedMethod
    public boolean isRegionLoaded(BlockPos arg0, BlockPos arg1) {
        return ((Level)this.data).m_46832_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.core.BlockPos)arg1.data);
    }

    @MappedMethod
    public boolean isRegionLoaded(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return ((Level)this.data).m_46812_(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    @MappedMethod
    public void setBlockBreakingInfo(int arg0, BlockPos arg1, int arg2) {
        ((Level)this.data).m_6801_(arg0, (net.minecraft.core.BlockPos)arg1.data, arg2);
    }

    @MappedMethod
    public boolean isDay() {
        return ((Level)this.data).m_46461_();
    }

    @Nonnull
    @MappedMethod
    public ChunkManager getChunkManager() {
        return new ChunkManager(((Level)this.data).m_7726_());
    }

    @MappedMethod
    public boolean canPlayerModifyAt(PlayerEntity arg0, BlockPos arg1) {
        return ((Level)this.data).m_7966_((Player)arg0.data, (net.minecraft.core.BlockPos)arg1.data);
    }

    @MappedMethod
    public final boolean isDebugWorld() {
        return ((Level)this.data).m_46659_();
    }

    @MappedMethod
    public boolean canPlace(BlockState arg0, BlockPos arg1, ShapeContext arg2) {
        return ((Level)this.data).m_45752_((net.minecraft.world.level.block.state.BlockState)arg0.data, (net.minecraft.core.BlockPos)arg1.data, (CollisionContext)arg2.data);
    }

    @MappedMethod
    public boolean doesNotIntersectEntities(@Nullable Entity arg0, VoxelShape arg1) {
        return ((Level)this.data).m_5450_(arg0 == null ? null : (net.minecraft.world.entity.Entity)arg0.data, (net.minecraft.world.phys.shapes.VoxelShape)arg1.data);
    }

    @Nullable
    @MappedMethod
    public BlockEntity getBlockEntity(BlockPos arg0) {
        net.minecraft.world.level.block.entity.BlockEntity tempData = ((Level)this.data).m_7702_((net.minecraft.core.BlockPos)arg0.data);
        return tempData == null ? null : new BlockEntity(tempData);
    }

    @MappedMethod
    public boolean isDirectionSolid(BlockPos arg0, Entity arg1, Direction arg2) {
        return ((Level)this.data).m_46578_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.entity.Entity)arg1.data, arg2.data);
    }

    @MappedMethod
    public long getTime() {
        return ((Level)this.data).m_46467_();
    }

    @MappedMethod
    public boolean setBlockState(BlockPos arg0, BlockState arg1) {
        return ((Level)this.data).m_46597_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.state.BlockState)arg1.data);
    }

    @MappedMethod
    public void setMobSpawnOptions(boolean arg0, boolean arg1) {
        ((Level)this.data).m_46703_(arg0, arg1);
    }

    @MappedMethod
    public boolean isSavingDisabled() {
        return ((Level)this.data).m_7441_();
    }

    @Nullable
    @MappedMethod
    public MinecraftServer getServer() {
        net.minecraft.server.MinecraftServer tempData = ((Level)this.data).m_7654_();
        return tempData == null ? null : new MinecraftServer(tempData);
    }

    @MappedMethod
    public boolean isChunkLoaded(int arg0, int arg1) {
        return ((Level)this.data).m_7232_(arg0, arg1);
    }

    @MappedMethod
    public int getMaxLightLevel() {
        return ((Level)this.data).m_7469_();
    }

    @MappedMethod
    public void disconnect() {
        ((Level)this.data).m_7462_();
    }

    @Nonnull
    @MappedMethod
    public BlockPos getRandomPosInChunk(int arg0, int arg1, int arg2, int arg3) {
        return new BlockPos(((Level)this.data).m_46496_(arg0, arg1, arg2, arg3));
    }

    @Nullable
    @MappedMethod
    public Entity getEntityById(int arg0) {
        net.minecraft.world.entity.Entity tempData = ((Level)this.data).m_6815_(arg0);
        return tempData == null ? null : new Entity(tempData);
    }

    @MappedMethod
    public boolean isPlayerInRange(double arg0, double arg1, double arg2, double arg3) {
        return ((Level)this.data).m_45914_(arg0, arg1, arg2, arg3);
    }

    @Nullable
    @MappedMethod
    public BlockView getChunkAsView(int arg0, int arg1) {
        BlockGetter tempData = ((Level)this.data).m_7925_(arg0, arg1);
        return tempData == null ? null : new BlockView(tempData);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(Entity arg0, double arg1) {
        Player tempData = ((Level)this.data).m_45930_((net.minecraft.world.entity.Entity)arg0.data, arg1);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @Nullable
    @MappedMethod
    public PlayerEntity getClosestPlayer(double arg0, double arg1, double arg2, double arg3, boolean arg4) {
        Player tempData = ((Level)this.data).m_45924_(arg0, arg1, arg2, arg3, arg4);
        return tempData == null ? null : new PlayerEntity(tempData);
    }

    @MappedMethod
    public void setLightningTicksLeft(int arg0) {
        ((Level)this.data).m_6580_(arg0);
    }

    @Nonnull
    @MappedMethod
    public Scoreboard getScoreboard() {
        return new Scoreboard(((Level)this.data).m_6188_());
    }

    @MappedMethod
    public void playSound(@Nullable PlayerEntity arg0, BlockPos arg1, SoundEvent arg2, SoundCategory arg3, float arg4, float arg5) {
        ((Level)this.data).m_5594_(arg0 == null ? null : (Player)arg0.data, (net.minecraft.core.BlockPos)arg1.data, (net.minecraft.sounds.SoundEvent)arg2.data, arg3.data, arg4, arg5);
    }

    @MappedMethod
    public int getSeaLevel() {
        return ((Level)this.data).m_5736_();
    }

    @MappedMethod
    public void addSyncedBlockEvent(BlockPos arg0, Block arg1, int arg2, int arg3) {
        ((Level)this.data).m_7696_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.Block)arg1.data, arg2, arg3);
    }

    @Nonnull
    @MappedMethod
    public BlockPos getTopPosition(HeightMapType arg0, BlockPos arg1) {
        return new BlockPos(((Level)this.data).m_5452_(arg0.data, (net.minecraft.core.BlockPos)arg1.data));
    }

    @MappedMethod
    public int getNextMapId() {
        return ((Level)this.data).m_7354_();
    }

    @MappedMethod
    public void updateNeighbors(BlockPos arg0, Block arg1) {
        ((Level)this.data).m_46672_((net.minecraft.core.BlockPos)arg0.data, (net.minecraft.world.level.block.Block)arg1.data);
    }

    @MappedMethod
    public boolean getIsClientMapped() {
        return ((Level)this.data).f_46443_;
    }

    @Nonnull
    @MappedMethod
    public Random getRandomMapped() {
        return new Random(((Level)this.data).f_46441_);
    }
}

